% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{RoBMA}
\alias{RoBMA}
\title{Estimate a Robust Bayesian Meta-Analysis}
\usage{
RoBMA(
  d = NULL,
  r = NULL,
  logOR = NULL,
  z = NULL,
  y = NULL,
  se = NULL,
  v = NULL,
  n = NULL,
  lCI = NULL,
  uCI = NULL,
  t = NULL,
  study_names = NULL,
  study_ids = NULL,
  data = NULL,
  transformation = if (is.null(y)) "fishers_z" else "none",
  prior_scale = if (is.null(y)) "cohens_d" else "none",
  effect_direction = "positive",
  model_type = NULL,
  priors_effect = prior(distribution = "normal", parameters = list(mean = 0, sd = 1)),
  priors_heterogeneity = prior(distribution = "invgamma", parameters = list(shape = 1,
    scale = 0.15)),
  priors_bias = list(prior_weightfunction(distribution = "two.sided", parameters =
    list(alpha = c(1, 1), steps = c(0.05)), prior_weights = 1/12),
    prior_weightfunction(distribution = "two.sided", parameters = list(alpha = c(1, 1,
    1), steps = c(0.05, 0.1)), prior_weights = 1/12), prior_weightfunction(distribution =
    "one.sided", parameters = list(alpha = c(1, 1), steps = c(0.05)), prior_weights =
    1/12), prior_weightfunction(distribution = "one.sided", parameters = list(alpha =
    c(1, 1, 1), steps = c(0.025, 0.05)), prior_weights = 1/12),     
    prior_weightfunction(distribution = "one.sided", parameters = list(alpha = c(1, 1,
    1), steps = c(0.05, 0.5)), prior_weights = 1/12), prior_weightfunction(distribution =
    "one.sided", parameters = list(alpha = c(1, 1, 1, 1), steps = c(0.025, 0.05, 0.5)),
    prior_weights = 1/12), prior_PET(distribution = "Cauchy", parameters = list(0, 1),
    truncation = list(0, Inf), prior_weights = 1/4), prior_PEESE(distribution = "Cauchy",
    parameters = list(0, 5), truncation = list(0, Inf), prior_weights = 1/4)),
  priors_effect_null = prior(distribution = "point", parameters = list(location = 0)),
  priors_heterogeneity_null = prior(distribution = "point", parameters = list(location
    = 0)),
  priors_bias_null = prior_none(),
  priors_rho = prior("beta", parameters = list(alpha = 1, beta = 1)),
  priors_rho_null = NULL,
  chains = 3,
  sample = 5000,
  burnin = 2000,
  adapt = 500,
  thin = 1,
  parallel = FALSE,
  autofit = TRUE,
  autofit_control = set_autofit_control(),
  convergence_checks = set_convergence_checks(),
  save = "all",
  seed = NULL,
  silent = TRUE,
  ...
)
}
\arguments{
\item{d}{a vector of effect sizes measured as Cohen's d}

\item{r}{a vector of effect sizes measured as correlations}

\item{logOR}{a vector of effect sizes measured as log odds ratios}

\item{z}{a vector of effect sizes measured as Fisher's z}

\item{y}{a vector of unspecified effect sizes (note that effect size
transformations are unavailable with this type of input)}

\item{se}{a vector of standard errors of the effect sizes}

\item{v}{a vector of variances of the effect sizes}

\item{n}{a vector of overall sample sizes}

\item{lCI}{a vector of lower bounds of confidence intervals}

\item{uCI}{a vector of upper bounds of confidence intervals}

\item{t}{a vector of t/z-statistics}

\item{study_names}{an optional argument with the names of the studies}

\item{study_ids}{an optional argument specifying dependency between the
studies (for using a multilevel model). Defaults to \code{NULL} for
studies being independent.}

\item{data}{a data object created by the \code{combine_data} function. This is
an alternative input entry to specifying the \code{d}, \code{r}, \code{y}, etc...
directly. I.e., you cannot pass the a data.frame and reference to the columns.}

\item{transformation}{transformation to be applied to the supplied
effect sizes before fitting the individual models. Defaults to
\code{"fishers_z"}. We highly recommend using \code{"fishers_z"}
transformation since it is the only variance stabilizing measure
and does not bias PET and PEESE style models. The other options are
\code{"cohens_d"}, correlation coefficient \code{"r"} and \code{"logOR"}.
Supplying \code{"none"} will treat the effect sizes as unstandardized and
refrain from any transformations.}

\item{prior_scale}{a scale used to define priors. Defaults to \code{"cohens_d"}.
Other options are \code{"fishers_z"}, correlation coefficient \code{"r"},
and \code{"logOR"}. The prior scale does not need to match the effect sizes measure -
the samples from prior distributions are internally transformed to match the
\code{transformation} of the data. The \code{prior_scale} corresponds to
the scale of default output, but can be changed within the summary function.}

\item{effect_direction}{the expected direction of the effect. The one-sided
selection sets the weights omega to 1 to significant results in the expected
direction. Defaults to \code{"positive"} (another option is \code{"negative"}).}

\item{model_type}{string specifying the RoBMA ensemble. Defaults to \code{NULL}.
The other options are \code{"PSMA"}, \code{"PP"}, and \code{"2w"} which override
settings passed to the \code{priors_effect}, \code{priors_heterogeneity},
\code{priors_effect}, \code{priors_effect_null}, \code{priors_heterogeneity_null},
\code{priors_bias_null}, and \code{priors_effect}. See details for more information
about the different model types.}

\item{priors_effect}{list of prior distributions for the effect size (\code{mu})
parameter that will be treated as belonging to the alternative hypothesis. Defaults to
a standard normal distribution
\code{prior(distribution = "normal", parameters = list(mean = 0, sd = 1))}.}

\item{priors_heterogeneity}{list of prior distributions for the heterogeneity \code{tau}
parameter that will be treated as belonging to the alternative hypothesis. Defaults to
\code{prior(distribution = "invgamma", parameters = list(shape = 1, scale = .15))} that
is based on heterogeneities estimates from psychology \insertCite{erp2017estimates}{RoBMA}.}

\item{priors_bias}{list of prior distributions for the publication bias adjustment
component that will be treated as belonging to the alternative hypothesis.
Defaults to \code{list(
prior_weightfunction(distribution = "two.sided", parameters = list(alpha = c(1, 1),
    steps = c(0.05)),             prior_weights = 1/12),
prior_weightfunction(distribution = "two.sided", parameters = list(alpha = c(1, 1, 1),
    steps = c(0.05, 0.10)),       prior_weights = 1/12),
prior_weightfunction(distribution = "one.sided", parameters = list(alpha = c(1, 1),
     steps = c(0.05)),             prior_weights = 1/12),
prior_weightfunction(distribution = "one.sided", parameters = list(alpha = c(1, 1, 1),
     steps = c(0.025, 0.05)),      prior_weights = 1/12),
prior_weightfunction(distribution = "one.sided", parameters = list(alpha = c(1, 1, 1),
     steps = c(0.05, 0.5)),        prior_weights = 1/12),
prior_weightfunction(distribution = "one.sided", parameters = list(alpha = c(1, 1, 1, 1),
     steps = c(0.025, 0.05, 0.5)), prior_weights = 1/12),
prior_PET(distribution   = "Cauchy", parameters = list(0,1), truncation = list(0, Inf),
     prior_weights = 1/4),
prior_PEESE(distribution = "Cauchy", parameters = list(0,5), truncation = list(0, Inf),
     prior_weights = 1/4)
)}, corresponding to the RoBMA-PSMA model introduce by \insertCite{bartos2021no;textual}{RoBMA}.}

\item{priors_effect_null}{list of prior distributions for the effect size (\code{mu})
parameter that will be treated as belonging to the null hypothesis. Defaults to
a point null hypotheses at zero,
\code{prior(distribution = "point", parameters = list(location = 0))}.}

\item{priors_heterogeneity_null}{list of prior distributions for the heterogeneity \code{tau}
parameter that will be treated as belonging to the null hypothesis. Defaults to
a point null hypotheses at zero (a fixed effect meta-analytic models),
\code{prior(distribution = "point", parameters = list(location = 0))}.}

\item{priors_bias_null}{list of prior weight functions for the \code{omega} parameter
that will be treated as belonging to the null hypothesis. Defaults no publication
bias adjustment, \code{prior_none()}.}

\item{priors_rho}{list of prior distributions for the variance allocation (\code{rho})
parameter that will be treated as belonging to the alternative hypothesis. This setting allows
users to fit a three-level meta-analysis when \code{study_ids} are supplied. Note that this is
an experimental feature and see News for more details. Defaults to a beta distribution
\code{prior(distribution = "beta", parameters = list(alpha = 1, beta = 1))}.}

\item{priors_rho_null}{list of prior distributions for the variance allocation (\code{rho})
parameter that will be treated as belonging to the null hypothesis. Defaults to \code{NULL}.}

\item{chains}{a number of chains of the MCMC algorithm.}

\item{sample}{a number of sampling iterations of the MCMC algorithm.
Defaults to \code{5000}.}

\item{burnin}{a number of burnin iterations of the MCMC algorithm.
Defaults to \code{2000}.}

\item{adapt}{a number of adaptation iterations of the MCMC algorithm.
Defaults to \code{500}.}

\item{thin}{a thinning of the chains of the MCMC algorithm. Defaults to
\code{1}.}

\item{parallel}{whether the individual models should be fitted in parallel.
Defaults to \code{FALSE}. The implementation is not completely stable
and might cause a connection error.}

\item{autofit}{whether the model should be fitted until the convergence
criteria (specified in \code{autofit_control}) are satisfied. Defaults to
\code{TRUE}.}

\item{autofit_control}{allows to pass autofit control settings with the
\code{\link[=set_autofit_control]{set_autofit_control()}} function. See \code{?set_autofit_control} for
options and default settings.}

\item{convergence_checks}{automatic convergence checks to assess the fitted
models, passed with \code{\link[=set_convergence_checks]{set_convergence_checks()}} function. See
\code{?set_convergence_checks} for options and default settings.}

\item{save}{whether all models posterior distributions should be kept
after obtaining a model-averaged result. Defaults to \code{"all"} which
does not remove anything. Set to \code{"min"} to significantly reduce
the size of final object, however, some model diagnostics and further
manipulation with the object will not be possible.}

\item{seed}{a seed to be set before model fitting, marginal likelihood
computation, and posterior mixing for reproducibility of results. Defaults
to \code{NULL} - no seed is set.}

\item{silent}{whether all print messages regarding the fitting process
should be suppressed. Defaults to \code{TRUE}. Note that \code{parallel = TRUE}
also suppresses all messages.}

\item{...}{additional arguments.}
}
\value{
\code{RoBMA} returns an object of class 'RoBMA'.
}
\description{
\code{RoBMA} is used to estimate a Robust Bayesian
Meta-Analysis. The interface allows a complete customization of
the ensemble with different prior (or list of prior) distributions
for each component.
}
\details{
The default settings of the RoBMA 2.0 package corresponds to the RoBMA-PSMA
ensemble proposed by \insertCite{bartos2021no;textual}{RoBMA}. The previous versions
of the package (i.e., RoBMA < 2.0) used specifications proposed by
\insertCite{maier2020robust;textual}{RoBMA} (this specification can be easily
obtained by setting \code{model_type = "2w"}. The RoBMA-PP specification from
\insertCite{bartos2021no;textual}{RoBMA} can be obtained by setting
\code{model_type = "PP"}.

The \href{../doc/CustomEnsembles.html}{\code{vignette("CustomEnsembles", package = "RoBMA")}}
and \href{../doc/ReproducingBMA.html}{\code{vignette("ReproducingBMA", package = "RoBMA")}}
vignettes  describe how to use \code{\link[=RoBMA]{RoBMA()}} to fit custom meta-analytic ensembles (see \code{\link[=prior]{prior()}},
\code{\link[=prior_weightfunction]{prior_weightfunction()}}, \code{\link[=prior_PET]{prior_PET()}}, and \code{\link[=prior_PEESE]{prior_PEESE()}} for more information about prior
distributions).

The RoBMA function first generates models from a combination of the
provided priors for each of the model parameters. Then, the individual models
are fitted using \link[runjags]{autorun.jags} function. A marginal likelihood
is computed using \link[bridgesampling]{bridge_sampler} function. The individual
models are then combined into an ensemble using the posterior model probabilities
using \link[BayesTools]{BayesTools} package.

Generic \code{\link[=summary.RoBMA]{summary.RoBMA()}}, \code{\link[=print.RoBMA]{print.RoBMA()}}, and \code{\link[=plot.RoBMA]{plot.RoBMA()}} functions are
provided to facilitate manipulation with the ensemble. A visual check of the
individual model diagnostics can be obtained using the \code{\link[=diagnostics]{diagnostics()}} function.
The fitted model can be further updated or modified by \code{\link[=update.RoBMA]{update.RoBMA()}} function.
}
\examples{
\dontrun{
# using the example data from Bem 2011 and fitting the default (RoBMA-PSMA) model
fit <- RoBMA(d = Bem2011$d, se = Bem2011$se, study_names = Bem2011$study)

# in order to speed up the process, we can turn the parallelization on
fit <- RoBMA(d = Bem2011$d, se = Bem2011$se, study_names = Bem2011$study, parallel = TRUE)

# we can get a quick overview of the model coefficients just by printing the model
fit

# a more detailed overview using the summary function (see '?summary.RoBMA' for all options)
summary(fit)

# the model-averaged effect size estimate can be visualized using the plot function
# (see ?plot.RoBMA for all options)
plot(fit, parameter = "mu")

# forest plot can be obtained with the forest function (see ?forest for all options)
forest(fit)

# plot of the individual model estimates can be obtained with the plot_models function
#  (see ?plot_models for all options)
plot_models(fit)

# diagnostics for the individual parameters in individual models can be obtained using diagnostics
# function (see 'diagnostics' for all options)
diagnostics(fit, parameter = "mu", type = "chains")

# the RoBMA-PP can be fitted with addition of the 'model_type' argument
fit_PP <- RoBMA(d = Bem2011$d, se = Bem2011$se, study_names = Bem2011$study, model_type = "PP")

# as well as the original version of RoBMA (with two weightfunctions)
fit_original <- RoBMA(d = Bem2011$d, se = Bem2011$se, study_names = Bem2011$study,
                      model_type = "2w")

# or different prior distribution for the effect size (e.g., a half-normal distribution)
# (see 'vignette("CustomEnsembles")' for a detailed guide on specifying a custom model ensemble)
fit <- RoBMA(d = Bem2011$d, se = Bem2011$se, study_names = Bem2011$study,
             priors_effect = prior("normal", parameters = list(0, 1),
                                   truncation = list(0, Inf)))
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=summary.RoBMA]{summary.RoBMA()}}, \code{\link[=update.RoBMA]{update.RoBMA()}}, \code{\link[=check_setup]{check_setup()}}
}
