% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{summary.RoBMA}
\alias{summary.RoBMA}
\title{Summarize fitted RoBMA object}
\usage{
\method{summary}{RoBMA}(
  object,
  type = if (diagnostics) "models" else "ensemble",
  conditional = FALSE,
  diagnostics = FALSE,
  include_theta = FALSE,
  probs = c(0.025, 0.975),
  logBF = FALSE,
  BF01 = FALSE,
  digits_estimates = 3,
  digits_BF = 3,
  ...
)
}
\arguments{
\item{object}{a fitted RoBMA object.}

\item{type}{whether to show the overall RoBMA results (\code{"ensemble"}),
an overview of the individual models (\code{"models"}), or detailed summary
for the individual models (\code{"individual"}).}

\item{conditional}{show the conditional estimates (assuming that the
alternative is true). Defaults to \code{FALSE}. Only available for
\code{type == "conditional"}.}

\item{diagnostics}{show the maximum R-hat and minimum ESS for the main
parameters in each of the models. Only available for \code{type = "ensemble"}.}

\item{include_theta}{whether the estimated random effects should be included
either in the summaries.}

\item{probs}{quantiles of the posterior samples to be displayed.
Defaults to \code{c(.025, .50, .975)}}

\item{logBF}{show log of the BFs. Defaults to \code{FALSE}.}

\item{BF01}{show BF in support of the null hypotheses. Defaults to
\code{FALSE}.}

\item{digits_estimates}{a number of decimals for rounding the estimates.
Defaults to \code{3}.}

\item{digits_BF}{a number of decimals for rounding the BFs. Defaults to \code{3}.}

\item{...}{additional arguments}
}
\value{
summary of a RoBMA object
}
\description{
\code{summary.RoBMA} creates a numerical
summary of the RoBMA object.
}
\note{
See \code{\link[=diagnostics]{diagnostics()}} for visual convergence checks of the individual models.
}
\examples{
\dontrun{
# using the example data from Anderson et al. 2010 and fitting the default model
# (note that the model can take a while to fit)
fit <- RoBMA(r = Anderson2010$r, n = Anderson2010$n, study_names = Anderson2010$labels)

# summary can provide many details about the model
summary(fit)

# note that the summary function contains additional arguments
# that allow to obtain a specific output, i.e, the conditional estimates
# (assuming that the non-null models are true) can be obtained
summary(fit, conditional = TRUE)

# overview of the models and their prior and posterior probability, marginal likelihood,
# and inclusion Bayes factor:
summary(fit, type = "models")

# and the model diagnostics overview, containing maximum R-hat and minimum ESS across parameters
# but see '?diagnostics' for diagnostics plots for individual model parameters
summary(fit, type = "models", diagnostics = TRUE)

# summary of individual models and their parameters can be further obtained by
summary(fit, type = "individual")

}
}
\seealso{
\code{\link[=RoBMA]{RoBMA()}} \code{\link[=diagnostics]{diagnostics()}}
}
