% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rte_build_rdn_test.R
\name{rte.build.rdn.test}
\alias{rte.build.rdn.test}
\title{Build random tests from LaTeX file}
\usage{
rte.build.rdn.test(list.in, f.out, n.test, n.question,
  latex.dir.out = "latexOut", pdf.dir.out = "PdfOut",
  latex.compile.fct = "texi2pdf", do.randomize.questions = T,
  do.randomize.answers = T, do.clean.up = T)
}
\arguments{
\item{list.in}{A list with all the information of the LaTeX file. Usually the
output from funtion rte.analyze.tex.file()}

\item{f.out}{The name for the pdf files (e.g. using f.out <- 'RdnTest_', the
code will create files 'RdnTest_1.pdf', 'RdnTest_2.pdf', and so on)}

\item{n.test}{The number of random exams to be build (usually the number of
students in class)}

\item{n.question}{The number of questions in each exam (If the LaTeX file has
N questions, the code will randomly select n.question of these)}

\item{latex.dir.out}{The name of the folder where the files from the latex
compilation should go (will create if not found)}

\item{pdf.dir.out}{The name of the folder where the pdf files from the latex
compilation should go (will create if not found)}

\item{latex.compile.fct}{Option for defining function that calls pdflatex ('texi2pdf' (default) or 'custom').}

\item{do.randomize.questions}{Do you want the order of the questions to be
random? (TRUE or FALSE)}

\item{do.randomize.answers}{Do you want the order of the answers to be
random? (TRUE or FALSE)}

\item{do.clean.up}{Should R clean up all extra files from the LaTeX
compilations and leave only the pdf? (select FALSE if you want see the log
files from latex)}
}
\value{
A list with the following items: \describe{ \item{df.answer.wide}{A dataframe
  with the tests, order of questions and correct answers}
  \item{answer.matrix}{A matrix with the correct answers (rows = version, columns = questions)} }
}
\description{
This function will take as input a list from rte.analyze.tex.file and use it
to build pdf files of random exams. See the package vignette for details on
how to use it.
}
\examples{
# define some options
latex.dir.out = 'latexOut' # Name of folder where latex files are going (will create if not exists)
pdf.dir.out = 'PdfOut'     # Name of folder where resulting pdf files are going
f.out <- 'MyRandomTest_'   # Name of pdfs (MyRandomTest_1.pdf, MyRandomTest_2.pdf, ... )
n.test <- 1                # Number of tests to build
n.question <- 2            # Number of questions in each test

# Get latex example from package
f.in <- system.file("extdata", "MyRandomTest_examdesign.tex", package = "RndTexExams")

# Break latex file into a R list
list.out <- rte.analyze.tex.file(f.in,
                                 latex.dir.out = latex.dir.out,
                                 pdf.dir.out = pdf.dir.out)

# Build pdfs
result.out <- rte.build.rdn.test(list.in = list.out,
                                 f.out = f.out,
                                 n.test = n.test,
                                 n.question = n.question,
                                 latex.dir.out = latex.dir.out,
                                 pdf.dir.out = pdf.dir.out)

}

