/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command.store.amq.reader;

import java.util.Iterator;
import javax.jms.Message;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.console.command.store.amq.reader.AMQReader;
import org.apache.activemq.console.command.store.amq.reader.MessageLocation;
import org.apache.activemq.filter.BooleanExpression;
import org.apache.activemq.filter.MessageEvaluationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AMQIterator
implements Iterator<Message> {
    private AMQReader reader;
    private BooleanExpression expression;
    private MessageLocation currentLocation;
    private MessageLocation nextLocation;
    private boolean valid = true;

    AMQIterator(AMQReader reader, BooleanExpression expression) {
        this.reader = reader;
        this.expression = expression;
    }

    @Override
    public boolean hasNext() {
        try {
            Message next;
            this.nextLocation = this.reader.getNextMessage(this.currentLocation);
            Message message = next = this.nextLocation != null ? this.nextLocation.getMessage() : null;
            if (this.expression == null) {
                return next != null;
            }
            while (next != null) {
                MessageEvaluationContext context = new MessageEvaluationContext();
                context.setMessageReference((MessageReference)((Object)next));
                if (this.expression.matches(context)) {
                    return true;
                }
                this.nextLocation = this.reader.getNextMessage(this.currentLocation);
                next = this.nextLocation != null ? this.nextLocation.getMessage() : null;
            }
            this.valid = false;
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get next message from reader ", e);
        }
    }

    @Override
    public Message next() {
        if (this.valid && (this.nextLocation != null || this.hasNext())) {
            this.currentLocation = this.nextLocation;
            return this.nextLocation.getMessage();
        }
        return null;
    }

    @Override
    public void remove() {
        throw new IllegalStateException("Not supported");
    }
}

