% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semidevEstimation.R
\name{semidevEstimation}
\alias{semidevEstimation}
\title{Estimation of the semideviation}
\usage{
semidevEstimation(rets, control = list())
}
\arguments{
\item{rets}{a \eqn{(T \times N)}{(T x N)} matrix of past returns.}

\item{control}{control parameters (see *Details*).}
}
\value{
A \eqn{(N \times 1)}{(N x 1)} vector of semideviations.
}
\description{
Function which computes the semideviation.
}
\details{
The argument \code{control} is a list that can supply any of the following
components:

\itemize{
\item \code{type} method used to compute the semideviation
vector, among \code{'naive'} and \code{'ewma'} where:

\code{'naive'} is used to compute the simple semideviation.

\code{'ewma'} is used to compute the exponential weighted moving average
semideviation. The data must be sorted from the oldest to the latest. See RiskMetrics (1996).

The semideviation for one stock is computed as follows. First we select the
returns which are smaller than the average of the past returns; we get a new
vector of dimension \eqn{K \times 1, K \le N}{Kx1,K<=N}. Then, the weight \eqn{w_i}{w_i}
for each observation at its corresponding time \eqn{t} is computed as \eqn{w
= \lambda^{t}}{w=lambda^t}. We obtain a \eqn{K \times 1}{Kx1} vector. The vector of
weights is then normalized.  Finally, the semideviation is obtained as the
weighted standard deviation.

Default: \code{type = 'naive'}.

\item \code{lambda} decay parameter. Default: \code{lambda = 0.94}.
}
}
\examples{
# Load returns of assets or portfolios
data("Industry_10")
rets = Industry_10

# Naive semideviation estimation
semidevEstimation(rets)

# Naive estimation of the semideviation
semidevEstimation(rets, control = list(type = 'naive'))

# Ewma estimation of the semideviation. Default lambda = 0.94
semidevEstimation(rets, control = list(type = 'ewma'))

# Ewma estimation of the semideviation. lambda = 0.9
semidevEstimation(rets, control = list(type = 'ewma', lambda = 0.9))
}
\author{
David Ardia, Kris Boudt and Jean-Philippe Gagnon Fleury.
}
\references{
RiskMetrics (1996)
\emph{RiskMetrics Technical Document}.
J. P. Morgan/Reuters. 
\url{https://www.msci.com/documents/10199/5915b101-4206-4ba0-aee2-3449d5c7e95a}
}
\keyword{htest}

