% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_read_group_sets}
\alias{search_read_group_sets}
\title{Search for Read Group Sets}
\usage{
search_read_group_sets(client, dataset_id = NULL, bio_sample_id = NULL,
  name = NULL, page_size = NULL, page_token = NULL)
}
\arguments{
\item{client}{A ga4gh_client object}

\item{dataset_id}{The ID of the Dataset to search within}

\item{bio_sample_id}{Specifying the id of a BioSample record will return only readgroups
with the given bio_sample_id.}

\item{name}{Only return read group sets with this name (case-sensitive, exact match).}

\item{page_size}{Specifies the maximum number of results to return in a single page.
If unspecified, the client default will be used.}

\item{page_token}{The continuation token, which is used to page through
large result sets. To get the next page of results, set this parameter to
the value of nextPageToken from the previous response.}
}
\description{
Search for Read Group Sets
}
\examples{

ref_client <- ga4gh_client("http://1kgenomes.ga4gh.org", api_location = "")

\dontrun{
library(magrittr)
## Find a dataset to search in
datasets <- ref_client \%>\% search_datasets() \%>\% content()
d_id <- datasets$datasets[[1]]$id

## Search for read group sets in the dataset
read_group_sets <- ref_client \%>\% search_read_group_sets(d_id) \%>\% content()
read_group_sets
}
}

