% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fpredinterval.R
\name{fpredinterval}
\alias{fpredinterval}
\title{FSSA Forecasting Bootstrap Prediction Interval}
\usage{
fpredinterval(
  Y,
  O,
  L,
  ntriples,
  Bt,
  h = 1,
  alpha = 0.05,
  method = "recurrent",
  tol = 10^-3
)
}
\arguments{
\item{Y}{an object of class \code{\link{funts}}.}

\item{O}{a positive integer specifying the training set size.}

\item{L}{a positive integer specifying the window length.}

\item{ntriples}{the number of eigentriples to use for forecasts.}

\item{Bt}{a positive integer specifying the number of bootstrap samples.}

\item{h}{an integer specifying the forecast horizon.}

\item{alpha}{a double (0 < alpha < 1) specifying the significance level.}

\item{method}{a character string: "recurrent" or "vector" forecasting.}

\item{tol}{a double specifying tolerated error in the approximation.}
}
\value{
a list of numeric vectors: point forecast, lower, and upper bounds.
}
\description{
Calculate the bootstrap prediction interval for functional singular
spectrum analysis (FSSA) forecasting predictions of univariate functional
time series (\code{\link{funts}}) observed over a one-dimensional domain.
}
\examples{
\dontrun{
data("Callcenter")
pred_interval <- fpredinterval(
  Y = Callcenter, O = 310,
  L = 28, ntriples = 7, Bt = 10000, h = 3
)

# Plot the forecast and prediction interval using ggplot
df <- data.frame(
  x = 1:240,
  y = pred_interval$forecast,
  lower = pred_interval$lower,
  upper = pred_interval$upper
)
require(ggplot2)
# Create the ggplot
ggplot(df, aes(x = x, y = y)) +
  geom_line(linewidth = 1.2) +
  scale_x_continuous(
    name = "Time",
    breaks = c(1, 60, 120, 180, 240),
    labels = c("00:00", "06:00", "12:00", "18:00", "24:00"),
  ) +
  scale_y_continuous(name = "Sqrt of Call Numbers") +
  ggtitle("Prediction Intervals for Jan. 3, 2000") +
  geom_ribbon(aes(ymin = lower, ymax = upper), fill = "darkolivegreen3", alpha = 0.3) +
  theme_minimal()
}

}
