% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ftsarithmetic.R
\name{+.fts}
\alias{+.fts}
\title{Addition of Functional Time Series}
\usage{
\method{+}{fts}(Y1, Y2)
}
\arguments{
\item{Y1}{An object of class \code{\link{fts}} or numeric.}

\item{Y2}{An object of class \code{\link{fts}} or numeric.}
}
\value{
An object of class \code{\link{fts}}.
}
\description{
A method for functional time series (\code{\link{fts}}) addition and fts-scalar addition. Note that if the fts is multivariate
then a vector of numerics may be provided allowing for addition of different scalars to different variables. For example, multivariate fts-numeric addition
follows the form of \code{Y+c(1,2)} if \code{Y} is a bivariate fts.
}
\examples{
\dontrun{
require(Rfssa)
load_github_data("https://github.com/haghbinh/Rfssa/blob/master/data/Callcenter.RData")
D <- matrix(sqrt(Callcenter$calls), nrow = 240)
u <- seq(0, 1, length.out = 240) # Define domain of functional data
d <- 22 # number of basis elements
Y <- Rfssa::fts(list(D), list(list(d, "bspline")), list(u))
plot(Y)
Yplus <- Y + Y # add the functional time series to itself
plot(Yplus)
Yplus2 <- Y + 2 # add 2 to every term in the functional time series
plot(Yplus2)
}
}
\seealso{
\code{\link{fts}}
}
