/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.io3.stores;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.contenttype.ContentTypeManager;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.io3.stores.PartStore;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;
import org.docx4j.openpackaging.parts.WordprocessingML.OleObjectBinaryPart;
import org.docx4j.openpackaging.parts.XmlPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class ZipPartStore
implements PartStore {
    private static Logger log = LoggerFactory.getLogger(ZipPartStore.class);
    HashMap<String, ByteArray> partByteArrays;
    private PartStore sourcePartStore;
    private ZipOutputStream zos;

    public ZipPartStore() {
    }

    public ZipPartStore(File f) throws Docx4JException {
        log.info("Filepath = " + f.getPath());
        ZipFile zf = null;
        try {
            if (!f.exists()) {
                log.info("Couldn't find " + f.getPath());
            }
            zf = new ZipFile(f);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new Docx4JException("Couldn't get ZipFile", ioe);
        }
        this.partByteArrays = new HashMap();
        Enumeration<? extends ZipEntry> entries = zf.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            Object in = null;
            try {
                byte[] bytes = this.getBytesFromInputStream(zf.getInputStream(entry));
                this.partByteArrays.put(entry.getName(), new ByteArray(bytes));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            zf.close();
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
    }

    public ZipPartStore(InputStream is) throws Docx4JException {
        this.partByteArrays = new HashMap();
        try {
            ZipInputStream zis = new ZipInputStream(is);
            ZipEntry entry = null;
            while ((entry = zis.getNextEntry()) != null) {
                byte[] bytes = this.getBytesFromInputStream(zis);
                this.partByteArrays.put(entry.getName(), new ByteArray(bytes));
            }
            zis.close();
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new Docx4JException("Error processing zip file (is it a zip file?)", e);
        }
    }

    public void setSourcePartStore(PartStore partStore) {
        this.sourcePartStore = partStore;
    }

    public boolean partExists(String partName) {
        return this.partByteArrays.get(partName) != null;
    }

    private byte[] getBytesFromInputStream(InputStream is) throws Exception {
        BufferedInputStream bufIn = new BufferedInputStream(is);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(baos);
        int c = bufIn.read();
        while (c != -1) {
            bos.write(c);
            c = bufIn.read();
        }
        bos.flush();
        baos.flush();
        bos.close();
        return baos.toByteArray();
    }

    public InputStream loadPart(String partName) throws Docx4JException {
        ByteArray bytes = this.partByteArrays.get(partName);
        if (bytes == null) {
            if (partName.endsWith(".rels")) {
                log.debug("part '" + partName + "' not present in part store");
            } else {
                log.warn("part '" + partName + "' not present in part store");
            }
            return null;
        }
        return bytes.getInputStream();
    }

    public long getPartSize(String partName) throws Docx4JException {
        ByteArray bytes = this.partByteArrays.get(partName);
        if (bytes == null) {
            return -1L;
        }
        return bytes.getLength();
    }

    public void setOutputStream(OutputStream os) {
        this.zos = new ZipOutputStream(os);
    }

    public void saveContentTypes(ContentTypeManager ctm) throws Docx4JException {
        try {
            this.zos.putNextEntry(new ZipEntry("[Content_Types].xml"));
            ctm.marshal(this.zos);
            this.zos.closeEntry();
        }
        catch (Exception e) {
            throw new Docx4JException("Error marshalling Content_Types ", e);
        }
    }

    public void saveJaxbXmlPart(JaxbXmlPart part) throws Docx4JException {
        String targetName = part.getPartName().getName().equals("_rels/.rels") ? part.getPartName().getName() : part.getPartName().getName().substring(1);
        try {
            this.zos.putNextEntry(new ZipEntry(targetName));
            if (part.isUnmarshalled()) {
                log.debug("marshalling " + part.getPartName());
                part.marshal(this.zos);
            } else {
                if (this.sourcePartStore == null) {
                    throw new Docx4JException("part store has changed, and sourcePartStore not set");
                }
                if (this.sourcePartStore == this) {
                    log.debug(part.getPartName() + " is clean");
                    ByteArray bytes = this.partByteArrays.get(part.getPartName().getName().substring(1));
                    if (bytes == null) {
                        throw new IOException("part '" + part.getPartName() + "' not found");
                    }
                    this.zos.write(bytes.getBytes());
                } else {
                    InputStream is = this.sourcePartStore.loadPart(part.getPartName().getName().substring(1));
                    int read = 0;
                    byte[] bytes = new byte[1024];
                    while ((read = is.read(bytes)) != -1) {
                        this.zos.write(bytes, 0, read);
                    }
                    is.close();
                }
            }
            this.zos.closeEntry();
        }
        catch (Exception e) {
            throw new Docx4JException("Error marshalling JaxbXmlPart " + part.getPartName(), e);
        }
    }

    public void saveCustomXmlDataStoragePart(CustomXmlDataStoragePart part) throws Docx4JException {
        String targetName = part.getPartName().getName().substring(1);
        try {
            this.zos.putNextEntry(new ZipEntry(targetName));
            part.getData().writeDocument(this.zos);
            this.zos.closeEntry();
        }
        catch (Exception e) {
            throw new Docx4JException("Error marshalling CustomXmlDataStoragePart " + part.getPartName(), e);
        }
    }

    public void saveXmlPart(XmlPart part) throws Docx4JException {
        String targetName = part.getPartName().getName().substring(1);
        try {
            this.zos.putNextEntry(new ZipEntry(targetName));
            Document doc = part.getDocument();
            DOMSource source = new DOMSource(doc);
            XmlUtils.getTransformerFactory().newTransformer().transform(source, new StreamResult(this.zos));
            this.zos.closeEntry();
        }
        catch (Exception e) {
            throw new Docx4JException("Error marshalling XmlPart " + part.getPartName(), e);
        }
    }

    public void saveBinaryPart(Part part) throws Docx4JException {
        String resolvedPartUri = part.getPartName().getName().substring(1);
        try {
            byte[] bytes = null;
            if (((BinaryPart)part).isLoaded()) {
                bytes = ((BinaryPart)part).getBytes();
            } else {
                if (this.sourcePartStore == null) {
                    throw new Docx4JException("part store has changed, and sourcePartStore not set");
                }
                if (this.sourcePartStore == this) {
                    log.debug(part.getPartName() + " is clean");
                    ByteArray byteArray = this.partByteArrays.get(part.getPartName().getName().substring(1));
                    if (byteArray == null) {
                        throw new IOException("part '" + part.getPartName() + "' not found");
                    }
                    bytes = byteArray.getBytes();
                } else {
                    InputStream is = this.sourcePartStore.loadPart(part.getPartName().getName().substring(1));
                    bytes = IOUtils.toByteArray((InputStream)is);
                }
            }
            if (part instanceof OleObjectBinaryPart) {
                ZipEntry ze = new ZipEntry(resolvedPartUri);
                ze.setMethod(0);
                ze.setSize(bytes.length);
                ze.setCompressedSize(bytes.length);
                CRC32 crc = new CRC32();
                crc.update(bytes);
                ze.setCrc(crc.getValue());
                this.zos.putNextEntry(ze);
            } else {
                this.zos.putNextEntry(new ZipEntry(resolvedPartUri));
            }
            this.zos.write(bytes);
            this.zos.closeEntry();
        }
        catch (Exception e) {
            throw new Docx4JException("Failed to put binary part", e);
        }
        log.info("success writing part: " + resolvedPartUri);
    }

    public void finishSave() throws Docx4JException {
        try {
            this.zos.close();
        }
        catch (Exception e) {
            throw new Docx4JException("Failed to put binary part", e);
        }
    }

    public void dispose() {
    }

    public static class ByteArray
    implements Serializable {
        private static final long serialVersionUID = -784146312250361899L;
        private byte[] bytes;
        private String mimetype;

        public byte[] getBytes() {
            return this.bytes;
        }

        public String getMimetype() {
            return this.mimetype;
        }

        public ByteArray(byte[] bytes) {
            this.bytes = bytes;
        }

        public ByteArray(ByteBuffer bb, String mimetype) {
            bb.rewind();
            this.bytes = new byte[bb.limit()];
            bb.get(this.bytes, 0, this.bytes.length);
            this.mimetype = mimetype;
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.bytes);
        }

        public int getLength() {
            return this.bytes.length;
        }
    }
}

