/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.markdown.tools;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Span {
    private String blockText;
    private LinkedList<int[]> italicMatches;
    private LinkedList<int[]> boldMatches;
    private LinkedList<int[]> singlebacktickMatches;
    private LinkedList<int[]> doublebacktickMatches;
    private LinkedList<int[]> inlineLinkMatches;
    private LinkedList<int[]> referenceLinkMatches;
    private LinkedList<int[]> inlineImageMatches;
    private LinkedList<int[]> referenceImageMatches;
    private LinkedList<int[]> footnoteMatches;
    static String anybutnoparenthesis = "([\\p{L}\\p{M}\\d\\s!\"#\\$%&'\\[\\]\\*_\\+,\\-\\.=\\:;\\<\\>\\?@`{}\\|~/]*)";
    static String anybutnoparenthesisnorquote = "([\\p{L}\\p{M}\\d\\s!#\\$%&\\[\\]\\*_\\+,\\-\\.=\\:;\\<\\>\\?@`{}\\|~/]*)";
    static String anybutnobracket = "([\\p{L}\\p{M}\\d\\s!\"#\\$%&'\\(\\)\\*_\\+,\\-\\.=\\:;\\<\\>\\?@`{}\\|~/]*)";
    static String paturl = "([ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789\\-_~\\:/\\?#\\[\\]@!\\$&'\\(\\)\\*\\+,;\\.=]*)";

    public Span(String text) {
        this.blockText = text;
    }

    public static void main(String[] argc) {
        String text = "This is a link to the [cr.an] (http://cran.r-project.org/sdf=sdf). **This paragraph** demonstrates note usage[^an-ote]. It also show an example of reference link like this one: [DaringFireball][1].";
        Span tt = new Span(text);
        tt.getEmphasisMatrix();
    }

    public boolean[] getEmphasisMatrix() {
        boolean[] out = new boolean[this.blockText.length() * 9];
        this.flagFootnote();
        this.flagInlineImage();
        this.flagInlineLink();
        this.flagReferenceImage();
        this.flagReferenceLink();
        this.flagBold();
        this.flagItalic();
        this.flagCode();
        boolean[] islink = this.isInlineLink();
        boolean[] isreflink = this.isReferenceLink();
        boolean[] isinlineimage = this.isInlineImage();
        boolean[] isrefimage = this.isReferenceImage();
        boolean[] isfootnote = this.isFootnote();
        boolean[] isbold = this.isBold();
        boolean[] isdoublebacktick = this.isDoubleBacktick();
        boolean[] issinglebacktick = this.isSingleBacktick();
        boolean[] isitalic = this.isItalic();
        int n = 0;
        while (n < this.blockText.length()) {
            out[n] = isbold[n];
            out[1 * this.blockText.length() + n] = issinglebacktick[n];
            out[2 * this.blockText.length() + n] = isdoublebacktick[n];
            out[3 * this.blockText.length() + n] = isitalic[n];
            out[4 * this.blockText.length() + n] = islink[n];
            out[5 * this.blockText.length() + n] = isreflink[n];
            out[6 * this.blockText.length() + n] = isinlineimage[n];
            out[7 * this.blockText.length() + n] = isrefimage[n];
            out[8 * this.blockText.length() + n] = isfootnote[n];
            ++n;
        }
        return out;
    }

    private String protectSpecialSpan() {
        int w;
        StringBuilder text = new StringBuilder(this.blockText);
        char white = ' ';
        int i = 0;
        while (i < this.inlineLinkMatches.size()) {
            w = this.inlineLinkMatches.get(i)[0];
            while (w <= this.inlineLinkMatches.get(i)[1]) {
                text.setCharAt(w, white);
                ++w;
            }
            ++i;
        }
        i = 0;
        while (i < this.inlineImageMatches.size()) {
            w = this.inlineImageMatches.get(i)[0];
            while (w <= this.inlineImageMatches.get(i)[1]) {
                text.setCharAt(w, white);
                ++w;
            }
            ++i;
        }
        i = 0;
        while (i < this.referenceImageMatches.size()) {
            w = this.referenceImageMatches.get(i)[0];
            while (w <= this.referenceImageMatches.get(i)[1]) {
                text.setCharAt(w, white);
                ++w;
            }
            ++i;
        }
        i = 0;
        while (i < this.referenceLinkMatches.size()) {
            w = this.referenceLinkMatches.get(i)[0];
            while (w <= this.referenceLinkMatches.get(i)[1]) {
                text.setCharAt(w, white);
                ++w;
            }
            ++i;
        }
        return text.toString();
    }

    private void flagItalic() {
        this.italicMatches = new LinkedList();
        Pattern pattern = Pattern.compile("(\\*|_)(.+?)\\1");
        String text = this.protectSpecialSpan();
        text = text.replaceAll("(\\*\\*|__)", "  ");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            int[] out = new int[]{matcher.start(), matcher.end() - 1};
            this.italicMatches.add(out);
        }
    }

    private boolean[] isItalic() {
        boolean[] isPositiveMatch = new boolean[this.blockText.length()];
        int n = 0;
        while (n < this.blockText.length()) {
            isPositiveMatch[n] = false;
            ++n;
        }
        int i = 0;
        while (i < this.italicMatches.size()) {
            int w = this.italicMatches.get(i)[0];
            while (w <= this.italicMatches.get(i)[1]) {
                isPositiveMatch[w] = true;
                ++w;
            }
            ++i;
        }
        return isPositiveMatch;
    }

    private void flagBold() {
        this.boldMatches = new LinkedList();
        Pattern pattern = Pattern.compile("(\\*\\*|__)(.+?[*_]*)\\1");
        String text = this.protectSpecialSpan();
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            int[] out = new int[]{matcher.start(), matcher.end() - 1};
            this.boldMatches.add(out);
        }
    }

    private boolean[] isBold() {
        boolean[] isPositiveMatch = new boolean[this.blockText.length()];
        int n = 0;
        while (n < this.blockText.length()) {
            isPositiveMatch[n] = false;
            ++n;
        }
        int i = 0;
        while (i < this.boldMatches.size()) {
            int w = this.boldMatches.get(i)[0];
            while (w <= this.boldMatches.get(i)[1]) {
                isPositiveMatch[w] = true;
                ++w;
            }
            ++i;
        }
        return isPositiveMatch;
    }

    private void flagCode() {
        int[] out;
        this.singlebacktickMatches = new LinkedList();
        this.doublebacktickMatches = new LinkedList();
        String text = this.protectSpecialSpan();
        Pattern pattern = Pattern.compile("(`)(.+?)\\1");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            out = new int[]{matcher.start(), matcher.end() - 1};
            this.singlebacktickMatches.add(out);
        }
        pattern = Pattern.compile("(``)(.+?)\\1");
        matcher = pattern.matcher(text);
        while (matcher.find()) {
            out = new int[]{matcher.start(), matcher.end() - 1};
            this.doublebacktickMatches.add(out);
        }
    }

    private boolean[] isSingleBacktick() {
        boolean[] isPositiveMatch = new boolean[this.blockText.length()];
        int n = 0;
        while (n < this.blockText.length()) {
            isPositiveMatch[n] = false;
            ++n;
        }
        int i = 0;
        while (i < this.singlebacktickMatches.size()) {
            int w = this.singlebacktickMatches.get(i)[0];
            while (w <= this.singlebacktickMatches.get(i)[1]) {
                isPositiveMatch[w] = true;
                ++w;
            }
            ++i;
        }
        return isPositiveMatch;
    }

    private boolean[] isDoubleBacktick() {
        boolean[] isPositiveMatch = new boolean[this.blockText.length()];
        int n = 0;
        while (n < this.blockText.length()) {
            isPositiveMatch[n] = false;
            ++n;
        }
        int i = 0;
        while (i < this.doublebacktickMatches.size()) {
            int w = this.doublebacktickMatches.get(i)[0];
            while (w <= this.doublebacktickMatches.get(i)[1]) {
                isPositiveMatch[w] = true;
                ++w;
            }
            ++i;
        }
        return isPositiveMatch;
    }

    private void flagInlineLink() {
        this.inlineLinkMatches = new LinkedList();
        Pattern pattern = Pattern.compile("(\\[" + anybutnobracket + "\\]" + "\\s*" + "\\(" + "\\s*" + paturl + "\\s*" + "(" + "(['\"])" + anybutnoparenthesisnorquote + "\\5" + ")?" + "\\)" + ")");
        Matcher matcher = pattern.matcher(this.blockText);
        while (matcher.find()) {
            int[] out = new int[]{matcher.start(), matcher.end() - 1};
            this.inlineLinkMatches.add(out);
        }
    }

    private boolean[] isInlineLink() {
        boolean[] isPositiveMatch = new boolean[this.blockText.length()];
        int n = 0;
        while (n < this.blockText.length()) {
            isPositiveMatch[n] = false;
            ++n;
        }
        int i = 0;
        while (i < this.inlineLinkMatches.size()) {
            int w = this.inlineLinkMatches.get(i)[0];
            while (w <= this.inlineLinkMatches.get(i)[1]) {
                isPositiveMatch[w] = true;
                ++w;
            }
            ++i;
        }
        return isPositiveMatch;
    }

    private void flagReferenceLink() {
        this.referenceLinkMatches = new LinkedList();
        Pattern pattern = Pattern.compile("(\\[" + anybutnobracket + "\\]" + "\\s*" + "\\[" + anybutnobracket + "\\]" + ")");
        Matcher matcher = pattern.matcher(this.blockText);
        while (matcher.find()) {
            int[] out = new int[]{matcher.start(), matcher.end() - 1};
            this.referenceLinkMatches.add(out);
        }
    }

    private boolean[] isReferenceLink() {
        boolean[] isPositiveMatch = new boolean[this.blockText.length()];
        int n = 0;
        while (n < this.blockText.length()) {
            isPositiveMatch[n] = false;
            ++n;
        }
        int i = 0;
        while (i < this.referenceLinkMatches.size()) {
            int w = this.referenceLinkMatches.get(i)[0];
            while (w <= this.referenceLinkMatches.get(i)[1]) {
                isPositiveMatch[w] = true;
                ++w;
            }
            ++i;
        }
        return isPositiveMatch;
    }

    private void flagInlineImage() {
        this.inlineImageMatches = new LinkedList();
        Pattern pattern = Pattern.compile("(!\\[" + anybutnobracket + "\\]" + "\\s*" + "\\(" + "\\s*" + paturl + "\\s*" + "(" + "(['\"])" + anybutnoparenthesisnorquote + "\\5" + ")?" + "\\)" + ")");
        Matcher matcher = pattern.matcher(this.blockText);
        while (matcher.find()) {
            int[] out = new int[]{matcher.start(), matcher.end() - 1};
            this.inlineImageMatches.add(out);
        }
    }

    private boolean[] isInlineImage() {
        boolean[] isPositiveMatch = new boolean[this.blockText.length()];
        int n = 0;
        while (n < this.blockText.length()) {
            isPositiveMatch[n] = false;
            ++n;
        }
        int i = 0;
        while (i < this.inlineImageMatches.size()) {
            int w = this.inlineImageMatches.get(i)[0];
            while (w <= this.inlineImageMatches.get(i)[1]) {
                isPositiveMatch[w] = true;
                ++w;
            }
            ++i;
        }
        return isPositiveMatch;
    }

    private void flagReferenceImage() {
        this.referenceImageMatches = new LinkedList();
        Pattern pattern = Pattern.compile("(!\\[" + anybutnobracket + "\\]" + "\\s*" + "\\[" + anybutnobracket + "\\]" + ")");
        Matcher matcher = pattern.matcher(this.blockText);
        while (matcher.find()) {
            int[] out = new int[]{matcher.start(), matcher.end() - 1};
            this.referenceImageMatches.add(out);
        }
    }

    private boolean[] isReferenceImage() {
        boolean[] isPositiveMatch = new boolean[this.blockText.length()];
        int n = 0;
        while (n < this.blockText.length()) {
            isPositiveMatch[n] = false;
            ++n;
        }
        int i = 0;
        while (i < this.referenceImageMatches.size()) {
            int w = this.referenceImageMatches.get(i)[0];
            while (w <= this.referenceImageMatches.get(i)[1]) {
                isPositiveMatch[w] = true;
                ++w;
            }
            ++i;
        }
        return isPositiveMatch;
    }

    private void flagFootnote() {
        this.footnoteMatches = new LinkedList();
        Pattern pattern = Pattern.compile("(\\[\\^" + anybutnobracket + "\\]" + ")");
        Matcher matcher = pattern.matcher(this.blockText);
        while (matcher.find()) {
            int[] out = new int[]{matcher.start(), matcher.end() - 1};
            this.footnoteMatches.add(out);
        }
    }

    private boolean[] isFootnote() {
        boolean[] isPositiveMatch = new boolean[this.blockText.length()];
        int n = 0;
        while (n < this.blockText.length()) {
            isPositiveMatch[n] = false;
            ++n;
        }
        int i = 0;
        while (i < this.footnoteMatches.size()) {
            int w = this.footnoteMatches.get(i)[0];
            while (w <= this.footnoteMatches.get(i)[1]) {
                isPositiveMatch[w] = true;
                ++w;
            }
            ++i;
        }
        return isPositiveMatch;
    }
}

