/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.tables;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import org.lysis.rdata.RCharacter;
import org.lysis.rdata.RDate;
import org.lysis.rdata.RInteger;
import org.lysis.rdata.RList;
import org.lysis.rdata.RLogical;
import org.lysis.rdata.RNumeric;
import org.lysis.rdata.RPercent;
import org.lysis.reporters.tables.GroupColumn;

public class TableBase {
    protected Vector<GroupColumn> groupColsSpecifications = new Vector();
    protected Map<String, String> columnLabels;
    protected RList data = new RList();
    protected Map<String, String[]> fillColors;
    protected Map<String, String[]> fontColors;
    protected Map<String, int[]> mergeInstructions;

    public TableBase() throws FileNotFoundException, IOException {
        this.columnLabels = new LinkedHashMap<String, String>();
        this.fillColors = new LinkedHashMap<String, String[]>();
        this.fontColors = new LinkedHashMap<String, String[]>();
        this.mergeInstructions = new LinkedHashMap<String, int[]>();
    }

    public void setGroupedCols(String colGroupedName, int colspan) {
        GroupColumn gc = new GroupColumn(colGroupedName, colspan);
        this.groupColsSpecifications.add(gc);
    }

    public void setData(String colName, String label, String[] x) {
        Vector<String> cvector = new Vector<String>();
        int i = 0;
        while (i < x.length) {
            cvector.add(x[i]);
            ++i;
        }
        RCharacter robj = new RCharacter(cvector);
        this.data.append(robj, colName);
        this.columnLabels.put(colName, label);
    }

    public void setDateData(String colName, String label, String[] x) {
        Vector<String> cvector = new Vector<String>();
        int i = 0;
        while (i < x.length) {
            cvector.add(x[i]);
            ++i;
        }
        RDate robj = new RDate(cvector);
        this.data.append(robj, colName);
        this.columnLabels.put(colName, label);
    }

    public void setLogicalData(String colName, String label, String[] x) {
        Vector<String> cvector = new Vector<String>();
        int i = 0;
        while (i < x.length) {
            cvector.add(x[i]);
            ++i;
        }
        RLogical robj = new RLogical(cvector);
        this.data.append(robj, colName);
        this.columnLabels.put(colName, label);
    }

    public void setData(String colName, String label, double[] x) {
        Vector<Double> cvector = new Vector<Double>();
        int i = 0;
        while (i < x.length) {
            cvector.add(x[i]);
            ++i;
        }
        RNumeric robj = new RNumeric(cvector);
        this.data.append(robj, colName);
        this.columnLabels.put(colName, label);
    }

    public void setPercentData(String colName, String label, double[] x) {
        Vector<Double> cvector = new Vector<Double>();
        int i = 0;
        while (i < x.length) {
            cvector.add(x[i]);
            ++i;
        }
        RPercent robj = new RPercent(cvector);
        this.data.append(robj, colName);
        this.columnLabels.put(colName, label);
    }

    public void setData(String colName, String label, int[] x) {
        Vector<Integer> cvector = new Vector<Integer>();
        int i = 0;
        while (i < x.length) {
            cvector.add(x[i]);
            ++i;
        }
        RInteger robj = new RInteger(cvector);
        this.data.append(robj, colName);
        this.columnLabels.put(colName, label);
    }

    protected boolean hasGroupColumns() {
        return this.groupColsSpecifications.size() > 0;
    }

    public void setFillColors(String colName, String[] x) {
        this.fillColors.put(colName, x);
    }

    public void setFontColors(String colName, String[] x) {
        this.fontColors.put(colName, x);
    }

    public void setMergeInstructions(String colname, int[] x) {
        this.mergeInstructions.put(colname, x);
    }
}

