% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rho_bounds.R
\name{rho_bounds}
\alias{rho_bounds}
\title{Calculate lower and upper the bounds for pairwise
  correlations}
\usage{
rho_bounds(R, p)
}
\arguments{
\item{R}{Correlation matrix}

\item{p}{Vector of marginal frequencies}
}
\value{
A list with three entries:
 \describe{
\item{\emph{L}}{Matrix of lower bounds}
\item{\emph{U}}{Matrix of upper bounds}
\item{\emph{Z}}{Matrix that indicates whether specified
correlations in R are bigger or smaller than the calculated
bounds}
}
}
\description{
Calculate lower and upper the bounds for pairwise correlations
}
\details{
The function calculates upper and lower bounds for pairwise
correlations given a vector of marginal probabilities as detailed
in Emrich and Piedmonte (1991).
}
\examples{
### A simple example
R <- diag(4)
p <- c(0.1, 0.2, 0.4, 0.5)

rho_bounds(R, p)
}
\references{
Emrich, L.J., Piedmonte, M.R.: A method for generating highdimensional multivariate binary variates. \emph{The American Statistician}, \strong{45(4)}, 302 (1991). \doi{10.1080/00031305.1991.10475828}
}
\author{
Jochen Kruppa, Klaus Jung
}
