\name{vehicles}
\alias{vehicles}
\docType{data}
\title{Automobile Dataset}
\description{This dataset consists of 15 characteristics for 30 vehicles.}
\usage{
  data("vehicles")
}
\format{
  A data frame with 30 entries on the following 15 variables.
  \describe{
    \item{\code{turbo}}{Indicator for vehicles with turbo aspiration.}
    \item{\code{two.doors}}{Indicator for vehicles with two doors.}
    \item{\code{hatchback}}{Indicator for hatchback vehicles.}
    \item{\code{wheel.base}}{Wheelbase of the vehicle.}
    \item{\code{length}}{Length of the vehicle.}
    \item{\code{width}}{Width of the vehicle.}
    \item{\code{height}}{Height of the vehicle.}
    \item{\code{curb.weight}}{Curb weight of the vehicle.}
    \item{\code{eng.size}}{Engine size of the vehicle.}
    \item{\code{horsepower}}{Horsepower of the vehicle.}
    \item{\code{peak.rpm}}{Peak revolutions per minute.}
    \item{\code{price}}{Price in dollars.}
    \item{\code{symbol}}{Insurance risk rating.  A value of +3 indicates that the auto is risky, -3 that it is probably pretty safe.}
    \item{\code{city.mpg}}{Fuel efficiency in city.}
    \item{\code{highway.mpg}}{Fuel efficiency in highway.}
  }
}
\source{
  This dataset is a subset of the vehicles dataset in the R package plsdepot.
}
\references{
1) 1985 Model Import Car and Truck Specifications, 1985 Ward's Automotive Yearbook.
2) Personal Auto Manuals, Insurance Services Office, 160 Water Street, New York, NY 10038. 
3) Insurance Collision Report, Insurance Institute for Highway Safety, Watergate 600, Washington, DC 20037. 

Machine Learning Repository. http://archive.ics.uci.edu/ml/datasets/Automobile}

\keyword{datasets}
