\name{sxenv}
\alias{sxenv}
\title{Fit the scaled predictor envelope model}
\description{
 Fit the scaled predictor envelope model in multivariate linear regression with dimension u. The scaled predictor envelope model is a scale-invariant version of the predictor envelope model.  
}
\usage{
sxenv(X, Y, u, R, asy = TRUE, init = NULL)
}
\arguments{
  \item{X}{Predictors. An n by p matrix, p is the number of predictors. The predictors can be univariate or multivariate, discrete or continuous.}
  \item{Y}{Multivariate responses. An n by r matrix, r is the number of responses and n is number of observations. The responses must be continuous variables.}
  \item{u}{Dimension of the scaled envelope in the predictor space. An integer between 0 and p.}
  \item{R}{The number of replications of the scales. A vector, the sum of all elements of R must be p.}
  \item{asy}{Flag for computing the asymptotic variance of the envelope estimator.  The default is \code{TRUE}. When p and r are large, computing the asymptotic variance can take much time and memory.  If only the envelope estimators are needed, the flag can be set to \code{asy = FALSE}.}
  \item{init}{The user-specified value of Gamma for the scaled envelope subspace in the predictor space. An p by u matrix. The default is the one generated by function sxenvMU.}
}
\details{
  This function fits the scaled envelope model in the predictor space to the responses and predictors, \deqn{
 Y = \mu_{Y} + \eta'\Gamma'\Lambda^{-1} (X - \mu_{X}) + \varepsilon, \Sigma _{X} = \Lambda\Gamma\Omega\Gamma'\Lambda + \Lambda\Gamma_{0}\Omega_{0}\Gamma'_{0}\Lambda
 }
 using the maximum likelihood estimation.  When the dimension of the scaled  envelope in the predictor space is between 1 and p-1, the starting value and blockwise coordinate descent algorithm in Cook et al. (2016) is implemented.  When the dimension is p, then the scaled envelope model in the predictor space degenerates to the standard multivariate linear regression.  When the dimension is 0, it means that X and Y are uncorrelated, and the fitting is different.
}
\value{The output is a list that contains the following components:
\item{beta}{The scaled envelope estimator of the regression coefficients.} 
\item{Sigma}{The scaled envelope estimator of the error covariance matrix.}
\item{Lambda}{The matrix of estimated scale.}
\item{Gamma}{An orthonormal basis of the scaled envelope subspace.}
\item{Gamma0}{An orthonormal basis of the complement of the scaled envelope subspace.}
\item{eta}{The coordinates of beta with respect to Gamma.}
\item{Omega}{The coordinates of Sigma with respect to Gamma.}
\item{Omega0}{The coordinates of Sigma with respect to Gamma0.}
\item{muY}{The mean of Y.}
\item{muX}{The mean of X.}
\item{loglik}{The maximized log likelihood function.}
\item{covMatrix}{The asymptotic covariance of vec(beta). The covariance matrix returned are asymptotic.  For the actual standard errors, multiply by 1 / n.}
\item{asySE}{The asymptotic standard error for elements in beta under the envelope model.  The standard errors returned are asymptotic, for actual standard errors, multiply by 1 / sqrt(n).}
\item{ratio}{The asymptotic standard error ratio of the standard multivariate linear regression estimator over the envelope estimator, for each element in beta.}
\item{n}{The number of observations in the data.}
}
\references{
Cook, R. D., Su, Z. (2016). Scaled Predictor Envelopes and Partial Least Squares Regression. Technometrics 58, 155 - 165.

Cook, R. D., Forzani, L. and Su, Z. (2016) A Note on Fast Envelope Estimation. Journal of Multivariate Analysis. 150, 42-54.
}

\examples{
data(sales)
Y <- sales[, 1:3]
X <- sales[, 4:7]
R <- rep(1, 4)

u <- u.sxenv(X, Y, R)
u

m <- sxenv(X, Y, 2, R)
m$beta
}

