% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMutexGroup.R
\name{getMutexGroup}
\alias{getMutexGroup}
\title{getMutexGroup function}
\usage{
getMutexGroup(A = NULL, PM = NULL, type = "Impurity", lower.tail = TRUE)
}
\arguments{
\item{A}{The binary matrix}

\item{PM}{The corresponding probability matrix of A. It can be computed using function getPM. By default equal to getPM(A)}

\item{type}{one of Coverage, Exclusivity or Impurity. By default is Impurity}

\item{lower.tail}{True if mutually exclusive test. False for co-ocurrence. By default is TRUE.}
}
\value{
A symmetric matrix with the p.value of the corresponding test.
}
\description{
Given a binary matrix and its corresponding probability matrix pij, compute the Poisson Binomial
method to estimate mutual exclusive events.
}
\examples{

  #This first example is a basic 
  #example of how to perform getMutexGroup
  
  data("A_example")
  A2 <- A_example[,1:30]
  A2[1,1:10] <- 1
  A2[2,1:10] <- 0
  A2[3,1:10] <- 0
  A2[1,11:20] <- 0
  A2[2,11:20] <- 1
  A2[3,11:20] <- 0
  A2[1,21:30] <- 0
  A2[2,21:30] <- 0
  A2[3,21:30] <- 1
  PM2 <- getPM(A2)
  A <- A2[1:3,]
  PM <- PM2[1:3,]
  
  getMutexGroup(A, PM, "Impurity")
  getMutexGroup(A, PM, "Coverage")
  getMutexGroup(A, PM, "Exclusivity")
  

}
