% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMutex.R
\name{getMutex}
\alias{getMutex}
\title{getMutex function}
\usage{
getMutex(
  A = NULL,
  PM = getPM(A),
  lower.tail = TRUE,
  mixed = FALSE,
  th = 0.01,
  verbose = FALSE,
  parallel = FALSE
)
}
\arguments{
\item{A}{The binary matrix}

\item{PM}{The corresponding probability matrix of A. It can be computed using function getPM. By default equal to getPM(A)}

\item{lower.tail}{True if mutually exclusive test. False for co-ocurrence. By default is TRUE.}

\item{mixed}{option to compute lower p.values with an exact method. By default TRUE}

\item{th}{upper threshold of p.value to apply the exact method.}

\item{verbose}{The verbosity of the output}

\item{parallel}{If the exact method is executed with a parallel process.}
}
\value{
A symmetric matrix with the p.value of the corresponding test.
}
\description{
Given a binary matrix and its corresponding probability matrix pij, compute the Poisson Binomial
method to estimate mutual exclusive events.
}
\examples{

  #This first example is a basic 
  #example of how to perform getMutex. 
  
  data("A_example")
  PMA <- getPM(A_example)
  mismutex <- getMutex(A=A_example,PM=PMA)
  
  \donttest{
  #The next example, is the same as the first one but,
  # using a matrix of class Matrix. 
  
  data("A_Matrix")
  PMA_Matrix <- getPM(A_Matrix)
  mismutex <- getMutex(A=A_Matrix,PM=PMA_Matrix)
  
  #Finally, the last example, shows a real 
  #example of how to perform this function when using 
  #data from TCGA, Colon Adenocarcinoma in this case. 
  
  data("TCGA_COAD")
  data("PM_COAD")
  
  PM_COAD <- getMutex(TCGA_COAD, PM_COAD)
  }

}
