% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foster.plot.R
\name{foster.plot}
\alias{foster.plot}
\title{Plot based on Foster-Stuart and Diersen-Trenkler statistics}
\usage{
foster.plot(
  XM_T,
  statistic = c("D", "d", "TM"),
  weights = function(t) 1,
  interval = c("ribbon", "errorbar"),
  conf = 0.95,
  colour = "salmon"
)
}
\arguments{
\item{XM_T}{A numeric vector, matrix (or data frame).}

\item{statistic}{A character string indicating the statistic to be 
calculated, i.e., \code{"D"} (for \eqn{\overline{DM}} or 
\eqn{\overline{DM}^\omega}), \code{"d"} (for \eqn{\overline{dM}} or 
\eqn{\overline{dM}^\omega}) and \code{"TM"} (for \eqn{\overline{TM}} or 
\eqn{\overline{TM}^\omega}).}

\item{weights}{A function indicating the weight given to the different 
records according to their position in the series,
e.g., if \code{function(t) t-1} then \eqn{\omega_t = t-1}.}

\item{interval}{A character string indicating the type of display of the 
confidence intervals, \code{"ribbon"} (grey area) or \code{"errorbar"} 
(vertical lines).}

\item{conf}{Numeric value in \eqn{(0,1)}. Confidence level of the two-sided
confidence intervals.}

\item{colour}{Colour used to plot the expected values and the CI.}
}
\value{
A ggplot graph object.
}
\description{
This function constructs a ggplot object to display two-sided
  confidence intervals based on Foster-Stuart and Diersen-Trenkler statistics
  for randomness.
}
\details{
See \code{\link{foster.test}}.
}
\examples{
foster.plot(ZaragozaSeries)
foster.plot(ZaragozaSeries, interval = 'error', conf = 0.9, colour = 1)
foster.plot(ZaragozaSeries, statistic = 'd', weights = function(t) t-1)

}
\references{
Diersen J, Trenkler G (1996). Records Tests for Trend in Location.
\emph{Statistics}, \strong{28}(1), 1-12.
doi:\href{https://doi.org/10.1080/02331889708802543}{10.1080/02331889708802543}

Diersen J, Trenkler G (2001). 
\emph{Weighted record tests for splitted series of observations}. 
En J Kunert, G Trenkler (Eds.), 
Mathematical Statistics with Applications in Biometry. 
Festschrift in Honour of Prof. Dr. Siegfried Schach (pp. 163-178). 
Lohmar: Josef Eul Verlang. 

Foster FG, Stuart A (1954). 
Distribution-Free Tests in Time-Series Based on the Breaking of Records.
\emph{Journal of the Royal Statistical Society. Series B (Methodological)}, 
\strong{16}(1), 1-22.
}
\seealso{
\code{\link{foster.test}}, \code{\link{N.plot}}, 
  \code{\link{N_normal.test}}
}
\author{
Jorge Castillo-Mateo
}
