% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cobb_and_Douglas.R
\name{cobb_douglas_2}
\alias{cobb_douglas_2}
\title{2 inputs Cobb-Douglas Model}
\usage{
cobb_douglas_2(x, TFP = 1, alpha = 0.5, beta = 1 - alpha)
}
\arguments{
\item{x}{is a data frame with two columns.}

\item{TFP}{is the constant of the model. Defaults to 1.}

\item{alpha}{is the first input's elasticity. Defaults to a random number between 0 and 1, rounded to two digits.}

\item{beta}{is the second input's elasticity. Defaults to 1 - alpha.}
}
\value{
Returns a list object with compued y and elasticities.
}
\description{
This function allows you to compute a Cobb-Douglas production/ utility function with two inputs/goods.
}
\examples{

x <- c(3, 4, 5)
y <- c(1, 4, 2)

data <- data.frame(x = x, y = y)

cobb_douglas_2(data)


}
\author{
Pedro Cavalcante Oliveira, Department of Economics, Fluminense Federal University
}
