/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler;

import java.io.Externalizable;
import java.util.HashSet;
import java.util.Map;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.core.base.ClassTypeResolver;
import org.drools.core.base.TypeResolver;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.factmodel.traits.TraitRegistry;
import org.drools.core.rule.DialectRuntimeRegistry;
import org.drools.core.rule.ImportDeclaration;
import org.drools.core.spi.Consequence;
import org.drools.core.util.ClassUtils;
import org.kie.api.definition.rule.Rule;
import org.kie.api.io.Resource;

public class PackageRegistry {
    private static final String[] implicitImports = new String[]{"org.kie.api.definition.rule.*", "org.kie.api.definition.type.*", "org.drools.core.factmodel.traits.Alias", "org.drools.core.factmodel.traits.Trait", "org.drools.core.factmodel.traits.Traitable", "org.drools.core.beliefsystem.abductive.Abductive", "org.drools.core.beliefsystem.abductive.Abducible"};
    private final InternalKnowledgePackage pkg;
    private String dialect;
    private final DialectRuntimeRegistry dialectRuntimeRegistry;
    private final DialectCompiletimeRegistry dialectCompiletimeRegistry;
    private final TypeResolver typeResolver;

    public PackageRegistry(ClassLoader rootClassLoader, KnowledgeBuilderConfigurationImpl pkgConf, InternalKnowledgePackage pkg) {
        this.pkg = pkg;
        this.dialectCompiletimeRegistry = pkgConf.buildDialectRegistry(rootClassLoader, pkgConf, this, pkg);
        this.dialectRuntimeRegistry = pkg.getDialectRuntimeRegistry();
        this.typeResolver = new ClassTypeResolver(new HashSet(this.pkg.getImports().keySet()), rootClassLoader, this.pkg.getName());
        this.typeResolver.addImport(pkg.getName() + ".*");
        for (String implicitImport : implicitImports) {
            this.typeResolver.addImplicitImport(implicitImport);
        }
        pkg.setTypeResolver(this.typeResolver);
    }

    private PackageRegistry(InternalKnowledgePackage pkg, DialectRuntimeRegistry runtimeRegistry, DialectCompiletimeRegistry compiletimeRegistry, TypeResolver typeResolver) {
        this.pkg = pkg;
        this.dialectRuntimeRegistry = runtimeRegistry;
        this.dialectCompiletimeRegistry = compiletimeRegistry;
        this.typeResolver = typeResolver;
    }

    PackageRegistry clonePackage(ClassLoader classLoader) {
        InternalKnowledgePackage clonedPkg = (InternalKnowledgePackage)ClassUtils.deepClone((Externalizable)this.pkg, (ClassLoader)classLoader);
        clonedPkg.setDialectRuntimeRegistry(this.pkg.getDialectRuntimeRegistry());
        for (Rule rule : this.pkg.getRules()) {
            RuleImpl clonedRule = clonedPkg.getRule(rule.getName());
            clonedRule.setConsequence(((RuleImpl)rule).getConsequence());
            if (!((RuleImpl)rule).hasNamedConsequences()) continue;
            for (Map.Entry namedConsequence : ((RuleImpl)rule).getNamedConsequences().entrySet()) {
                clonedRule.addNamedConsequence((String)namedConsequence.getKey(), (Consequence)namedConsequence.getValue());
            }
        }
        PackageRegistry clone = new PackageRegistry(clonedPkg, this.dialectRuntimeRegistry, this.dialectCompiletimeRegistry, this.typeResolver);
        clone.setDialect(this.dialect);
        return clone;
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public InternalKnowledgePackage getPackage() {
        return this.pkg;
    }

    public ClassLoader getPackageClassLoader() {
        return this.getPackage().getPackageClassLoader();
    }

    public DialectRuntimeRegistry getDialectRuntimeRegistry() {
        return this.dialectRuntimeRegistry;
    }

    public DialectCompiletimeRegistry getDialectCompiletimeRegistry() {
        return this.dialectCompiletimeRegistry;
    }

    public void addImport(ImportDescr importDescr) {
        this.registerImport(importDescr.getTarget());
        this.dialectCompiletimeRegistry.addImport(importDescr);
    }

    public void registerImport(String importEntry) {
        this.pkg.addImport(new ImportDeclaration(importEntry));
        this.typeResolver.addImport(importEntry);
    }

    public void addStaticImport(ImportDescr importDescr) {
        this.dialectCompiletimeRegistry.addStaticImport(importDescr);
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public void compileAll() {
        this.dialectCompiletimeRegistry.compileAll();
    }

    public boolean removeObjectsGeneratedFromResource(Resource resource) {
        return this.pkg.removeObjectsGeneratedFromResource(resource);
    }

    public TraitRegistry getTraitRegistry() {
        return this.pkg.getTraitRegistry();
    }
}

