% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_KMMC.R
\name{do.kmmc}
\alias{do.kmmc}
\title{Kernel Maximum Margin Criterion}
\usage{
do.kmmc(
  X,
  label,
  ndim = 2,
  preprocess = c("center", "decorrelate", "whiten"),
  t = 1
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}

\item{t}{bandwidth parameter for heat kernel in \eqn{(0,\infty)}.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
Kernel Maximum Margin Criterion (KMMC) is a nonlinear variant of MMC method using kernel trick.
For computational simplicity, only the gaussian kernel is used with bandwidth parameter \code{t}.
}
\examples{
\donttest{
## load iris data
data(iris)
X     = as.matrix(iris[,1:4])
label = as.factor(iris$Species)

## perform MVP with different preprocessings
out1 = do.kmmc(X, label, t=0.1)
out2 = do.kmmc(X, label, t=1.0)
out3 = do.kmmc(X, label, t=10.0)

## visualize
opar = par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, col=label, main="bandwidth=0.1")
plot(out2$Y, col=label, main="bandwidth=1")
plot(out3$Y, col=label, main="bandwidth=10.0")
par(opar)
}

}
\references{
\insertRef{li_efficient_2006}{Rdimtools}
}
\seealso{
\code{\link{do.mmc}}
}
\author{
Kisung You
}
\concept{nonlinear_methods}
