# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Generate UUIDs Version 5
#'
#' @description
#' Function generates name-based uuid is derived from content in a namespace.
#' A uuid with identical content shall yield the same uuid.
#' Hashing algorithm is SHA1.
#'
#' @param x Character vector.
#' @param ns Namespace string. Allowed values: dns, url, oid, x500dn.
#' @return Character vector with UUIDs.
#'
#' @note
#' This function generates valid uuids for the `NA` and empty strings.
#'
#' @export
#'
#' @references
#' <https://www.boost.org/doc/libs/1_72_0/libs/uuid/doc/uuid.html#Name%20Generator>
#'
#' @export
#'
#' @examples
#' # generate name UUIDs
#' uuid_generate_name(c("one", "two"))
#'
uuid_generate_name <- function(x, ns = "x500dn") {
    .Call(`_RcppUUID_uuid_generate_name`, x, ns)
}

#' @title Generates Nil UUIDs
#'
#' @description
#' Function generates nil uuids.
#'
#' @param n Number of generated UUIDs.
#' @return Character vector with UUIDs.
#'
#' @references
#' <https://www.boost.org/doc/libs/1_72_0/libs/uuid/doc/uuid.html#Nil%20Generator>
#'
#' @export
#'
#' @examples
#' # generate nil UUIDs
#' uuid_generate_nil(2)
#'
uuid_generate_nil <- function(n = 1L) {
    .Call(`_RcppUUID_uuid_generate_nil`, n)
}

#' @title Generate UUIDs Version 4
#'
#' @description
#' Function generates uuids using operating system provided entropy.
#'
#' @param n Number of generated UUIDs.
#' @return Character vector with UUIDs.
#'
#' @export
#'
#' @references
#' <https://www.boost.org/doc/libs/1_72_0/libs/uuid/doc/uuid.html#Random%20Generator>
#'
#' @examples
#' # generate random UUIDs
#' uuid_generate_random(2)
#'
uuid_generate_random <- function(n = 1L) {
    .Call(`_RcppUUID_uuid_generate_random`, n)
}

#' @title Validate UUIDs
#'
#' @description
#' Function validates uuids.
#'
#' @param x Character vector.
#' @return Logical vector.
#'
#' @export
#'
#' @examples
#' # validate UUIDs
#' uuid_validate(uuid_generate_random(2))
#' uuid_validate(uuid_generate_nil(2))
#' uuid_validate(uuid_generate_name(c("one", "two")))
#' uuid_validate(c("a", ""))
#'
uuid_validate <- function(x) {
    .Call(`_RcppUUID_uuid_validate`, x)
}

