% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleClustering.R
\name{clusterDensity}
\alias{clusterDensity}
\title{Clusters density computation}
\usage{
clusterDensity(
  data.sample,
  label,
  space,
  features.to.keep = colnames(data.sample$features[[space]]$x)
)
}
\arguments{
\item{data.sample}{list containing features, profiles and clustering results.}

\item{label}{vector of labels.}

\item{space}{space in which is the feature to deal with.}

\item{features.to.keep}{vector of features names on which the summaries are computed.}
}
\value{
out data.frame containing the density summaries.
}
\description{
Save density summaries results.
}
\details{
clusterDensity computes the clusters density from a clustering result.
}
\examples{

dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
tf1 <- tempfile()
write.table(dat, tf1, sep=",", dec=".")

x <- importSample(file.features=tf1)
x <- computeUnSupervised(x, K=3, method.name="K-means")

label<-x[["clustering"]][["K-means_preprocessed"]][["label"]]

cluster.density <- clusterDensity(x, label, "preprocessed", features.to.keep='V1')


}
\keyword{internal}
