% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KmeansAutoElbow.R
\name{FindNumberK}
\alias{FindNumberK}
\title{Automatic estimation of the number of clusters}
\usage{
FindNumberK(features, Kmax, StopCriteria = 0.99, graph = F)
}
\arguments{
\item{features}{matrix of raw data (point by line).}

\item{Kmax}{maximum number of clusters.}

\item{StopCriteria}{elbow method cumulative explained variance > criteria to stop K-search.}

\item{graph}{boolean: if TRUE, figures for total of within-class inertia and explained variance are plotted.}
}
\value{
K number of clusters obtained.
}
\description{
Compute gap on a similarity matrix obtained from raw data matrix to estimate the number of clusters automatically.
}
\details{
FindNumberK return K number according spectral gap on reduced points
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
           
res <- FindNumberK(dat, Kmax=20, graph=TRUE)

}
\keyword{internal}
