% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_utilities.R
\name{rvn_col_transparent}
\alias{rvn_col_transparent}
\title{Add Transparency to Colours}
\usage{
rvn_col_transparent(colour, trans)
}
\arguments{
\item{colour}{time series containing columns you wish to reseasonalize. xts
object}

\item{trans}{integer describing the degree of transparency, from ~200
(slightly transparent) to <10 (very transparent)}
}
\value{
\item{res}{returned updated colour code with transparency}
}
\description{
rvn_col_transparent is used to adjust colour codes to introduce transparency
}
\details{
Note that this function is not required for ggplot objects, as transparency can be
added with the `alpha` parameter.
}
\examples{

# plot randomly distributed data
plot(rnorm(20),col='black')

# create a transparent blue colour for plotting
mycol <- rvn_col_transparent('red',100)

# plot more random points in transparent red colour
points(rnorm(20),col=mycol)

}
\seealso{
See original code on post in Stack Overflow
\href{http://stackoverflow.com/questions/12995683/any-way-to-make-plot-points-in-scatterplot-more-transparent-in-rmaking}{
plot points transparent in R}

\code{\link{rvn_iscolour}} for checking validity of colour codes
}
