% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{words}
\alias{words}
\title{Rank data: words}
\format{A list containing:
\describe{
  \item{data}{A matrix of size 98*5 containing the 98 answers. Each row corresponding to one ranking (ranking representation).

              The ranking representation r=(r_1,...,r_m) contains the  ranks assigned to the objects, and means that the ith object is in r_ith position.

              For example, if the ranking representation of a rank is (4,3,1,2,5), it means that judge ranks the first object in 4th position, second object in 3rd position, ...}
 \item{frequency}{matrix of size 15*6. Each row corresponds to one of the 15 different observed rankings, and the last column contains the observation frequency.}
  \item{m}{the size of the rankings (m=5).}
}}
\source{
M.A. Fligner and J.S. Verducci. "Distance based ranking models". J. Roy. Statist. Soc. Ser. B, 48(3):359-369, 1986.
}
\description{
The data was collected under the auspices of the Graduate Record
Examination Board. A sample of 98 college students were asked to rank five words according to strength of association (least to most associated) with the target word "Idea":
  A = Thought, B = Play, C = Theory, D = Dream and E = Attention.
}
\examples{
data(sports)

}
\seealso{
Other datasets: 
\code{\link{APA}},
\code{\link{big4}},
\code{\link{eurovision}},
\code{\link{quiz}},
\code{\link{sports}}
}
\concept{datasets}
\keyword{datasets}
