% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarID_functions.R
\name{diffNoisyGenesTB}
\alias{diffNoisyGenesTB}
\title{Function for extracting genes with differential biological variability in a cluster}
\usage{
diffNoisyGenesTB(
  noise,
  cl,
  set,
  bgr = NULL,
  no_cores = 1,
  minobs = 5,
  ps = 0.1,
  rseed = 17000
)
}
\arguments{
\item{noise}{List object with noise parameters returned by the \code{compTBNoise} function.}

\item{cl}{List object with clustering information, returned by the \code{graphCluster} function.}

\item{set}{Postive integer number or vector of integers corresponding to valid cluster numbers. The function reports genes with differential variability in all
clusters contained in \code{set} versus vlusters in \code{bgr}.}

\item{bgr}{Postive integer number or vector of integers corresponding to valid cluster numbers. Background set for comparison. The function reports genes
with differential variability in all clusters contained in \code{set} compared to clusters in \code{bgr}. Default is \code{NULL} and \code{bgr} equals the set of all clusters not in \code{bgr}.}

\item{no_cores}{Positive integer number. Number of cores for multithreading. If set to \code{NULL} then the number of available cores minus two is used. Default is \code{NULL}.}

\item{minobs}{Positive integer number. Only genes with at least \code{minobs} neighbourhoods with non-zero biological noise levels in \code{set} are included for the p-value computation. Otherwise, a p-value or 0.5 is reported. Default is 5.}

\item{ps}{Real number greater or equal to zero. A small random variable sampled from a uniform distribution in the interval \code{[0,ps]} is added to the noise quantification to avoid inclusion of genes with small noise differences. Default is 0.1.}

\item{rseed}{Integer number. Random seed to enforce reproducible results. Default is 17000.}
}
\value{
Data.frame with five columns:
\item{ mu.set}{ Mean expression across clusters in \code{set}. }
\item{ mu.bgr}{ Mean expression across clusters in \code{bgr} (or all clusters not in \code{set}). }
\item{ mu.all}{ Mean expression across clusters in \code{set} and \code{bgr} (or all clusters). }
\item{ eps.set}{ Average variability across clusters in \code{set}. }
\item{ eps.bgr}{ Average variability across clusters in \code{bgr} (or all clusters not in \code{set}). }
\item{ eps.all}{ Average variability across clusters in \code{set} and \code{bgr} (or all clusters). }
\item{log2FC}{log2 fold change of variability between between clusters in \code{set} and clusters in \code{bgr} (or all clusters).}
\item{pvalue}{Banjamini-Hochberg corrected Wilcoxon rank sum test p-value for differential variability.}
Rows are ordered by decreasing log2 fold change of variability.
}
\description{
This function infers genes with differential biological variability in a cluster versus a background set of clusters on the basis of a Wilcoxon rank sum-test between cells in a cluster
and in the background set.
}
\examples{
\dontrun{
res <- pruneKnn(intestinalDataSmall,knn=10,alpha=1,no_cores=1,FSelect=FALSE)
noise <- compTBNoise(res,intestinalDataSmall,pvalue=0.01,genes = NULL,no_cores=1)
cl <- graphCluster(res,pvalue=0.01)
ngenes <- diffNoisyGenesTB(noise,cl,c(1,2),no_cores=1)
}
}
