% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RaModel.R
\name{RaModel}
\alias{RaModel}
\title{Generate data \eqn{(x, y)} from 4 models.}
\usage{
RaModel(Model.No, n, p, p0 = 1/2)
}
\arguments{
\item{Model.No}{model number, which can be 1, 2, 3, 4.}

\item{n}{sample size}

\item{p}{data dimension}

\item{p0}{marginal probability of class 0. Default = 0.5. Only available when Model.No = 1, 2, 3.}
}
\value{
\item{x}{n * p matrix. n observations and p features.}
\item{y}{n 0/1 observations.}
}
\description{
\code{RaModel} generates data from 4 models described in Ye Tian and Yang Feng (2020).
}
\note{
Model 1, 2 and 4 require \eqn{p \ge 5}. Model 3 requires \eqn{p \ge 50}.
}
\examples{
train.data <- RaModel(1, n = 100, p = 50)
xtrain <- train.data$x
ytrain <- train.data$y

}
\seealso{
\code{\link{Rase}}
}
