# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' ZigZagLogistic
#' 
#' Applies the Zig-Zag Sampler to logistic regression, as detailed in Bierkens, Fearnhead, Roberts, The Zig-Zag Process and Super-Efficient Sampling for Bayesian Analysis of Big Data, 2016.
#'
#' @param dataX Matrix containing the independent variables x. The i-th column represents the i-th observation with components x_{1,i}, ..., x_{d,i}.
#' @param dataY Vector of length n containing {0, 1}-valued observations of the dependent variable y.
#' @param n_iterations Integer indicating the number of iterations, i.e. the number of proposed switches.
#' @param x0 Optional argument indicating the starting point for the Zig-Zag sampler
#' @param finalTime If provided and nonnegative, run the sampler until a trajectory of continuous time length finalTime is obtained (ignoring the value of \code{n_iterations})
#' @param subsampling Boolean. Use Zig-Zag with subsampling if TRUE. 
#' @param controlvariates Boolean. Use Zig-Zag with subsampling combined with control variates if TRUE (overriding any value of \code{subsampling}).
#' @param n_samples Number of discrete time samples to extract from the Zig-Zag skeleton.
#' @param n_batches If non-zero, estimate effective sample size through the batch means method, with n_batches number of batches.
#' @param computeCovariance Boolean indicating whether to estimate the covariance matrix.
#' @param upperbound Boolean. If TRUE, sample without subsampling and using a constant upper bound instead of a linear Hessian dependent upper bound
#' @return Returns a list with the following objects:
#' @return \code{skeletonTimes}: Vector of switching times
#' @return \code{skeletonPoints}: Matrix whose columns are locations of switches. The number of columns is identical to the length of \code{skeletonTimes}. Be aware that the skeleton points themselves are NOT samples from the target distribution.
#' @return \code{skeletonDirections}: Matrix whose columns are directions just after switches. The number of columns is identical to the length of \code{skeletonTimes}.
#' @return \code{samples}: If \code{n_samples > 0}, this is a matrix whose \code{n_samples} columns are samples at fixed intervals along the Zig-Zag trajectory. 
#' @return \code{mode}: If \code{controlvariates = TRUE}, this is a vector containing the posterior mode obtained using Newton's method. 
#' @return \code{batchMeans}: If \code{n_batches > 0}, this is a matrix whose \code{n_batches} columns are the batch means
#' @return \code{means}: If \code{n_batches > 0}, this is a vector containing the means of each coordinate along the Zig-Zag trajectory 
#' @return \code{covariance}: If \code{n_batches > 0} or \code{computeCovariance = TRUE}, this is a matrix containing the sample covariance matrix along the trajectory
#' @return \code{asVarEst}: If \code{n_batches > 0} this is an estimate of the asymptotic variance along each component
#' @return \code{ESS}: If \code{n_batches > 0} this is an estimate of the effective sample size along each component
#' @examples
#' require("RZigZag")
#' generate.logistic.data <- function(beta, n.obs) {
#'   dim <- length(beta)
#'   dataX <- rbind(rep(1, n.obs), matrix(rnorm((dim -1) * n.obs), nrow = dim -1));
#'   vals <- colSums(dataX * as.vector(beta))
#'   generateY <- function(p) { rbinom(1, 1, p)}
#'   dataY <- sapply(1/(1 + exp(-vals)), generateY)
#'   return(list(dataX, dataY))
#' }
#'
#' beta <- c(1,2)
#' data <- generate.logistic.data(beta, 1000)
#' result <- ZigZagLogistic(data[[1]], data[[2]], 1000, n_samples = 100)
#' plot(result$skeletonPoints[1,], result$skeletonPoints[2,],type='l',asp=1)
#' points(result$samples[1,], result$samples[2,], col='magenta')
#' @export
ZigZagLogistic <- function(dataX, dataY, n_iterations, x0 = numeric(0), finalTime = -1, subsampling = TRUE, controlvariates = TRUE, n_samples = 0L, n_batches = 0L, computeCovariance = FALSE, upperbound = FALSE) {
    .Call('_RZigZag_ZigZagLogistic', PACKAGE = 'RZigZag', dataX, dataY, n_iterations, x0, finalTime, subsampling, controlvariates, n_samples, n_batches, computeCovariance, upperbound)
}

#' ZigZagGaussian
#' 
#' Applies the Zig-Zag Sampler to a Gaussian target distribution, as detailed in Bierkens, Fearnhead, Roberts, The Zig-Zag Process and Super-Efficient Sampling for Bayesian Analysis of Big Data, 2016.
#' Assume potential of the form \deqn{U(x) = (x - mu)^T V (x - mu)/2,} i.e. a Gaussian with mean vector \code{mu} and covariance matrix \code{inv(V)}
#'
#' @param V the inverse covariance matrix of the Gaussian target distribution
#' @param mu mean of the Gaussian target distribution
#' @param n_iterations Number of algorithm iterations; will result in the equivalent amount of skeleton points in Gaussian case because no rejections are needed.
#' @param x0 starting point
#' @param finalTime If provided and nonnegative, run the sampler until a trajectory of continuous time length finalTime is obtained (ignoring the value of \code{n_iterations})
#' @param n_samples Number of discrete time samples to extract from the Zig-Zag skeleton.
#' @param n_batches If non-zero, estimate effective sample size through the batch means method, with n_batches number of batches.
#' @param computeCovariance Boolean indicating whether to estimate the covariance matrix.
#' @return Returns a list with the following objects:
#' @return \code{skeletonTimes}: Vector of switching times
#' @return \code{skeletonPoints}: Matrix whose columns are locations of switches. The number of columns is identical to the length of \code{skeletonTimes}. Be aware that the skeleton points themselves are NOT samples from the target distribution.
#' @return \code{skeletonDirections}: Matrix whose columns are directions just after switches. The number of columns is identical to the length of \code{skeletonTimes}.
#' @return \code{samples}: If \code{n_samples > 0}, this is a matrix whose \code{n_samples} columns are samples along the Zig-Zag trajectory.
#' @return \code{mode}: Not used for a Gaussian target.
#' @return \code{batchMeans}: If \code{n_batches > 0}, this is a matrix whose \code{n_batches} columns are the batch means
#' @return \code{means}: If \code{n_batches > 0}, this is a vector containing the means of each coordinate along the Zig-Zag trajectory 
#' @return \code{covariance} :If \code{n_batches > 0} or \code{computeCovariance = TRUE}, this is a matrix containing the sample covariance matrix along the trajectory
#' @return \code{asVarEst}: If \code{n_batches > 0} this is an estimate of the asymptotic variance along each component
#' @return \code{ESS}: If \code{n_batches > 0} this is an estimate of the effective sample size along each component
#' @examples
#' V <- matrix(c(3,1,1,3),nrow=2)
#' mu <- c(2,2)
#' x0 <- c(0,0)
#' result <- ZigZagGaussian(V, mu, 100, x0, n_samples = 10)
#' plot(result$skeletonPoints[1,], result$skeletonPoints[2,],type='l',asp=1)
#' points(result$samples[1,], result$samples[2,], col='magenta')
#' @export
ZigZagGaussian <- function(V, mu, n_iterations, x0, finalTime = -1, n_samples = 0L, n_batches = 0L, computeCovariance = FALSE) {
    .Call('_RZigZag_ZigZagGaussian', PACKAGE = 'RZigZag', V, mu, n_iterations, x0, finalTime, n_samples, n_batches, computeCovariance)
}

#' BPSGaussian
#' 
#' Applies the BPS Sampler to a Gaussian target distribution, as detailed in Bouchard-Côté et al, 2017.
#' Assume potential of the form \deqn{U(x) = (x - mu)^T V (x - mu)/2,} i.e. a Gaussian with mean vector \code{mu} and covariance matrix \code{inv(V)}
#'
#' @param V the inverse covariance matrix of the Gaussian target distribution
#' @param mu mean of the Gaussian target distribution
#' @param n_iterations Number of algorithm iterations; will result in the equivalent amount of skeleton points in Gaussian case because no rejections are needed.
#' @param x0 starting point
#' @param finalTime If provided and nonnegative, run the BPS sampler until a trajectory of continuous time length finalTime is obtained (ignoring the value of \code{n_iterations})
#' @param refresh_rate \code{lambda_refresh}
#' @param unit_velocity TRUE indicates velocities uniform on unit sphere, FALSE indicates standard normal velocities
#' @param n_samples Number of discrete time samples to extract from the Zig-Zag skeleton.
#' @param n_batches If non-zero, estimate effective sample size through the batch means method, with n_batches number of batches.
#' @param computeCovariance Boolean indicating whether to estimate the covariance matrix.
#' @return Returns a list with the following objects:
#' @return \code{skeletonTimes}: Vector of switching times
#' @return \code{skeletonPoints}: Matrix whose columns are locations of switches. The number of columns is identical to the length of \code{skeletonTimes}. Be aware that the skeleton points themselves are NOT samples from the target distribution.
#' @return \code{skeletonDirections}: Matrix whose columns are directions just after switches. The number of columns is identical to the length of \code{skeletonTimes}.
#' @return \code{samples}: If \code{n_samples > 0}, this is a matrix whose \code{n_samples} columns are samples along the Zig-Zag trajectory.
#' @return \code{mode}: Not used for a Gaussian target.
#' @return \code{batchMeans}: If \code{n_batches > 0}, this is a matrix whose \code{n_batches} columns are the batch means
#' @return \code{means}: If \code{n_batches > 0}, this is a vector containing the means of each coordinate along the Zig-Zag trajectory 
#' @return \code{covariance} :If \code{n_batches > 0} or \code{computeCovariance = TRUE}, this is a matrix containing the sample covariance matrix along the trajectory
#' @return \code{asVarEst}: If \code{n_batches > 0} this is an estimate of the asymptotic variance along each component
#' @return \code{ESS}: If \code{n_batches > 0} this is an estimate of the effective sample size along each component
#' @examples
#' V <- matrix(c(3,1,1,3),nrow=2)
#' mu <- c(2,2)
#' x0 <- c(0,0)
#' result <- BPSGaussian(V, mu, 100, x0, n_samples = 10)
#' plot(result$skeletonPoints[1,], result$skeletonPoints[2,],type='l',asp=1)
#' points(result$samples[1,], result$samples[2,], col='magenta')
#' @export
BPSGaussian <- function(V, mu, n_iterations, x0, finalTime = -1.0, refresh_rate = 1, unit_velocity = TRUE, n_samples = 0L, n_batches = 0L, computeCovariance = FALSE) {
    .Call('_RZigZag_BPSGaussian', PACKAGE = 'RZigZag', V, mu, n_iterations, x0, finalTime, refresh_rate, unit_velocity, n_samples, n_batches, computeCovariance)
}

