/*
 * Decompiled with CFR 0.152.
 */
package weka.core.expressionlanguage.common;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import weka.core.expressionlanguage.common.Primitives;
import weka.core.expressionlanguage.core.Node;
import weka.core.expressionlanguage.core.VariableDeclarations;

public class SimpleVariableDeclarations
implements VariableDeclarations {
    private Map<String, Node> variables = new HashMap<String, Node>();
    private VariableInitializer initializer = new VariableInitializer();

    @Override
    public boolean hasVariable(String name) {
        return this.variables.containsKey(name);
    }

    @Override
    public Node getVariable(String name) {
        if (!this.variables.containsKey(name)) {
            throw new RuntimeException("Variable '" + name + "' doesn't exist!");
        }
        this.initializer.add(this.variables.get(name));
        return this.variables.get(name);
    }

    public void addBoolean(String name) {
        if (this.variables.containsKey(name)) {
            throw new RuntimeException("Variable '" + name + "' already exists!");
        }
        this.variables.put(name, new Primitives.BooleanVariable(name));
    }

    public void addDouble(String name) {
        if (this.variables.containsKey(name)) {
            throw new RuntimeException("Variable '" + name + "' already exists!");
        }
        this.variables.put(name, new Primitives.DoubleVariable(name));
    }

    public void addString(String name) {
        if (this.variables.containsKey(name)) {
            throw new RuntimeException("Variable '" + name + "' already exists!");
        }
        this.variables.put(name, new Primitives.StringVariable(name));
    }

    public VariableInitializer getInitializer() {
        return this.initializer;
    }

    public static class VariableInitializer
    implements Serializable {
        private Map<String, Node> variables = new HashMap<String, Node>();

        private void add(Node var) {
            assert (var instanceof Primitives.BooleanVariable || var instanceof Primitives.DoubleVariable || var instanceof Primitives.StringVariable);
            if (var instanceof Primitives.BooleanVariable) {
                this.variables.put(((Primitives.BooleanVariable)var).getName(), var);
            } else if (var instanceof Primitives.DoubleVariable) {
                this.variables.put(((Primitives.DoubleVariable)var).getName(), var);
            } else if (var instanceof Primitives.StringVariable) {
                this.variables.put(((Primitives.StringVariable)var).getName(), var);
            }
        }

        public Set<String> getVariables() {
            return this.variables.keySet();
        }

        public boolean hasVariable(String variable) {
            return this.variables.containsKey(variable);
        }

        public void setBoolean(String name, boolean value) {
            if (!this.variables.containsKey(name)) {
                throw new RuntimeException("Variable '" + name + "' doesn't exist!");
            }
            if (!(this.variables.get(name) instanceof Primitives.BooleanVariable)) {
                throw new RuntimeException("Variable '" + name + "' is not of boolean type!");
            }
            ((Primitives.BooleanVariable)this.variables.get(name)).setValue(value);
        }

        public void setDouble(String name, double value) {
            if (!this.variables.containsKey(name)) {
                throw new RuntimeException("Variable '" + name + "' doesn't exist!");
            }
            if (!(this.variables.get(name) instanceof Primitives.DoubleVariable)) {
                throw new RuntimeException("Variable '" + name + "' is not of double type!");
            }
            ((Primitives.DoubleVariable)this.variables.get(name)).setValue(value);
        }

        public void setString(String name, String value) {
            if (!this.variables.containsKey(name)) {
                throw new RuntimeException("Variable '" + name + "' doesn't exist!");
            }
            if (!(this.variables.get(name) instanceof Primitives.StringVariable)) {
                throw new RuntimeException("Variable '" + name + "' is not of String type!");
            }
            ((Primitives.StringVariable)this.variables.get(name)).setValue(value);
        }
    }
}

