/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.scripting;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import weka.core.Tee;
import weka.gui.PropertyDialog;
import weka.gui.ReaderToTextPane;
import weka.gui.scripting.FileScriptingPanel;
import weka.gui.scripting.event.TitleUpdatedEvent;
import weka.gui.scripting.event.TitleUpdatedListener;

public abstract class ScriptingPanel
extends JPanel
implements TitleUpdatedListener {
    private static final long serialVersionUID = 7593091442691911406L;
    protected PipedOutputStream m_POO;
    protected PipedOutputStream m_POE;
    protected ReaderToTextPane m_OutRedirector;
    protected ReaderToTextPane m_ErrRedirector;
    protected boolean m_Debug;
    protected HashSet<TitleUpdatedListener> m_TitleUpdatedListeners;

    public ScriptingPanel() {
        this.initialize();
        this.initGUI();
        this.initFinish();
    }

    protected void initialize() {
        this.m_POO = new PipedOutputStream();
        this.m_POE = new PipedOutputStream();
        this.m_Debug = false;
        this.m_TitleUpdatedListeners = new HashSet();
    }

    protected void initGUI() {
    }

    protected void initFinish() {
        InputStreamReader reader;
        try {
            PipedInputStream pio = new PipedInputStream(this.m_POO);
            Tee teeOut = new Tee(System.out);
            System.setOut(teeOut);
            teeOut.add(new PrintStream(this.m_POO));
            reader = new InputStreamReader(pio);
            this.m_OutRedirector = new ReaderToTextPane(reader, this.getOutput(), Color.BLACK);
            this.m_OutRedirector.start();
        }
        catch (Exception e) {
            System.err.println("Error redirecting stdout");
            e.printStackTrace();
            this.m_OutRedirector = null;
        }
        try {
            PipedInputStream pie = new PipedInputStream(this.m_POE);
            Tee teeErr = new Tee(System.err);
            System.setErr(teeErr);
            teeErr.add(new PrintStream(this.m_POE));
            reader = new InputStreamReader(pie);
            this.m_ErrRedirector = new ReaderToTextPane(reader, this.getOutput(), Color.RED);
            this.m_ErrRedirector.start();
        }
        catch (Exception e) {
            System.err.println("Error redirecting stderr");
            e.printStackTrace();
            this.m_ErrRedirector = null;
        }
        this.addTitleUpdatedListener(this);
    }

    public abstract ImageIcon getIcon();

    public abstract String getTitle();

    public abstract JTextPane getOutput();

    public abstract JMenuBar getMenuBar();

    public void setDebug(boolean value) {
        this.m_Debug = value;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public void addTitleUpdatedListener(TitleUpdatedListener l) {
        this.m_TitleUpdatedListeners.add(l);
    }

    public void removeTitleUpdatedListener(TitleUpdatedListener l) {
        this.m_TitleUpdatedListeners.remove(l);
    }

    protected void notifyTitleUpdatedListeners(TitleUpdatedEvent e) {
        Iterator<TitleUpdatedListener> iter = this.m_TitleUpdatedListeners.iterator();
        while (iter.hasNext()) {
            iter.next().titleUpdated(e);
        }
    }

    @Override
    public void titleUpdated(TitleUpdatedEvent event) {
        if (PropertyDialog.getParentDialog(this) != null) {
            PropertyDialog.getParentDialog(this).setTitle(this.getTitle());
        } else if (PropertyDialog.getParentFrame(this) != null) {
            PropertyDialog.getParentFrame(this).setTitle(this.getTitle());
        }
    }

    public static void showPanel(ScriptingPanel panel, String[] args) {
        ScriptingPanel.showPanel(panel, args, 800, 600);
    }

    public static void showPanel(ScriptingPanel panel, String[] args, int width, int height) {
        try {
            JFrame frame = new JFrame();
            frame.getContentPane().setLayout(new BorderLayout());
            frame.getContentPane().add((Component)panel, "Center");
            frame.setJMenuBar(panel.getMenuBar());
            frame.setSize(new Dimension(width, height));
            frame.setDefaultCloseOperation(3);
            frame.setTitle(panel.getTitle());
            frame.setIconImage(panel.getIcon().getImage());
            frame.setLocationRelativeTo(null);
            if (args.length > 0 && panel instanceof FileScriptingPanel) {
                ((FileScriptingPanel)panel).open(new File(args[0]));
            }
            frame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

