/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import weka.core.Environment;
import weka.gui.ExtensionFileFilter;
import weka.gui.FileEditor;
import weka.gui.PropertyDialog;
import weka.gui.beans.EnvironmentField;

public class FileEnvironmentField
extends EnvironmentField {
    private static final long serialVersionUID = -233731548086207652L;
    protected FileEditor m_fileEditor = new FileEditor();
    protected PropertyDialog m_fileEditorDialog;
    protected JButton m_browseBut;

    public FileEnvironmentField() {
        this("", 0, false);
        this.setEnvironment(Environment.getSystemWide());
    }

    public FileEnvironmentField(Environment env) {
        this("", 0, false);
        this.setEnvironment(env);
    }

    public FileEnvironmentField(String label, Environment env) {
        this(label, 0, false);
        this.setEnvironment(env);
    }

    public FileEnvironmentField(String label, Environment env, int fileChooserType) {
        this(label, fileChooserType, false);
        this.setEnvironment(env);
    }

    public FileEnvironmentField(String label, Environment env, int fileChooserType, boolean directoriesOnly) {
        this(label, fileChooserType, directoriesOnly);
        this.setEnvironment(env);
    }

    public FileEnvironmentField(String label, int fileChooserType, boolean directoriesOnly) {
        super(label);
        this.m_fileEditor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                File selected = (File)FileEnvironmentField.this.m_fileEditor.getValue();
                if (selected != null) {
                    FileEnvironmentField.this.setText(selected.toString());
                }
            }
        });
        final JFileChooser embeddedEditor = (JFileChooser)this.m_fileEditor.getCustomEditor();
        if (directoriesOnly) {
            embeddedEditor.setFileSelectionMode(1);
        } else {
            embeddedEditor.setFileSelectionMode(0);
        }
        embeddedEditor.setDialogType(fileChooserType);
        ExtensionFileFilter ff = new ExtensionFileFilter(".model", "Serialized Weka classifier (*.model)");
        embeddedEditor.addChoosableFileFilter(ff);
        this.m_browseBut = new JButton("Browse...");
        this.m_browseBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    String modelPath = FileEnvironmentField.this.getText();
                    if (modelPath != null) {
                        try {
                            modelPath = FileEnvironmentField.this.m_env.substitute(modelPath);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        File toSet = new File(modelPath);
                        if (toSet.isFile()) {
                            FileEnvironmentField.this.m_fileEditor.setValue(new File(modelPath));
                            toSet = toSet.getParentFile();
                        }
                        if (toSet.isDirectory()) {
                            embeddedEditor.setCurrentDirectory(toSet);
                        }
                    }
                    FileEnvironmentField.this.showFileEditor();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        JPanel bP = new JPanel();
        bP.setLayout(new BorderLayout());
        bP.add((Component)this.m_browseBut, "Center");
        this.add((Component)bP, "East");
    }

    public void addFileFilter(FileFilter toSet) {
        JFileChooser embeddedEditor = (JFileChooser)this.m_fileEditor.getCustomEditor();
        embeddedEditor.addChoosableFileFilter(toSet);
    }

    public void resetFileFilters() {
        JFileChooser embeddedEditor = (JFileChooser)this.m_fileEditor.getCustomEditor();
        embeddedEditor.resetChoosableFileFilters();
    }

    private void showFileEditor() {
        if (this.m_fileEditorDialog == null) {
            int x = this.getLocationOnScreen().x;
            int y = this.getLocationOnScreen().y;
            this.m_fileEditorDialog = PropertyDialog.getParentDialog(this) != null ? new PropertyDialog(PropertyDialog.getParentDialog(this), (PropertyEditor)this.m_fileEditor, x, y) : new PropertyDialog(PropertyDialog.getParentFrame(this), (PropertyEditor)this.m_fileEditor, x, y);
        }
        this.m_fileEditorDialog.setVisible(true);
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.m_fileEditorDialog != null) {
            this.m_fileEditorDialog.dispose();
            this.m_fileEditorDialog = null;
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_browseBut.setEnabled(enabled);
    }
}

