/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.StringReader;
import javax.swing.JComponent;
import weka.gui.treevisualizer.Node;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeBuild;
import weka.gui.treevisualizer.TreeVisualizer;
import weka.gui.visualize.JComponentWriter;
import weka.gui.visualize.PostscriptGraphics;

public class PostscriptWriter
extends JComponentWriter {
    public PostscriptWriter() {
        super(null);
    }

    public PostscriptWriter(JComponent c) {
        super(c);
    }

    public PostscriptWriter(JComponent c, File f) {
        super(c, f);
    }

    public String getDescription() {
        return "Postscript-File";
    }

    public String getExtension() {
        return ".eps";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void generateOutput() throws Exception {
        BufferedOutputStream ostrm = null;
        ostrm = new BufferedOutputStream(new FileOutputStream(this.getFile()));
        PostscriptGraphics psg = new PostscriptGraphics(this.getComponent().getHeight(), this.getComponent().getWidth(), ostrm);
        psg.setFont(this.getComponent().getFont());
        psg.scale(this.getXScale(), this.getYScale());
        this.getComponent().printAll(psg);
        psg.finished();
        Object var5_3 = null;
        if (ostrm == null) return;
        try {
            ostrm.close();
            return;
        }
        catch (Exception e2) {}
        return;
        {
            catch (Exception e) {
                System.err.println(e);
                Object var5_4 = null;
                if (ostrm == null) return;
                try {
                    ostrm.close();
                    return;
                }
                catch (Exception e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (ostrm == null) throw throwable;
            try {
                ostrm.close();
                throw throwable;
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println("building TreeVisualizer...");
        TreeBuild builder = new TreeBuild();
        PlaceNode2 arrange = new PlaceNode2();
        Node top = builder.create(new StringReader("digraph atree { top [label=\"the top\"] a [label=\"the first node\"] b [label=\"the second nodes\"] c [label=\"comes off of first\"] top->a top->b b->c }"));
        TreeVisualizer tv = new TreeVisualizer(null, top, (NodePlace)arrange);
        tv.setSize(800, 600);
        String filename = System.getProperty("java.io.tmpdir") + "test.eps";
        System.out.println("outputting to '" + filename + "'...");
        PostscriptWriter.toOutput(new PostscriptWriter(), tv, new File(filename));
        System.out.println("done!");
    }
}

