/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import weka.experiment.AveragingResultProducer;
import weka.experiment.PropertyNode;
import weka.gui.GenericObjectEditor;

public class PropertySelectorDialog
extends JDialog {
    private static final long serialVersionUID = -3155058124137930518L;
    protected JButton m_SelectBut = new JButton("Select");
    protected JButton m_CancelBut = new JButton("Cancel");
    protected DefaultMutableTreeNode m_Root;
    protected Object m_RootObject;
    protected int m_Result;
    protected Object[] m_ResultPath;
    protected JTree m_Tree;
    public static final int APPROVE_OPTION = 0;
    public static final int CANCEL_OPTION = 1;

    public PropertySelectorDialog(Frame parentFrame, Object rootObject) {
        super(parentFrame, "Select a property", true);
        this.m_CancelBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertySelectorDialog.this.m_Result = 1;
                PropertySelectorDialog.this.setVisible(false);
            }
        });
        this.m_SelectBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath tPath = PropertySelectorDialog.this.m_Tree.getSelectionPath();
                if (tPath == null) {
                    PropertySelectorDialog.this.m_Result = 1;
                } else {
                    PropertySelectorDialog.this.m_ResultPath = tPath.getPath();
                    PropertySelectorDialog.this.m_Result = PropertySelectorDialog.this.m_ResultPath == null || PropertySelectorDialog.this.m_ResultPath.length < 2 ? 1 : 0;
                }
                PropertySelectorDialog.this.setVisible(false);
            }
        });
        this.m_RootObject = rootObject;
        this.m_Root = new DefaultMutableTreeNode(new PropertyNode(this.m_RootObject));
        this.createNodes(this.m_Root);
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        Box b1 = new Box(0);
        b1.add(this.m_SelectBut);
        b1.add(Box.createHorizontalStrut(10));
        b1.add(this.m_CancelBut);
        c.add((Component)b1, "South");
        this.m_Tree = new JTree(this.m_Root);
        this.m_Tree.getSelectionModel().setSelectionMode(1);
        c.add((Component)new JScrollPane(this.m_Tree), "Center");
        this.pack();
    }

    public int showDialog() {
        this.m_Result = 1;
        this.setVisible(true);
        return this.m_Result;
    }

    public PropertyNode[] getPath() {
        PropertyNode[] result = new PropertyNode[this.m_ResultPath.length - 1];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (PropertyNode)((DefaultMutableTreeNode)this.m_ResultPath[i + 1]).getUserObject();
        }
        return result;
    }

    protected void createNodes(DefaultMutableTreeNode localNode) {
        PropertyDescriptor[] localProperties;
        PropertyNode pNode = (PropertyNode)localNode.getUserObject();
        Object localObject = pNode.value;
        try {
            BeanInfo bi = Introspector.getBeanInfo(localObject.getClass());
            localProperties = bi.getPropertyDescriptors();
        }
        catch (IntrospectionException ex) {
            System.err.println("PropertySelectorDialog: Couldn't introspect");
            return;
        }
        for (int i = 0; i < localProperties.length; ++i) {
            Object value;
            block11: {
                if (localProperties[i].isHidden() || localProperties[i].isExpert()) continue;
                String name = localProperties[i].getDisplayName();
                Class<?> type = localProperties[i].getPropertyType();
                Method getter = localProperties[i].getReadMethod();
                Method setter = localProperties[i].getWriteMethod();
                value = null;
                if (getter == null || setter == null) continue;
                try {
                    Object[] args = new Object[]{};
                    value = getter.invoke(localObject, args);
                    PropertyEditor editor = null;
                    Class<?> pec = localProperties[i].getPropertyEditorClass();
                    if (pec != null) {
                        try {
                            editor = (PropertyEditor)pec.newInstance();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    if (editor == null) {
                        editor = PropertyEditorManager.findEditor(type);
                    }
                    if (editor == null) continue;
                    if (value == null) {
                    }
                    break block11;
                }
                catch (InvocationTargetException ex) {
                    System.err.println("Skipping property " + name + " ; exception on target: " + ex.getTargetException());
                    ex.getTargetException().printStackTrace();
                }
                catch (Exception ex) {
                    System.err.println("Skipping property " + name + " ; exception: " + ex);
                    ex.printStackTrace();
                }
                continue;
            }
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(new PropertyNode(value, localProperties[i], localObject.getClass()));
            localNode.add(child);
            this.createNodes(child);
        }
    }

    public static void main(String[] args) {
        try {
            GenericObjectEditor.registerEditors();
            AveragingResultProducer rp = new AveragingResultProducer();
            PropertySelectorDialog jd = new PropertySelectorDialog(null, rp);
            int result = jd.showDialog();
            if (result == 0) {
                System.err.println("Property Selected");
                PropertyNode[] path = jd.getPath();
                for (int i = 0; i < path.length; ++i) {
                    PropertyNode pn = path[i];
                    System.err.println("" + (i + 1) + "  " + pn.toString() + " " + pn.value.toString());
                }
            } else {
                System.err.println("Cancelled");
            }
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

