/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.ensembleLibraryEditor.tree;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import weka.gui.ensembleLibraryEditor.tree.CheckBoxNode;
import weka.gui.ensembleLibraryEditor.tree.PropertyNode;

public class CheckBoxNodeEditor
extends JPanel
implements ItemListener {
    private static final long serialVersionUID = -1506685976284982111L;
    private JCheckBox m_SelectedCheckBox;
    private JLabel m_Label;
    private Color textForeground;
    private Color textBackground;
    private CheckBoxNode m_Node;

    public CheckBoxNodeEditor(CheckBoxNode node) {
        this.m_Node = node;
        String name = node.getName();
        boolean selected = node.getSelected();
        this.textForeground = UIManager.getColor("Tree.textForeground");
        this.textBackground = UIManager.getColor("Tree.textBackground");
        this.setForeground(this.textForeground);
        this.setBackground(this.textBackground);
        Font fontValue = UIManager.getFont("Tree.font");
        this.m_SelectedCheckBox = new JCheckBox();
        this.m_SelectedCheckBox.setSelected(selected);
        this.m_SelectedCheckBox.setForeground(this.textForeground);
        this.m_SelectedCheckBox.setBackground(this.textBackground);
        this.m_SelectedCheckBox.addItemListener(this);
        this.add(this.m_SelectedCheckBox);
        this.m_Label = new JLabel(name);
        if (fontValue != null) {
            this.m_Label.setFont(fontValue);
        }
        this.m_Label.setForeground(this.textForeground);
        this.m_Label.setBackground(this.textBackground);
        this.add(this.m_Label);
    }

    public void setItemListener(ItemListener itemListener) {
        if (this.m_SelectedCheckBox != null) {
            this.m_SelectedCheckBox.addItemListener(itemListener);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.m_Node.setSelected(true);
            this.m_Label.setEnabled(true);
        } else if (e.getStateChange() == 2) {
            PropertyNode parent = (PropertyNode)this.m_Node.getParent();
            if (parent.canDeselect(this.m_Node)) {
                this.m_Node.setSelected(false);
                this.m_Label.setEnabled(false);
            } else {
                this.m_SelectedCheckBox.setSelected(true);
            }
        }
    }
}

