/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import weka.core.Instances;

public class InstancesSummaryPanel
extends JPanel {
    private static final long serialVersionUID = -5243579535296681063L;
    protected static final String NO_SOURCE = "None";
    protected JLabel m_RelationNameLab = new JLabel("None");
    protected JLabel m_NumInstancesLab = new JLabel("None");
    protected JLabel m_NumAttributesLab = new JLabel("None");
    protected Instances m_Instances;

    public InstancesSummaryPanel() {
        GridBagLayout gbLayout = new GridBagLayout();
        this.setLayout(gbLayout);
        JLabel lab = new JLabel("Relation:", 4);
        lab.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(lab, gbConstraints);
        this.add(lab);
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 17;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 1;
        gbConstraints.weightx = 100.0;
        gbConstraints.gridwidth = 3;
        gbLayout.setConstraints(this.m_RelationNameLab, gbConstraints);
        this.add(this.m_RelationNameLab);
        this.m_RelationNameLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 10));
        lab = new JLabel("Instances:", 4);
        lab.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 1;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(lab, gbConstraints);
        this.add(lab);
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 17;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 1;
        gbConstraints.gridx = 1;
        gbConstraints.weightx = 100.0;
        gbLayout.setConstraints(this.m_NumInstancesLab, gbConstraints);
        this.add(this.m_NumInstancesLab);
        this.m_NumInstancesLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 10));
        lab = new JLabel("Attributes:", 4);
        lab.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 1;
        gbConstraints.gridx = 2;
        gbLayout.setConstraints(lab, gbConstraints);
        this.add(lab);
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 17;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 1;
        gbConstraints.gridx = 3;
        gbConstraints.weightx = 100.0;
        gbLayout.setConstraints(this.m_NumAttributesLab, gbConstraints);
        this.add(this.m_NumAttributesLab);
        this.m_NumAttributesLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 10));
    }

    public void setInstances(Instances inst) {
        this.m_Instances = inst;
        this.m_RelationNameLab.setText(this.m_Instances.relationName());
        this.m_NumInstancesLab.setText("" + this.m_Instances.numInstances());
        this.m_NumAttributesLab.setText("" + this.m_Instances.numAttributes());
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame("Instances Panel");
            jf.getContentPane().setLayout(new BorderLayout());
            InstancesSummaryPanel p = new InstancesSummaryPanel();
            p.setBorder(BorderFactory.createTitledBorder("Relation"));
            jf.getContentPane().add((Component)p, "Center");
            jf.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
            if (args.length == 1) {
                BufferedReader r = new BufferedReader(new FileReader(args[0]));
                Instances i = new Instances(r);
                p.setInstances(i);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

