/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.neural;

import java.util.Random;
import weka.classifiers.functions.neural.NeuralConnection;
import weka.classifiers.functions.neural.NeuralMethod;
import weka.core.RevisionUtils;

public class NeuralNode
extends NeuralConnection {
    private static final long serialVersionUID = -1085750607680839163L;
    private double[] m_weights = new double[1];
    private double[] m_bestWeights = new double[1];
    private double[] m_changeInWeights = new double[1];
    private Random m_random;
    private NeuralMethod m_methods;

    public NeuralNode(String string, Random random, NeuralMethod neuralMethod) {
        super(string);
        this.m_random = random;
        this.m_weights[0] = this.m_random.nextDouble() * 0.1 - 0.05;
        this.m_changeInWeights[0] = 0.0;
        this.m_methods = neuralMethod;
    }

    public void setMethod(NeuralMethod neuralMethod) {
        this.m_methods = neuralMethod;
    }

    public NeuralMethod getMethod() {
        return this.m_methods;
    }

    public double outputValue(boolean bl) {
        if (Double.isNaN(this.m_unitValue) && bl) {
            this.m_unitValue = this.m_methods.outputValue(this);
        }
        return this.m_unitValue;
    }

    public double errorValue(boolean bl) {
        if (!Double.isNaN(this.m_unitValue) && Double.isNaN(this.m_unitError) && bl) {
            this.m_unitError = this.m_methods.errorValue(this);
        }
        return this.m_unitError;
    }

    public void reset() {
        if (!Double.isNaN(this.m_unitValue) || !Double.isNaN(this.m_unitError)) {
            this.m_unitValue = Double.NaN;
            this.m_unitError = Double.NaN;
            this.m_weightsUpdated = false;
            for (int i = 0; i < this.m_numInputs; ++i) {
                this.m_inputList[i].reset();
            }
        }
    }

    public void saveWeights() {
        System.arraycopy(this.m_weights, 0, this.m_bestWeights, 0, this.m_weights.length);
        for (int i = 0; i < this.m_numInputs; ++i) {
            this.m_inputList[i].saveWeights();
        }
    }

    public void restoreWeights() {
        System.arraycopy(this.m_bestWeights, 0, this.m_weights, 0, this.m_weights.length);
        for (int i = 0; i < this.m_numInputs; ++i) {
            this.m_inputList[i].restoreWeights();
        }
    }

    public double weightValue(int n) {
        if (n >= this.m_numInputs || n < -1) {
            return Double.NaN;
        }
        return this.m_weights[n + 1];
    }

    public double[] getWeights() {
        return this.m_weights;
    }

    public double[] getChangeInWeights() {
        return this.m_changeInWeights;
    }

    public void updateWeights(double d, double d2) {
        if (!this.m_weightsUpdated && !Double.isNaN(this.m_unitError)) {
            this.m_methods.updateWeights(this, d, d2);
            super.updateWeights(d, d2);
        }
    }

    protected boolean connectInput(NeuralConnection neuralConnection, int n) {
        if (!super.connectInput(neuralConnection, n)) {
            return false;
        }
        this.m_weights[this.m_numInputs] = this.m_random.nextDouble() * 0.1 - 0.05;
        this.m_changeInWeights[this.m_numInputs] = 0.0;
        return true;
    }

    protected void allocateInputs() {
        NeuralConnection[] neuralConnectionArray = new NeuralConnection[this.m_inputList.length + 15];
        int[] nArray = new int[this.m_inputNums.length + 15];
        double[] dArray = new double[this.m_weights.length + 15];
        double[] dArray2 = new double[this.m_changeInWeights.length + 15];
        double[] dArray3 = new double[this.m_bestWeights.length + 15];
        dArray[0] = this.m_weights[0];
        dArray2[0] = this.m_changeInWeights[0];
        dArray3[0] = this.m_bestWeights[0];
        for (int i = 0; i < this.m_numInputs; ++i) {
            neuralConnectionArray[i] = this.m_inputList[i];
            nArray[i] = this.m_inputNums[i];
            dArray[i + 1] = this.m_weights[i + 1];
            dArray2[i + 1] = this.m_changeInWeights[i + 1];
            dArray3[i + 1] = this.m_bestWeights[i + 1];
        }
        this.m_inputList = neuralConnectionArray;
        this.m_inputNums = nArray;
        this.m_weights = dArray;
        this.m_changeInWeights = dArray2;
        this.m_bestWeights = dArray3;
    }

    protected boolean disconnectInput(NeuralConnection neuralConnection, int n) {
        int n2 = -1;
        boolean bl = false;
        do {
            int n3;
            n2 = -1;
            for (n3 = 0; n3 < this.m_numInputs; ++n3) {
                if (neuralConnection != this.m_inputList[n3] || n != -1 && n != this.m_inputNums[n3]) continue;
                n2 = n3;
                break;
            }
            if (n2 < 0) continue;
            for (n3 = n2 + 1; n3 < this.m_numInputs; ++n3) {
                this.m_inputList[n3 - 1] = this.m_inputList[n3];
                this.m_inputNums[n3 - 1] = this.m_inputNums[n3];
                this.m_weights[n3] = this.m_weights[n3 + 1];
                this.m_changeInWeights[n3] = this.m_changeInWeights[n3 + 1];
                this.m_inputList[n3 - 1].changeOutputNum(this.m_inputNums[n3 - 1], n3 - 1);
            }
            --this.m_numInputs;
            bl = true;
        } while (n == -1 && n2 != -1);
        return bl;
    }

    public void removeAllInputs() {
        super.removeAllInputs();
        double d = this.m_weights[0];
        double d2 = this.m_changeInWeights[0];
        this.m_weights = new double[1];
        this.m_changeInWeights = new double[1];
        this.m_weights[0] = d;
        this.m_changeInWeights[0] = d2;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5403 $");
    }
}

