/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.boundaryvisualizer;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.Random;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import weka.classifiers.Classifier;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.gui.boundaryvisualizer.DataGenerator;
import weka.gui.boundaryvisualizer.KDDataGenerator;

public class BoundaryPanel
extends JPanel {
    public static final Color[] DEFAULT_COLORS = new Color[]{Color.red, Color.green, Color.blue, new Color(0, 255, 255), new Color(255, 0, 255), new Color(255, 255, 0), new Color(255, 255, 255), new Color(0, 0, 0)};
    public static final double REMOVE_POINT_RADIUS = 7.0;
    protected FastVector m_Colors = new FastVector();
    protected Instances m_trainingData;
    protected Classifier m_classifier;
    protected DataGenerator m_dataGenerator;
    private int m_classIndex = -1;
    protected int m_xAttribute;
    protected int m_yAttribute;
    protected double m_minX;
    protected double m_minY;
    protected double m_maxX;
    protected double m_maxY;
    private double m_rangeX;
    private double m_rangeY;
    protected double m_pixHeight;
    protected double m_pixWidth;
    protected Image m_osi = null;
    protected int m_panelWidth;
    protected int m_panelHeight;
    protected int m_numOfSamplesPerRegion = 2;
    protected int m_numOfSamplesPerGenerator;
    protected double m_samplesBase = 2.0;
    private Vector m_listeners = new Vector();
    private PlotPanel m_plotPanel = new PlotPanel();
    private Thread m_plotThread = null;
    protected boolean m_stopPlotting = false;
    protected boolean m_stopReplotting = false;
    private Double m_dummy = new Double(1.0);
    private boolean m_pausePlotting = false;
    private int m_size = 1;
    private boolean m_initialTiling;
    private Random m_random = null;
    protected double[][][] m_probabilityCache;
    protected boolean m_plotTrainingData = true;

    public BoundaryPanel(int n, int n2) {
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        this.m_panelWidth = n;
        this.m_panelHeight = n2;
        this.setLayout(new BorderLayout());
        this.m_plotPanel.setMinimumSize(new Dimension(this.m_panelWidth, this.m_panelHeight));
        this.m_plotPanel.setPreferredSize(new Dimension(this.m_panelWidth, this.m_panelHeight));
        this.m_plotPanel.setMaximumSize(new Dimension(this.m_panelWidth, this.m_panelHeight));
        this.add((Component)this.m_plotPanel, "Center");
        this.setPreferredSize(this.m_plotPanel.getPreferredSize());
        this.setMaximumSize(this.m_plotPanel.getMaximumSize());
        this.setMinimumSize(this.m_plotPanel.getMinimumSize());
        this.m_random = new Random(1L);
        for (int i = 0; i < DEFAULT_COLORS.length; ++i) {
            this.m_Colors.addElement(new Color(DEFAULT_COLORS[i].getRed(), DEFAULT_COLORS[i].getGreen(), DEFAULT_COLORS[i].getBlue()));
        }
        this.m_probabilityCache = new double[this.m_panelHeight][this.m_panelWidth][];
    }

    public void setNumSamplesPerRegion(int n) {
        this.m_numOfSamplesPerRegion = n;
    }

    public int getNumSamplesPerRegion() {
        return this.m_numOfSamplesPerRegion;
    }

    public void setGeneratorSamplesBase(double d) {
        this.m_samplesBase = d;
    }

    public double getGeneratorSamplesBase() {
        return this.m_samplesBase;
    }

    protected void initialize() {
        int n = this.m_plotPanel.getWidth();
        int n2 = this.m_plotPanel.getHeight();
        this.m_osi = this.m_plotPanel.createImage(n, n2);
        Graphics graphics = this.m_osi.getGraphics();
        graphics.fillRect(0, 0, n, n2);
    }

    public void stopPlotting() {
        this.m_stopPlotting = true;
        try {
            this.m_plotThread.join(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void computeMinMaxAtts() {
        this.m_minX = Double.MAX_VALUE;
        this.m_minY = Double.MAX_VALUE;
        this.m_maxX = Double.MIN_VALUE;
        this.m_maxY = Double.MIN_VALUE;
        boolean bl = true;
        if (this.m_trainingData.numInstances() == 0) {
            this.m_minY = 0.0;
            this.m_minX = 0.0;
            this.m_maxY = 1.0;
            this.m_maxX = 1.0;
        } else {
            for (int i = 0; i < this.m_trainingData.numInstances(); ++i) {
                Instance instance = this.m_trainingData.instance(i);
                double d = instance.value(this.m_xAttribute);
                double d2 = instance.value(this.m_yAttribute);
                if (d == Instance.missingValue() || d2 == Instance.missingValue()) continue;
                if (d < this.m_minX) {
                    this.m_minX = d;
                }
                if (d > this.m_maxX) {
                    this.m_maxX = d;
                }
                if (d2 < this.m_minY) {
                    this.m_minY = d2;
                }
                if (d2 > this.m_maxY) {
                    this.m_maxY = d2;
                }
                if (!(d > 1.0) && !(d2 > 1.0)) continue;
                bl = false;
            }
        }
        if (this.m_minX == this.m_maxX) {
            this.m_minX = 0.0;
        }
        if (this.m_minY == this.m_maxY) {
            this.m_minY = 0.0;
        }
        if (this.m_minX == Double.MAX_VALUE) {
            this.m_minX = 0.0;
        }
        if (this.m_minY == Double.MAX_VALUE) {
            this.m_minY = 0.0;
        }
        if (this.m_maxX == Double.MIN_VALUE) {
            this.m_maxX = 1.0;
        }
        if (this.m_maxY == Double.MIN_VALUE) {
            this.m_maxY = 1.0;
        }
        if (bl) {
            this.m_minY = 0.0;
            this.m_minX = 0.0;
            this.m_maxY = 1.0;
            this.m_maxX = 1.0;
        }
        this.m_rangeX = this.m_maxX - this.m_minX;
        this.m_rangeY = this.m_maxY - this.m_minY;
        this.m_pixWidth = this.m_rangeX / (double)this.m_panelWidth;
        this.m_pixHeight = this.m_rangeY / (double)this.m_panelHeight;
    }

    private double getRandomX(int n) {
        double d = this.m_minX + (double)n * this.m_pixWidth;
        return d + this.m_random.nextDouble() * this.m_pixWidth;
    }

    private double getRandomY(int n) {
        double d = this.m_minY + (double)n * this.m_pixHeight;
        return d + this.m_random.nextDouble() * this.m_pixHeight;
    }

    public void start() throws Exception {
        this.m_numOfSamplesPerGenerator = (int)Math.pow(this.m_samplesBase, this.m_trainingData.numAttributes() - 3);
        this.m_stopReplotting = true;
        if (this.m_trainingData == null) {
            throw new Exception("No training data set (BoundaryPanel)");
        }
        if (this.m_classifier == null) {
            throw new Exception("No classifier set (BoundaryPanel)");
        }
        if (this.m_dataGenerator == null) {
            throw new Exception("No data generator set (BoundaryPanel)");
        }
        if (this.m_trainingData.attribute(this.m_xAttribute).isNominal() || this.m_trainingData.attribute(this.m_yAttribute).isNominal()) {
            throw new Exception("Visualization dimensions must be numeric (BoundaryPanel)");
        }
        this.computeMinMaxAtts();
        this.startPlotThread();
    }

    public void plotTrainingData() {
        Graphics2D graphics2D = (Graphics2D)this.m_osi.getGraphics();
        Graphics graphics = this.m_plotPanel.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.m_trainingData.numInstances(); ++i) {
            if (this.m_trainingData.instance(i).isMissing(this.m_xAttribute) || this.m_trainingData.instance(i).isMissing(this.m_yAttribute) || this.m_trainingData.instance(i).isMissing(this.m_classIndex)) continue;
            d = this.m_trainingData.instance(i).value(this.m_xAttribute);
            d2 = this.m_trainingData.instance(i).value(this.m_yAttribute);
            int n = this.convertToPanelX(d);
            int n2 = this.convertToPanelY(d2);
            Color color = (Color)this.m_Colors.elementAt((int)this.m_trainingData.instance(i).value(this.m_classIndex) % this.m_Colors.size());
            if (color.equals(Color.white)) {
                graphics2D.setColor(Color.black);
            } else {
                graphics2D.setColor(Color.white);
            }
            graphics2D.fillOval(n - 3, n2 - 3, 7, 7);
            graphics2D.setColor(color);
            graphics2D.fillOval(n - 2, n2 - 2, 5, 5);
        }
        graphics.drawImage(this.m_osi, 0, 0, this.m_plotPanel);
    }

    private int convertToPanelX(double d) {
        double d2 = (d - this.m_minX) / this.m_rangeX;
        return (int)(d2 *= (double)this.m_panelWidth);
    }

    private int convertToPanelY(double d) {
        double d2 = (d - this.m_minY) / this.m_rangeY;
        d2 *= (double)this.m_panelHeight;
        d2 = (double)this.m_panelHeight - d2;
        return (int)d2;
    }

    private double convertFromPanelX(double d) {
        d /= (double)this.m_panelWidth;
        return (d *= this.m_rangeX) + this.m_minX;
    }

    private double convertFromPanelY(double d) {
        d = (double)this.m_panelHeight - d;
        d /= (double)this.m_panelHeight;
        return (d *= this.m_rangeY) + this.m_minY;
    }

    protected void plotPoint(int n, int n2, double[] dArray, boolean bl) {
        this.plotPoint(n, n2, 1, 1, dArray, bl);
    }

    private void plotPoint(int n, int n2, int n3, int n4, double[] dArray, boolean bl) {
        int n5;
        Graphics graphics = this.m_osi.getGraphics();
        if (bl) {
            graphics.setXORMode(Color.white);
            graphics.drawLine(0, n2, this.m_panelWidth - 1, n2);
            this.update();
            graphics.drawLine(0, n2, this.m_panelWidth - 1, n2);
        }
        graphics.setPaintMode();
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        for (n5 = 0; n5 < dArray.length; ++n5) {
            Color color = (Color)this.m_Colors.elementAt(n5 % this.m_Colors.size());
            color.getRGBColorComponents(fArray2);
            for (int i = 0; i < 3; ++i) {
                int n6 = i;
                fArray[n6] = (float)((double)fArray[n6] + dArray[n5] * (double)fArray2[i]);
            }
        }
        for (n5 = 0; n5 < 3; ++n5) {
            if (fArray[n5] < 0.0f) {
                fArray[n5] = 0.0f;
                continue;
            }
            if (!(fArray[n5] > 1.0f)) continue;
            fArray[n5] = 1.0f;
        }
        graphics.setColor(new Color(fArray[0], fArray[1], fArray[2]));
        graphics.fillRect(n, n2, n3, n4);
    }

    private void update() {
        Graphics graphics = this.m_plotPanel.getGraphics();
        graphics.drawImage(this.m_osi, 0, 0, this.m_plotPanel);
    }

    public void setTrainingData(Instances instances) throws Exception {
        this.m_trainingData = instances;
        if (this.m_trainingData.classIndex() < 0) {
            throw new Exception("No class attribute set (BoundaryPanel)");
        }
        this.m_classIndex = this.m_trainingData.classIndex();
    }

    public void addTrainingInstance(Instance instance) {
        if (this.m_trainingData == null) {
            System.err.println("Trying to add to a null training set (BoundaryPanel)");
        }
        this.m_trainingData.add(instance);
    }

    public void addActionListener(ActionListener actionListener) {
        this.m_listeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.m_listeners.removeElement(actionListener);
    }

    public void setClassifier(Classifier classifier) {
        this.m_classifier = classifier;
    }

    public void setDataGenerator(DataGenerator dataGenerator) {
        this.m_dataGenerator = dataGenerator;
    }

    public void setXAttribute(int n) throws Exception {
        if (this.m_trainingData == null) {
            throw new Exception("No training data set (BoundaryPanel)");
        }
        if (n < 0 || n > this.m_trainingData.numAttributes()) {
            throw new Exception("X attribute out of range (BoundaryPanel)");
        }
        if (this.m_trainingData.attribute(n).isNominal()) {
            throw new Exception("Visualization dimensions must be numeric (BoundaryPanel)");
        }
        this.m_xAttribute = n;
    }

    public void setYAttribute(int n) throws Exception {
        if (this.m_trainingData == null) {
            throw new Exception("No training data set (BoundaryPanel)");
        }
        if (n < 0 || n > this.m_trainingData.numAttributes()) {
            throw new Exception("X attribute out of range (BoundaryPanel)");
        }
        if (this.m_trainingData.attribute(n).isNominal()) {
            throw new Exception("Visualization dimensions must be numeric (BoundaryPanel)");
        }
        this.m_yAttribute = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColors(FastVector fastVector) {
        FastVector fastVector2 = this.m_Colors;
        synchronized (fastVector2) {
            this.m_Colors = fastVector;
        }
        this.update();
    }

    public void setPlotTrainingData(boolean bl) {
        this.m_plotTrainingData = bl;
    }

    public boolean getPlotTrainingData() {
        return this.m_plotTrainingData;
    }

    public FastVector getColors() {
        return this.m_Colors;
    }

    public void replot() {
        if (this.m_probabilityCache[0][0] == null) {
            return;
        }
        this.m_stopReplotting = true;
        this.m_pausePlotting = true;
        try {
            Thread.sleep(300L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                BoundaryPanel.this.m_stopReplotting = false;
                int n = BoundaryPanel.this.m_size / 2;
                block3: for (int i = 0; i < BoundaryPanel.this.m_panelHeight; i += BoundaryPanel.this.m_size) {
                    for (int j = 0; j < BoundaryPanel.this.m_panelWidth; j += BoundaryPanel.this.m_size) {
                        boolean bl;
                        if (BoundaryPanel.this.m_probabilityCache[i][j] == null || BoundaryPanel.this.m_stopReplotting) break block3;
                        boolean bl2 = bl = j == 0 && i % 2 == 0;
                        if (i >= BoundaryPanel.this.m_panelHeight || j >= BoundaryPanel.this.m_panelWidth) continue;
                        if (BoundaryPanel.this.m_initialTiling || BoundaryPanel.this.m_size == 1) {
                            if (BoundaryPanel.this.m_probabilityCache[i][j] == null) break block3;
                            BoundaryPanel.this.plotPoint(j, i, BoundaryPanel.this.m_size, BoundaryPanel.this.m_size, BoundaryPanel.this.m_probabilityCache[i][j], bl);
                            continue;
                        }
                        if (BoundaryPanel.this.m_probabilityCache[i + n][j] == null) break block3;
                        BoundaryPanel.this.plotPoint(j, i + n, n, n, BoundaryPanel.this.m_probabilityCache[i + n][j], bl);
                        if (BoundaryPanel.this.m_probabilityCache[i + n][j + n] == null) break block3;
                        BoundaryPanel.this.plotPoint(j + n, i + n, n, n, BoundaryPanel.this.m_probabilityCache[i + n][j + n], bl);
                        if (BoundaryPanel.this.m_probabilityCache[i][j + n] == null) break block3;
                        BoundaryPanel.this.plotPoint(j + n, i, n, n, BoundaryPanel.this.m_probabilityCache[i + n][j], bl);
                    }
                }
                BoundaryPanel.this.update();
                if (BoundaryPanel.this.m_plotTrainingData) {
                    BoundaryPanel.this.plotTrainingData();
                }
                BoundaryPanel.this.m_pausePlotting = false;
                if (!BoundaryPanel.this.m_stopPlotting) {
                    Double d = BoundaryPanel.this.m_dummy;
                    synchronized (d) {
                        BoundaryPanel.this.m_dummy.notifyAll();
                    }
                }
            }
        };
        thread.start();
    }

    protected void saveImage(String string) {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)bufferedOutputStream);
            BufferedImage bufferedImage = new BufferedImage(this.m_panelWidth, this.m_panelHeight, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(this.m_osi, 0, 0, this.m_panelWidth, this.m_panelHeight, null);
            JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
            jPEGEncodeParam.setQuality(1.0f, false);
            jPEGImageEncoder.setJPEGEncodeParam(jPEGEncodeParam);
            jPEGImageEncoder.encode(bufferedImage);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addTrainingInstanceFromMouseLocation(int n, int n2, int n3, double d) {
        double d2 = this.convertFromPanelX(n);
        double d3 = this.convertFromPanelY(n2);
        Instance instance = new Instance(this.m_trainingData.numAttributes());
        for (int i = 0; i < instance.numAttributes(); ++i) {
            if (i == n3) {
                instance.setValue(i, d);
                continue;
            }
            if (i == this.m_xAttribute) {
                instance.setValue(i, d2);
                continue;
            }
            if (i == this.m_yAttribute) {
                instance.setValue(i, d3);
                continue;
            }
            instance.setMissing(i);
        }
        this.addTrainingInstance(instance);
    }

    public void removeAllInstances() {
        if (this.m_trainingData != null) {
            this.m_trainingData.delete();
            try {
                this.initialize();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void removeTrainingInstanceFromMouseLocation(int n, int n2) {
        double d = this.convertFromPanelX(n);
        double d2 = this.convertFromPanelY(n2);
        int n3 = -1;
        double d3 = 2.147483647E9;
        for (int i = 0; i < this.m_trainingData.numInstances(); ++i) {
            Instance instance = this.m_trainingData.instance(i);
            double d4 = (instance.value(this.m_xAttribute) - d) * (instance.value(this.m_xAttribute) - d) + (instance.value(this.m_yAttribute) - d2) * (instance.value(this.m_yAttribute) - d2);
            if (!(d4 < d3)) continue;
            n3 = i;
            d3 = d4;
        }
        if (n3 == -1) {
            return;
        }
        Instance instance = this.m_trainingData.instance(n3);
        double d5 = (this.convertToPanelX(instance.value(this.m_xAttribute)) - n) * (this.convertToPanelX(instance.value(this.m_xAttribute)) - n) + (this.convertToPanelY(instance.value(this.m_yAttribute)) - n2) * (this.convertToPanelY(instance.value(this.m_yAttribute)) - n2);
        if (d5 < 49.0) {
            this.m_trainingData.delete(n3);
        }
    }

    public void startPlotThread() {
        if (this.m_plotThread == null) {
            this.m_plotThread = new PlotThread();
            this.m_plotThread.setPriority(1);
            this.m_plotThread.start();
        }
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.m_plotPanel.addMouseListener(mouseListener);
    }

    public double getMinXBound() {
        return this.m_minX;
    }

    public double getMinYBound() {
        return this.m_minY;
    }

    public double getMaxXBound() {
        return this.m_maxX;
    }

    public double getMaxYBound() {
        return this.m_maxY;
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length < 8) {
                System.err.println("Usage : BoundaryPanel <dataset> <class col> <xAtt> <yAtt> <base> <# loc/pixel> <kernel bandwidth> <display width> <display height> <classifier [classifier options]>");
                System.exit(1);
            }
            final JFrame jFrame = new JFrame("Weka classification boundary visualizer");
            jFrame.getContentPane().setLayout(new BorderLayout());
            System.err.println("Loading instances from : " + stringArray[0]);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
            final Instances instances = new Instances(bufferedReader);
            instances.setClassIndex(Integer.parseInt(stringArray[1]));
            final int n = Integer.parseInt(stringArray[2]);
            final int n2 = Integer.parseInt(stringArray[3]);
            int n3 = Integer.parseInt(stringArray[4]);
            int n4 = Integer.parseInt(stringArray[5]);
            int n5 = Integer.parseInt(stringArray[6]);
            int n6 = Integer.parseInt(stringArray[7]);
            int n7 = Integer.parseInt(stringArray[8]);
            final String string = stringArray[9];
            final BoundaryPanel boundaryPanel = new BoundaryPanel(n6, n7);
            boundaryPanel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
                    boundaryPanel.saveImage(string2 + "_" + instances.relationName() + "_X" + n + "_Y" + n2 + ".jpg");
                }
            });
            jFrame.getContentPane().add((Component)boundaryPanel, "Center");
            jFrame.setSize(boundaryPanel.getMinimumSize());
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setVisible(true);
            boundaryPanel.repaint();
            String[] stringArray2 = null;
            if (stringArray.length > 10) {
                stringArray2 = new String[stringArray.length - 10];
                for (int i = 10; i < stringArray.length; ++i) {
                    stringArray2[i - 10] = stringArray[i];
                }
            }
            Classifier classifier = Classifier.forName(stringArray[9], stringArray2);
            KDDataGenerator kDDataGenerator = new KDDataGenerator();
            kDDataGenerator.setKernelBandwidth(n5);
            boundaryPanel.setDataGenerator(kDDataGenerator);
            boundaryPanel.setNumSamplesPerRegion(n4);
            boundaryPanel.setGeneratorSamplesBase(n3);
            boundaryPanel.setClassifier(classifier);
            boundaryPanel.setTrainingData(instances);
            boundaryPanel.setXAttribute(n);
            boundaryPanel.setYAttribute(n2);
            try {
                FileInputStream fileInputStream = new FileInputStream("colors.ser");
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                FastVector fastVector = (FastVector)objectInputStream.readObject();
                boundaryPanel.setColors(fastVector);
            }
            catch (Exception exception) {
                System.err.println("No color map file");
            }
            boundaryPanel.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected class PlotThread
    extends Thread {
        double[] m_weightingAttsValues;
        boolean[] m_attsToWeightOn;
        double[] m_vals;
        double[] m_dist;
        Instance m_predInst;

        protected PlotThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block33: {
                BoundaryPanel.this.m_stopPlotting = false;
                try {
                    int n;
                    int n2;
                    BoundaryPanel.this.initialize();
                    BoundaryPanel.this.repaint();
                    BoundaryPanel.this.m_probabilityCache = new double[BoundaryPanel.this.m_panelHeight][BoundaryPanel.this.m_panelWidth][];
                    BoundaryPanel.this.m_classifier.buildClassifier(BoundaryPanel.this.m_trainingData);
                    this.m_attsToWeightOn = new boolean[BoundaryPanel.this.m_trainingData.numAttributes()];
                    this.m_attsToWeightOn[BoundaryPanel.this.m_xAttribute] = true;
                    this.m_attsToWeightOn[BoundaryPanel.this.m_yAttribute] = true;
                    BoundaryPanel.this.m_dataGenerator.setWeightingDimensions(this.m_attsToWeightOn);
                    BoundaryPanel.this.m_dataGenerator.buildGenerator(BoundaryPanel.this.m_trainingData);
                    this.m_weightingAttsValues = new double[this.m_attsToWeightOn.length];
                    this.m_vals = new double[BoundaryPanel.this.m_trainingData.numAttributes()];
                    this.m_predInst = new Instance(1.0, this.m_vals);
                    this.m_predInst.setDataset(BoundaryPanel.this.m_trainingData);
                    BoundaryPanel.this.m_size = 16;
                    BoundaryPanel.this.m_initialTiling = true;
                    block24: for (n2 = 0; n2 <= BoundaryPanel.this.m_panelHeight; n2 += BoundaryPanel.this.m_size) {
                        for (n = 0; n <= BoundaryPanel.this.m_panelWidth; n += BoundaryPanel.this.m_size) {
                            if (BoundaryPanel.this.m_stopPlotting) break block24;
                            if (BoundaryPanel.this.m_pausePlotting) {
                                Double d = BoundaryPanel.this.m_dummy;
                                synchronized (d) {
                                    try {
                                        BoundaryPanel.this.m_dummy.wait();
                                    }
                                    catch (InterruptedException interruptedException) {
                                        BoundaryPanel.this.m_pausePlotting = false;
                                    }
                                }
                            }
                            BoundaryPanel.this.plotPoint(n, n2, BoundaryPanel.this.m_size, BoundaryPanel.this.m_size, this.calculateRegionProbs(n, n2), n == 0);
                        }
                    }
                    if (!BoundaryPanel.this.m_stopPlotting) {
                        BoundaryPanel.this.m_initialTiling = false;
                    }
                    n2 = BoundaryPanel.this.m_size / 2;
                    block26: while (BoundaryPanel.this.m_size > 1) {
                        for (n = 0; n <= BoundaryPanel.this.m_panelHeight; n += BoundaryPanel.this.m_size) {
                            for (int i = 0; i <= BoundaryPanel.this.m_panelWidth; i += BoundaryPanel.this.m_size) {
                                if (BoundaryPanel.this.m_stopPlotting) break block26;
                                if (BoundaryPanel.this.m_pausePlotting) {
                                    Double d = BoundaryPanel.this.m_dummy;
                                    synchronized (d) {
                                        try {
                                            BoundaryPanel.this.m_dummy.wait();
                                        }
                                        catch (InterruptedException interruptedException) {
                                            BoundaryPanel.this.m_pausePlotting = false;
                                        }
                                    }
                                }
                                boolean bl = i == 0 && n % 2 == 0;
                                BoundaryPanel.this.plotPoint(i, n + n2, n2, n2, this.calculateRegionProbs(i, n + n2), bl);
                                BoundaryPanel.this.plotPoint(i + n2, n + n2, n2, n2, this.calculateRegionProbs(i + n2, n + n2), bl);
                                BoundaryPanel.this.plotPoint(i + n2, n, n2, n2, this.calculateRegionProbs(i + n2, n), bl);
                            }
                        }
                        BoundaryPanel.this.m_size = n2;
                        n2 /= 2;
                    }
                    BoundaryPanel.this.update();
                    if (!BoundaryPanel.this.m_plotTrainingData) break block33;
                    BoundaryPanel.this.plotTrainingData();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(null, "Error while plotting: \"" + exception.getMessage() + "\"");
                }
                finally {
                    Vector vector;
                    BoundaryPanel.this.m_plotThread = null;
                    ActionEvent actionEvent = new ActionEvent(this, 0, "");
                    PlotThread plotThread = this;
                    synchronized (plotThread) {
                        vector = (Vector)BoundaryPanel.this.m_listeners.clone();
                    }
                    for (int i = 0; i < vector.size(); ++i) {
                        ActionListener actionListener = (ActionListener)vector.elementAt(i);
                        actionListener.actionPerformed(actionEvent);
                    }
                }
            }
        }

        private double[] calculateRegionProbs(int n, int n2) throws Exception {
            double[] dArray = new double[BoundaryPanel.this.m_trainingData.classAttribute().numValues()];
            for (int i = 0; i < BoundaryPanel.this.m_numOfSamplesPerRegion; ++i) {
                int n3;
                double[] dArray2 = new double[BoundaryPanel.this.m_trainingData.classAttribute().numValues()];
                this.m_weightingAttsValues[BoundaryPanel.this.m_xAttribute] = BoundaryPanel.this.getRandomX(n);
                this.m_weightingAttsValues[BoundaryPanel.this.m_yAttribute] = BoundaryPanel.this.getRandomY(BoundaryPanel.this.m_panelHeight - n2 - 1);
                BoundaryPanel.this.m_dataGenerator.setWeightingValues(this.m_weightingAttsValues);
                double[] dArray3 = BoundaryPanel.this.m_dataGenerator.getWeights();
                double d = Utils.sum(dArray3);
                int[] nArray = Utils.sort(dArray3);
                int[] nArray2 = new int[nArray.length];
                double d2 = 0.0;
                double d3 = 0.99 * d;
                int n4 = dArray3.length - 1;
                int n5 = 0;
                for (n3 = dArray3.length - 1; n3 >= 0; --n3) {
                    nArray2[n4--] = nArray[n3];
                    ++n5;
                    if ((d2 += dArray3[nArray[n3]]) > d3) break;
                }
                nArray = new int[n5];
                System.arraycopy(nArray2, n4 + 1, nArray, 0, n5);
                for (n3 = 0; n3 < BoundaryPanel.this.m_numOfSamplesPerGenerator; ++n3) {
                    BoundaryPanel.this.m_dataGenerator.setWeightingValues(this.m_weightingAttsValues);
                    double[][] dArray4 = BoundaryPanel.this.m_dataGenerator.generateInstances(nArray);
                    for (int j = 0; j < dArray4.length; ++j) {
                        if (dArray4[j] == null) continue;
                        System.arraycopy(dArray4[j], 0, this.m_vals, 0, this.m_vals.length);
                        this.m_vals[BoundaryPanel.this.m_xAttribute] = this.m_weightingAttsValues[BoundaryPanel.this.m_xAttribute];
                        this.m_vals[BoundaryPanel.this.m_yAttribute] = this.m_weightingAttsValues[BoundaryPanel.this.m_yAttribute];
                        this.m_dist = BoundaryPanel.this.m_classifier.distributionForInstance(this.m_predInst);
                        for (int k = 0; k < dArray2.length; ++k) {
                            int n6 = k;
                            dArray2[n6] = dArray2[n6] + this.m_dist[k] * dArray3[j];
                        }
                    }
                }
                for (n3 = 0; n3 < dArray.length; ++n3) {
                    int n7 = n3;
                    dArray[n7] = dArray[n7] + dArray2[n3] * d;
                }
            }
            Utils.normalize(dArray);
            if (n2 < BoundaryPanel.this.m_panelHeight && n < BoundaryPanel.this.m_panelWidth) {
                BoundaryPanel.this.m_probabilityCache[n2][n] = new double[dArray.length];
                System.arraycopy(dArray, 0, BoundaryPanel.this.m_probabilityCache[n2][n], 0, dArray.length);
            }
            return dArray;
        }
    }

    private class PlotPanel
    extends JPanel {
        public PlotPanel() {
            this.setToolTipText("");
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (BoundaryPanel.this.m_osi != null) {
                graphics.drawImage(BoundaryPanel.this.m_osi, 0, 0, this);
            }
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            if (BoundaryPanel.this.m_probabilityCache == null) {
                return null;
            }
            if (BoundaryPanel.this.m_probabilityCache[mouseEvent.getY()][mouseEvent.getX()] == null) {
                return null;
            }
            String string = "(X: " + Utils.doubleToString(BoundaryPanel.this.convertFromPanelX(mouseEvent.getX()), 2) + " Y: " + Utils.doubleToString(BoundaryPanel.this.convertFromPanelY(mouseEvent.getY()), 2) + ") ";
            for (int i = 0; i < BoundaryPanel.this.m_trainingData.classAttribute().numValues(); ++i) {
                string = string + Utils.doubleToString(BoundaryPanel.this.m_probabilityCache[mouseEvent.getY()][mouseEvent.getX()][i], 3) + " ";
            }
            return string;
        }
    }
}

