/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.pmml.consumer;

import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.classifiers.pmml.consumer.PMMLClassifier;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.matrix.Maths;
import weka.core.pmml.FieldMetaInfo;
import weka.core.pmml.MiningSchema;
import weka.core.pmml.PMMLUtils;
import weka.core.pmml.TargetMetaInfo;

public class GeneralRegression
extends PMMLClassifier
implements Serializable {
    private static final long serialVersionUID = 2583880411828388959L;
    protected ModelType m_modelType = ModelType.REGRESSION;
    protected String m_modelName;
    protected String m_algorithmName;
    protected int m_functionType = 0;
    protected CumulativeLinkFunction m_cumulativeLinkFunction = CumulativeLinkFunction.NONE;
    protected LinkFunction m_linkFunction = LinkFunction.NONE;
    protected double m_linkParameter = Double.NaN;
    protected String m_trialsVariable;
    protected double m_trialsValue = Double.NaN;
    protected Distribution m_distribution = Distribution.NORMAL;
    protected double m_distParameter = Double.NaN;
    protected String m_offsetVariable;
    protected double m_offsetValue = Double.NaN;
    protected ArrayList<Parameter> m_parameterList = new ArrayList();
    protected ArrayList<Predictor> m_factorList = new ArrayList();
    protected ArrayList<Predictor> m_covariateList = new ArrayList();
    protected PPCell[][] m_ppMatrix;
    protected PCell[][] m_paramMatrix;

    public GeneralRegression(Element element, Instances instances, MiningSchema miningSchema) throws Exception {
        super(instances, miningSchema);
        String string;
        String string2;
        String string3;
        String string32;
        String string4;
        String string5;
        String string6 = element.getAttribute("modelType");
        boolean bl = false;
        Object object2 = ModelType.values();
        int n = ((ModelType[])object2).length;
        for (int i = 0; i < n; ++i) {
            ModelType modelType = object2[i];
            if (!modelType.toString().equals(string6)) continue;
            this.m_modelType = modelType;
            bl = true;
            break;
        }
        if (!bl) {
            throw new Exception("[GeneralRegression] unknown model type: " + string6);
        }
        if (this.m_modelType == ModelType.ORDINALMULTINOMIAL) {
            object2 = element.getAttribute("cumulativeLink");
            bl = false;
            for (CumulativeLinkFunction object3 : CumulativeLinkFunction.values()) {
                if (!object3.toString().equals(object2)) continue;
                this.m_cumulativeLinkFunction = object3;
                bl = true;
                break;
            }
            if (!bl) {
                throw new Exception("[GeneralRegression] cumulative link function " + (String)object2);
            }
        } else if (this.m_modelType == ModelType.GENERALIZEDLINEAR || this.m_modelType == ModelType.GENERALLINEAR) {
            String string7;
            String string8;
            object2 = element.getAttribute("linkFunction");
            bl = false;
            for (LinkFunction illegalArgumentException : LinkFunction.values()) {
                if (!illegalArgumentException.toString().equals(object2)) continue;
                this.m_linkFunction = illegalArgumentException;
                bl = true;
                break;
            }
            if (!bl) {
                throw new Exception("[GeneralRegression] unknown link function " + (String)object2);
            }
            String string9 = element.getAttribute("linkParameter");
            if (string9 != null && string9.length() > 0) {
                try {
                    this.m_linkParameter = Double.parseDouble(string9);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new Exception("[GeneralRegression] unable to parse the link parameter");
                }
            }
            if ((string8 = element.getAttribute("trialsVariable")) != null && string8.length() > 0) {
                this.m_trialsVariable = string8;
            }
            if ((string7 = element.getAttribute("trialsValue")) != null && string7.length() > 0) {
                try {
                    this.m_trialsValue = Double.parseDouble(string7);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new Exception("[GeneralRegression] unable to parse the trials value");
                }
            }
        }
        if ((object2 = element.getAttribute("modelName")) != null && ((String)object2).length() > 0) {
            this.m_modelName = object2;
        }
        if ((string5 = element.getAttribute("functionName")).equals("classification")) {
            this.m_functionType = 1;
        }
        if ((string4 = element.getAttribute("algorithmName")) != null && string4.length() > 0) {
            this.m_algorithmName = string4;
        }
        if ((string32 = element.getAttribute("distribution")) != null && string32.length() > 0) {
            bl = false;
            for (Distribution distribution : Distribution.values()) {
                if (!distribution.toString().equals(string32)) continue;
                this.m_distribution = distribution;
                bl = true;
                break;
            }
            if (!bl) {
                throw new Exception("[GeneralRegression] unknown distribution type " + string32);
            }
        }
        if ((string3 = element.getAttribute("distParameter")) != null && string3.length() > 0) {
            try {
                this.m_distParameter = Double.parseDouble(string3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new Exception("[GeneralRegression] unable to parse the distribution parameter");
            }
        }
        if ((string2 = element.getAttribute("offsetVariable")) != null && string2.length() > 0) {
            this.m_offsetVariable = string2;
        }
        if ((string = element.getAttribute("offsetValue")) != null && string.length() > 0) {
            try {
                this.m_offsetValue = Double.parseDouble(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new Exception("[GeneralRegression] unable to parse the offset value");
            }
        }
        this.readParameterList(element);
        this.readFactorsAndCovariates(element, "FactorList");
        this.readFactorsAndCovariates(element, "CovariateList");
        this.readPPMatrix(element);
        this.readParamMatrix(element);
    }

    protected void readParameterList(Element element) throws Exception {
        NodeList nodeList = element.getElementsByTagName("ParameterList");
        if (nodeList.getLength() == 1) {
            Node node = nodeList.item(0);
            if (node.getNodeType() == 1) {
                NodeList nodeList2 = ((Element)node).getElementsByTagName("Parameter");
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    Node node2 = nodeList2.item(i);
                    if (node2.getNodeType() != 1) continue;
                    Parameter parameter = new Parameter();
                    parameter.m_name = ((Element)node2).getAttribute("name");
                    String string = ((Element)node2).getAttribute("label");
                    if (string != null && string.length() > 0) {
                        parameter.m_label = string;
                    }
                    this.m_parameterList.add(parameter);
                }
            }
        } else {
            throw new Exception("[GeneralRegression] more than one parameter list!");
        }
    }

    protected void readFactorsAndCovariates(Element element, String string) throws Exception {
        Instances instances = this.m_miningSchema.getFieldsAsInstances();
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() == 1) {
            Node node = nodeList.item(0);
            if (node.getNodeType() == 1) {
                NodeList nodeList2 = ((Element)node).getElementsByTagName("Predictor");
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    Node node2 = nodeList2.item(i);
                    if (node2.getNodeType() != 1) continue;
                    Predictor predictor = new Predictor();
                    predictor.m_name = ((Element)node2).getAttribute("name");
                    boolean bl = false;
                    for (int j = 0; j < instances.numAttributes(); ++j) {
                        if (!instances.attribute(j).name().equals(predictor.m_name)) continue;
                        bl = true;
                        predictor.m_miningSchemaIndex = j;
                        break;
                    }
                    if (bl) {
                        if (string.equals("FactorList")) {
                            this.m_factorList.add(predictor);
                            continue;
                        }
                        this.m_covariateList.add(predictor);
                        continue;
                    }
                    throw new Exception("[GeneralRegression] reading factors and covariates - unable to find predictor " + predictor.m_name + " in the mining schema");
                }
            }
        } else if (nodeList.getLength() > 1) {
            throw new Exception("[GeneralRegression] more than one " + string + "! ");
        }
    }

    protected void readPPMatrix(Element element) throws Exception {
        Instances instances = this.m_miningSchema.getFieldsAsInstances();
        NodeList nodeList = element.getElementsByTagName("PPMatrix");
        if (nodeList.getLength() == 1) {
            this.m_ppMatrix = new PPCell[this.m_parameterList.size()][instances.numAttributes()];
            Node node = nodeList.item(0);
            if (node.getNodeType() == 1) {
                NodeList nodeList2 = ((Element)node).getElementsByTagName("PPCell");
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    Serializable serializable;
                    Node node2 = nodeList2.item(i);
                    if (node2.getNodeType() != 1) continue;
                    String string = ((Element)node2).getAttribute("predictorName");
                    String string2 = ((Element)node2).getAttribute("parameterName");
                    String string3 = ((Element)node2).getAttribute("value");
                    double d = -1.0;
                    int n = -1;
                    int n2 = -1;
                    for (int j = 0; j < this.m_parameterList.size(); ++j) {
                        if (!this.m_parameterList.get((int)j).m_name.equals(string2)) continue;
                        n2 = j;
                        break;
                    }
                    if (n2 == -1) {
                        throw new Exception("[GeneralRegression] unable to find parameter name " + string2 + " in parameter list");
                    }
                    Predictor predictor = this.getCovariate(string);
                    if (predictor != null) {
                        try {
                            d = Double.parseDouble(string3);
                            n = predictor.m_miningSchemaIndex;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw new Exception("[GeneralRegression] unable to parse PPCell value: " + string3);
                        }
                    } else {
                        predictor = this.getFactor(string);
                        if (predictor != null) {
                            if (instances.attribute(predictor.m_miningSchemaIndex).isNumeric()) {
                                try {
                                    d = Double.parseDouble(string3);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw new Exception("[GeneralRegresion] unable to parse PPCell value: " + string3);
                                }
                            } else {
                                serializable = instances.attribute(predictor.m_miningSchemaIndex);
                                d = ((Attribute)serializable).indexOfValue(string3);
                                if (d == -1.0) {
                                    throw new Exception("[GeneralRegression] unable to find PPCell value " + string3 + " in mining schema attribute " + ((Attribute)serializable).name());
                                }
                            }
                        } else {
                            throw new Exception("[GeneralRegression] cant find predictor " + string + "in either the factors list " + "or the covariates list");
                        }
                        n = predictor.m_miningSchemaIndex;
                    }
                    serializable = new PPCell();
                    ((PPCell)serializable).m_predictorName = string;
                    ((PPCell)serializable).m_parameterName = string2;
                    ((PPCell)serializable).m_value = d;
                    this.m_ppMatrix[n2][n] = serializable;
                }
            }
        } else {
            throw new Exception("[GeneralRegression] more than one PPMatrix!");
        }
    }

    private Predictor getCovariate(String string) {
        for (int i = 0; i < this.m_covariateList.size(); ++i) {
            if (!string.equals(this.m_covariateList.get((int)i).m_name)) continue;
            return this.m_covariateList.get(i);
        }
        return null;
    }

    private Predictor getFactor(String string) {
        for (int i = 0; i < this.m_factorList.size(); ++i) {
            if (!string.equals(this.m_factorList.get((int)i).m_name)) continue;
            return this.m_factorList.get(i);
        }
        return null;
    }

    private void readParamMatrix(Element element) throws Exception {
        Instances instances = this.m_miningSchema.getFieldsAsInstances();
        Attribute attribute = instances.classAttribute();
        ArrayList<String> arrayList = null;
        NodeList nodeList = element.getElementsByTagName("ParamMatrix");
        if (nodeList.getLength() != 1) {
            throw new Exception("[GeneralRegression] more than one ParamMatrix!");
        }
        Element element2 = (Element)nodeList.item(0);
        if (this.m_functionType == 1 && attribute.isNumeric()) {
            if (!this.m_miningSchema.hasTargetMetaData()) {
                throw new Exception("[GeneralRegression] function type is classification and class attribute in mining schema is numeric, however, there is no Target element specifying legal discrete values for the target!");
            }
            if (this.m_miningSchema.getTargetMetaData().getOptype() != FieldMetaInfo.Optype.CATEGORICAL) {
                throw new Exception("[GeneralRegression] function type is classification and class attribute in mining schema is numeric, however Target element in PMML does not have optype categorical!");
            }
            arrayList = this.m_miningSchema.getTargetMetaData().getValues();
            if (arrayList.size() == 0) {
                throw new Exception("[GeneralRegression] function type is classification and class attribute in mining schema is numeric, however Target element in PMML does not have any discrete values defined!");
            }
            this.m_miningSchema.convertNumericAttToNominal(instances.classIndex(), arrayList);
        }
        this.m_paramMatrix = new PCell[attribute.isNumeric() ? 1 : attribute.numValues()][this.m_parameterList.size()];
        NodeList nodeList2 = element2.getElementsByTagName("PCell");
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            int n = -1;
            int n2 = -1;
            Node node = nodeList2.item(i);
            if (node.getNodeType() != 1) continue;
            String string = ((Element)node).getAttribute("parameterName");
            String string2 = ((Element)node).getAttribute("targetCategory");
            String string3 = ((Element)node).getAttribute("beta");
            String string4 = ((Element)node).getAttribute("df");
            for (int j = 0; j < this.m_parameterList.size(); ++j) {
                if (!this.m_parameterList.get((int)j).m_name.equals(string)) continue;
                n2 = j;
                if (this.m_parameterList.get((int)j).m_label == null) break;
                string = this.m_parameterList.get((int)j).m_label;
                break;
            }
            if (n2 == -1) {
                throw new Exception("[GeneralRegression] unable to find parameter name " + string + " in parameter list");
            }
            if (string2 != null && string2.length() > 0) {
                if (attribute.isNominal() || attribute.isString()) {
                    n = attribute.indexOfValue(string2);
                } else {
                    throw new Exception("[GeneralRegression] found a PCell with a named target category: " + string2 + " but class attribute is numeric in " + "mining schema");
                }
            }
            PCell pCell = new PCell();
            if (n != -1) {
                pCell.m_targetCategory = string2;
            }
            pCell.m_parameterName = string;
            try {
                pCell.m_beta = Double.parseDouble(string3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new Exception("[GeneralRegression] unable to parse beta value " + string3 + " as a double from PCell");
            }
            if (string4 != null && string4.length() > 0) {
                try {
                    pCell.m_df = Integer.parseInt(string4);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new Exception("[GeneralRegression] unable to parse df value " + string4 + " as an int from PCell");
                }
            }
            if (n != -1) {
                this.m_paramMatrix[n][n2] = pCell;
                continue;
            }
            for (int j = 0; j < this.m_paramMatrix.length; ++j) {
                this.m_paramMatrix[j][n2] = pCell;
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PMML version " + this.getPMMLVersion());
        if (!this.getCreatorApplication().equals("?")) {
            stringBuffer.append("\nApplication: " + this.getCreatorApplication());
        }
        stringBuffer.append("\nPMML Model: " + (Object)((Object)this.m_modelType));
        stringBuffer.append("\n\n");
        stringBuffer.append(this.m_miningSchema);
        if (this.m_factorList.size() > 0) {
            stringBuffer.append("Factors:\n");
            for (Predictor predictor : this.m_factorList) {
                stringBuffer.append("\t" + predictor + "\n");
            }
        }
        stringBuffer.append("\n");
        if (this.m_covariateList.size() > 0) {
            stringBuffer.append("Covariates:\n");
            for (Predictor predictor : this.m_covariateList) {
                stringBuffer.append("\t" + predictor + "\n");
            }
        }
        stringBuffer.append("\n");
        this.printPPMatrix(stringBuffer);
        stringBuffer.append("\n");
        this.printParameterMatrix(stringBuffer);
        stringBuffer.append("\n");
        if (this.m_linkFunction != LinkFunction.NONE) {
            stringBuffer.append("Link function: " + (Object)((Object)this.m_linkFunction));
            if (this.m_offsetVariable != null) {
                stringBuffer.append("\n\tOffset variable " + this.m_offsetVariable);
            } else if (!Double.isNaN(this.m_offsetValue)) {
                stringBuffer.append("\n\tOffset value " + this.m_offsetValue);
            }
            if (this.m_trialsVariable != null) {
                stringBuffer.append("\n\tTrials variable " + this.m_trialsVariable);
            } else if (!Double.isNaN(this.m_trialsValue)) {
                stringBuffer.append("\n\tTrials value " + this.m_trialsValue);
            }
            if (this.m_distribution != Distribution.NONE) {
                stringBuffer.append("\nDistribution: " + (Object)((Object)this.m_distribution));
            }
            if (this.m_linkFunction == LinkFunction.NEGBIN && this.m_distribution == Distribution.NEGBINOMIAL && !Double.isNaN(this.m_distParameter)) {
                stringBuffer.append("\n\tDistribution parameter " + this.m_distParameter);
            }
            if (!(this.m_linkFunction != LinkFunction.POWER && this.m_linkFunction != LinkFunction.ODDSPOWER || Double.isNaN(this.m_linkParameter))) {
                stringBuffer.append("\n\nLink parameter " + this.m_linkParameter);
            }
        }
        if (this.m_cumulativeLinkFunction != CumulativeLinkFunction.NONE) {
            stringBuffer.append("Cumulative link function: " + (Object)((Object)this.m_cumulativeLinkFunction));
            if (this.m_offsetVariable != null) {
                stringBuffer.append("\n\tOffset variable " + this.m_offsetVariable);
            } else if (!Double.isNaN(this.m_offsetValue)) {
                stringBuffer.append("\n\tOffset value " + this.m_offsetValue);
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    protected void printPPMatrix(StringBuffer stringBuffer) {
        int n;
        String string;
        int n2;
        Instances instances = this.m_miningSchema.getFieldsAsInstances();
        int n3 = 0;
        for (n2 = 0; n2 < instances.numAttributes(); ++n2) {
            Attribute attribute = instances.attribute(n2);
            if (attribute.name().length() <= n3) continue;
            n3 = attribute.name().length();
        }
        for (n2 = 0; n2 < this.m_parameterList.size(); ++n2) {
            for (int i = 0; i < instances.numAttributes(); ++i) {
                String string2;
                if (this.m_ppMatrix[n2][i] == null) continue;
                double d = Math.log(Math.abs(this.m_ppMatrix[n2][i].m_value)) / Math.log(10.0);
                if (d < 0.0) {
                    d = 1.0;
                }
                if ((int)(d += 2.0) > n3) {
                    n3 = (int)d;
                }
                if (!instances.attribute(i).isNominal() && !instances.attribute(i).isString() || (string2 = instances.attribute(i).value((int)this.m_ppMatrix[n2][i].m_value) + " ").length() <= n3) continue;
                n3 = string2.length();
            }
        }
        n2 = "Parameter  ".length();
        for (Parameter parameter : this.m_parameterList) {
            string = parameter.m_label != null ? parameter.m_label + " " : parameter.m_name + " ";
            if (string.length() <= n2) continue;
            n2 = string.length();
        }
        stringBuffer.append("Predictor-to-Parameter matrix:\n");
        stringBuffer.append(PMMLUtils.pad("Predictor", " ", n2 + (n3 * 2 + 2) - "Predictor".length(), true));
        stringBuffer.append("\n" + PMMLUtils.pad("Parameter", " ", n2 - "Parameter".length(), false));
        for (n = 0; n < instances.numAttributes(); ++n) {
            if (n == instances.classIndex()) continue;
            String string3 = instances.attribute(n).name();
            stringBuffer.append(PMMLUtils.pad(string3, " ", n3 + 1 - string3.length(), true));
        }
        stringBuffer.append("\n");
        for (n = 0; n < this.m_parameterList.size(); ++n) {
            Parameter parameter = this.m_parameterList.get(n);
            string = parameter.m_label != null ? parameter.m_label : parameter.m_name;
            stringBuffer.append(PMMLUtils.pad(string, " ", n2 - string.length(), false));
            for (int i = 0; i < instances.numAttributes(); ++i) {
                if (i == instances.classIndex()) continue;
                PPCell pPCell = this.m_ppMatrix[n][i];
                String string4 = " ";
                if (pPCell != null) {
                    string4 = instances.attribute(i).isNominal() || instances.attribute(i).isString() ? instances.attribute(i).value((int)pPCell.m_value) : "" + Utils.doubleToString(pPCell.m_value, n3, 4).trim();
                }
                stringBuffer.append(PMMLUtils.pad(string4, " ", n3 + 1 - string4.length(), true));
            }
            stringBuffer.append("\n");
        }
    }

    protected void printParameterMatrix(StringBuffer stringBuffer) {
        int n;
        int n2;
        int n3;
        Instances instances = this.m_miningSchema.getFieldsAsInstances();
        int n4 = instances.classAttribute().name().length();
        if (instances.classAttribute().isNominal() || instances.classAttribute().isString()) {
            for (n3 = 0; n3 < instances.classAttribute().numValues(); ++n3) {
                if (instances.classAttribute().value(n3).length() <= n4) continue;
                n4 = instances.classAttribute().value(n3).length();
            }
        }
        n3 = 0;
        for (n2 = 0; n2 < this.m_parameterList.size(); ++n2) {
            String string;
            Parameter parameter = this.m_parameterList.get(n2);
            String string2 = string = parameter.m_label != null ? parameter.m_label + " " : parameter.m_name + " ";
            if (string.length() <= n3) continue;
            n3 = string.length();
        }
        n2 = "Coeff.".length();
        for (n = 0; n < this.m_paramMatrix.length; ++n) {
            for (int i = 0; i < this.m_parameterList.size(); ++i) {
                PCell pCell = this.m_paramMatrix[n][i];
                if (pCell == null) continue;
                double d = Math.log(Math.abs(pCell.m_beta)) / Math.log(10.0);
                if (d < 0.0) {
                    d = 1.0;
                }
                if ((int)(d += 7.0) <= n2) continue;
                n2 = (int)d;
            }
        }
        stringBuffer.append("Parameter estimates:\n");
        stringBuffer.append(PMMLUtils.pad(instances.classAttribute().name(), " ", n4 + n3 + 2 - instances.classAttribute().name().length(), false));
        stringBuffer.append(PMMLUtils.pad("Coeff.", " ", n2 + 1 - "Coeff.".length(), true));
        stringBuffer.append(PMMLUtils.pad("df", " ", n2 - "df".length(), true));
        stringBuffer.append("\n");
        for (n = 0; n < this.m_paramMatrix.length; ++n) {
            boolean bl = false;
            for (int i = 0; i < this.m_parameterList.size(); ++i) {
                if (this.m_paramMatrix[n][i] == null) continue;
                bl = true;
            }
            if (!bl) continue;
            String string = instances.classAttribute().isNominal() || instances.classAttribute().isString() ? instances.classAttribute().value(n) : " ";
            stringBuffer.append(PMMLUtils.pad(string, " ", n4 - string.length(), false));
            stringBuffer.append("\n");
            for (int i = 0; i < this.m_parameterList.size(); ++i) {
                PCell pCell = this.m_paramMatrix[n][i];
                if (pCell == null) continue;
                String string3 = pCell.m_parameterName;
                stringBuffer.append(PMMLUtils.pad(string3, " ", n4 + n3 + 2 - string3.length(), true));
                String string4 = Utils.doubleToString(pCell.m_beta, n2, 4).trim();
                stringBuffer.append(PMMLUtils.pad(string4, " ", n2 + 1 - string4.length(), true));
                String string5 = Utils.doubleToString(pCell.m_df, n2, 4).trim();
                stringBuffer.append(PMMLUtils.pad(string5, " ", n2 - string5.length(), true));
                stringBuffer.append("\n");
            }
        }
    }

    private double[] incomingParamVector(double[] dArray) throws Exception {
        Instances instances = this.m_miningSchema.getFieldsAsInstances();
        double[] dArray2 = new double[this.m_parameterList.size()];
        for (int i = 0; i < this.m_parameterList.size(); ++i) {
            dArray2[i] = 1.0;
            for (int j = 0; j < instances.numAttributes(); ++j) {
                PPCell pPCell = this.m_ppMatrix[i][j];
                Predictor predictor = null;
                if (pPCell == null) continue;
                predictor = this.getFactor(pPCell.m_predictorName);
                if (predictor != null) {
                    if ((int)dArray[predictor.m_miningSchemaIndex] == (int)pPCell.m_value) {
                        int n = i;
                        dArray2[n] = dArray2[n] * 1.0;
                        continue;
                    }
                    int n = i;
                    dArray2[n] = dArray2[n] * 0.0;
                    continue;
                }
                predictor = this.getCovariate(pPCell.m_predictorName);
                if (predictor != null) {
                    int n = i;
                    dArray2[n] = dArray2[n] * Math.pow(dArray[predictor.m_miningSchemaIndex], pPCell.m_value);
                    continue;
                }
                throw new Exception("[GeneralRegression] can't find predictor " + pPCell.m_predictorName + " in either the list of factors or covariates");
            }
        }
        return dArray2;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (!this.m_initialized) {
            this.mapToMiningSchema(instance.dataset());
        }
        double[] dArray = null;
        dArray = this.m_miningSchema.getFieldsAsInstances().classAttribute().isNumeric() ? new double[1] : new double[this.m_miningSchema.getFieldsAsInstances().classAttribute().numValues()];
        double[] dArray2 = this.m_fieldsMap.instanceToSchema(instance, this.m_miningSchema);
        boolean bl = false;
        for (int i = 0; i < dArray2.length; ++i) {
            if (i == this.m_miningSchema.getFieldsAsInstances().classIndex() || !Double.isNaN(dArray2[i])) continue;
            bl = true;
            break;
        }
        if (bl) {
            if (!this.m_miningSchema.hasTargetMetaData()) {
                String string = "[GeneralRegression] WARNING: Instance to predict has missing value(s) but there is no missing value handling meta data and no prior probabilities/default value to fall back to. No prediction will be made (" + (this.m_miningSchema.getFieldsAsInstances().classAttribute().isNominal() || this.m_miningSchema.getFieldsAsInstances().classAttribute().isString() ? "zero probabilities output)." : "NaN output).");
                if (this.m_log == null) {
                    System.err.println(string);
                } else {
                    this.m_log.logMessage(string);
                }
                if (this.m_miningSchema.getFieldsAsInstances().classAttribute().isNumeric()) {
                    dArray[0] = Instance.missingValue();
                }
                return dArray;
            }
            TargetMetaInfo targetMetaInfo = this.m_miningSchema.getTargetMetaData();
            if (this.m_miningSchema.getFieldsAsInstances().classAttribute().isNumeric()) {
                dArray[0] = targetMetaInfo.getDefaultValue();
            } else {
                Instances instances = this.m_miningSchema.getFieldsAsInstances();
                for (int i = 0; i < instances.classAttribute().numValues(); ++i) {
                    dArray[i] = targetMetaInfo.getPriorProbability(instances.classAttribute().value(i));
                }
            }
            return dArray;
        }
        double[] dArray3 = this.incomingParamVector(dArray2);
        this.computeResponses(dArray2, dArray3, dArray);
        return dArray;
    }

    private void computeResponses(double[] dArray, double[] dArray2, double[] dArray3) throws Exception {
        for (int i = 0; i < dArray3.length; ++i) {
            for (int j = 0; j < this.m_parameterList.size(); ++j) {
                PCell pCell = this.m_paramMatrix[i][j];
                if (pCell == null) {
                    int n = i;
                    dArray3[n] = dArray3[n] + 0.0 * dArray2[j];
                    continue;
                }
                int n = i;
                dArray3[n] = dArray3[n] + dArray2[j] * pCell.m_beta;
            }
        }
        switch (this.m_modelType) {
            case MULTINOMIALLOGISTIC: {
                GeneralRegression.computeProbabilitiesMultinomialLogistic(dArray3);
                break;
            }
            case REGRESSION: {
                break;
            }
            case GENERALLINEAR: 
            case GENERALIZEDLINEAR: {
                if (this.m_linkFunction != LinkFunction.NONE) {
                    this.computeResponseGeneralizedLinear(dArray, dArray3);
                    break;
                }
                throw new Exception("[GeneralRegression] no link function specified!");
            }
            case ORDINALMULTINOMIAL: {
                if (this.m_cumulativeLinkFunction != CumulativeLinkFunction.NONE) {
                    this.computeResponseOrdinalMultinomial(dArray, dArray3);
                    break;
                }
                throw new Exception("[GeneralRegression] no cumulative link function specified!");
            }
            default: {
                throw new Exception("[GeneralRegression] unknown model type");
            }
        }
    }

    private static void computeProbabilitiesMultinomialLogistic(double[] dArray) {
        double[] dArray2 = (double[])dArray.clone();
        for (int i = 0; i < dArray2.length; ++i) {
            double d = 0.0;
            boolean bl = false;
            for (int j = 0; j < dArray2.length; ++j) {
                if (dArray2[j] - dArray2[i] > 700.0) {
                    bl = true;
                    break;
                }
                d += Math.exp(dArray2[j] - dArray2[i]);
            }
            dArray[i] = bl ? 0.0 : 1.0 / d;
        }
    }

    private void computeResponseGeneralizedLinear(double[] dArray, double[] dArray2) throws Exception {
        double[] dArray3 = (double[])dArray2.clone();
        double d = 0.0;
        if (this.m_offsetVariable != null) {
            Attribute attribute = this.m_miningSchema.getFieldsAsInstances().attribute(this.m_offsetVariable);
            if (attribute == null) {
                throw new Exception("[GeneralRegression] unable to find offset variable " + this.m_offsetVariable + " in the mining schema!");
            }
            d = dArray[attribute.index()];
        } else if (!Double.isNaN(this.m_offsetValue)) {
            d = this.m_offsetValue;
        }
        double d2 = 1.0;
        if (this.m_trialsVariable != null) {
            Attribute attribute = this.m_miningSchema.getFieldsAsInstances().attribute(this.m_trialsVariable);
            if (attribute == null) {
                throw new Exception("[GeneralRegression] unable to find trials variable " + this.m_trialsVariable + " in the mining schema!");
            }
            d2 = dArray[attribute.index()];
        } else if (!Double.isNaN(this.m_trialsValue)) {
            d2 = this.m_trialsValue;
        }
        double d3 = 0.0;
        if (this.m_linkFunction == LinkFunction.NEGBIN && this.m_distribution == Distribution.NEGBINOMIAL) {
            if (Double.isNaN(this.m_distParameter)) {
                throw new Exception("[GeneralRegression] no distribution parameter defined!");
            }
            d3 = this.m_distParameter;
        }
        double d4 = 0.0;
        if (this.m_linkFunction == LinkFunction.POWER || this.m_linkFunction == LinkFunction.ODDSPOWER) {
            if (Double.isNaN(this.m_linkParameter)) {
                throw new Exception("[GeneralRegression] no link parameter defined!");
            }
            d4 = this.m_linkParameter;
        }
        for (int i = 0; i < dArray3.length; ++i) {
            dArray2[i] = this.m_linkFunction.eval(dArray3[i], d, d2, d3, d4);
        }
    }

    private void computeResponseOrdinalMultinomial(double[] dArray, double[] dArray2) throws Exception {
        double[] dArray3 = (double[])dArray2.clone();
        double d = 0.0;
        if (this.m_offsetVariable != null) {
            Attribute attribute = this.m_miningSchema.getFieldsAsInstances().attribute(this.m_offsetVariable);
            if (attribute == null) {
                throw new Exception("[GeneralRegression] unable to find offset variable " + this.m_offsetVariable + " in the mining schema!");
            }
            d = dArray[attribute.index()];
        } else if (!Double.isNaN(this.m_offsetValue)) {
            d = this.m_offsetValue;
        }
        for (int i = 0; i < dArray3.length; ++i) {
            dArray2[i] = i == 0 ? this.m_cumulativeLinkFunction.eval(dArray3[i], d) : (i == dArray3.length - 1 ? 1.0 - dArray2[i - 1] : this.m_cumulativeLinkFunction.eval(dArray3[i], d) - dArray2[i - 1]);
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.1 $");
    }

    static class PCell
    implements Serializable {
        private static final long serialVersionUID = 6502780192411755341L;
        protected String m_targetCategory = null;
        protected String m_parameterName = null;
        protected double m_beta = 0.0;
        protected int m_df = -1;

        PCell() {
        }
    }

    static class PPCell
    implements Serializable {
        private static final long serialVersionUID = 6502780192411755341L;
        protected String m_predictorName = null;
        protected String m_parameterName = null;
        protected double m_value = 0.0;
        protected String m_targetCategory = null;

        PPCell() {
        }
    }

    static class Predictor
    implements Serializable {
        private static final long serialVersionUID = 6502780192411755341L;
        protected String m_name = null;
        protected int m_miningSchemaIndex = -1;

        Predictor() {
        }

        public String toString() {
            return this.m_name;
        }
    }

    static class Parameter
    implements Serializable {
        private static final long serialVersionUID = 6502780192411755341L;
        protected String m_name = null;
        protected String m_label = null;

        Parameter() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Distribution {
        NONE("none"),
        NORMAL("normal"),
        BINOMIAL("binomial"),
        GAMMA("gamma"),
        INVGAUSSIAN("igauss"),
        NEGBINOMIAL("negbin"),
        POISSON("poisson");

        private final String m_stringVal;

        private Distribution(String string2) {
            this.m_stringVal = string2;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum LinkFunction {
        NONE("none"){

            double eval(double d, double d2, double d3, double d4, double d5) {
                return Double.NaN;
            }
        }
        ,
        CLOGLOG("cloglog"){

            double eval(double d, double d2, double d3, double d4, double d5) {
                return (1.0 - Math.exp(-Math.exp(d + d2))) * d3;
            }
        }
        ,
        IDENTITY("identity"){

            double eval(double d, double d2, double d3, double d4, double d5) {
                return (d + d2) * d3;
            }
        }
        ,
        LOG("log"){

            double eval(double d, double d2, double d3, double d4, double d5) {
                return Math.exp(d + d2) * d3;
            }
        }
        ,
        LOGC("logc"){

            double eval(double d, double d2, double d3, double d4, double d5) {
                return (1.0 - Math.exp(d + d2)) * d3;
            }
        }
        ,
        LOGIT("logit"){

            double eval(double d, double d2, double d3, double d4, double d5) {
                return 1.0 / (1.0 + Math.exp(-(d + d2))) * d3;
            }
        }
        ,
        LOGLOG("loglog"){

            double eval(double d, double d2, double d3, double d4, double d5) {
                return Math.exp(-Math.exp(-(d + d2))) * d3;
            }
        }
        ,
        NEGBIN("negbin"){

            double eval(double d, double d2, double d3, double d4, double d5) {
                return 1.0 / (d4 * (Math.exp(-(d + d2)) - 1.0)) * d3;
            }
        }
        ,
        ODDSPOWER("oddspower"){

            double eval(double d, double d2, double d3, double d4, double d5) {
                return d5 < 0.0 || d5 > 0.0 ? 1.0 / (1.0 + Math.pow(1.0 + d5 * (d + d2), -1.0 / d5)) * d3 : 1.0 / (1.0 + Math.exp(-(d + d2))) * d3;
            }
        }
        ,
        POWER("power"){

            double eval(double d, double d2, double d3, double d4, double d5) {
                return d5 < 0.0 || d5 > 0.0 ? Math.pow(d + d2, 1.0 / d5) * d3 : Math.exp(d + d2) * d3;
            }
        }
        ,
        PROBIT("probit"){

            double eval(double d, double d2, double d3, double d4, double d5) {
                return Maths.pnorm(d + d2) * d3;
            }
        };

        private final String m_stringVal;

        abstract double eval(double var1, double var3, double var5, double var7, double var9);

        private LinkFunction(String string2) {
            this.m_stringVal = string2;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CumulativeLinkFunction {
        NONE("none"){

            double eval(double d, double d2) {
                return Double.NaN;
            }
        }
        ,
        LOGIT("logit"){

            double eval(double d, double d2) {
                return 1.0 / (1.0 + Math.exp(-(d + d2)));
            }
        }
        ,
        PROBIT("probit"){

            double eval(double d, double d2) {
                return Maths.pnorm(d + d2);
            }
        }
        ,
        CLOGLOG("cloglog"){

            double eval(double d, double d2) {
                return 1.0 - Math.exp(-Math.exp(d + d2));
            }
        }
        ,
        LOGLOG("loglog"){

            double eval(double d, double d2) {
                return Math.exp(-Math.exp(-(d + d2)));
            }
        }
        ,
        CAUCHIT("cauchit"){

            double eval(double d, double d2) {
                return 0.5 + 0.3183098861837907 * Math.atan(d + d2);
            }
        };

        private final String m_stringVal;

        abstract double eval(double var1, double var3);

        private CumulativeLinkFunction(String string2) {
            this.m_stringVal = string2;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ModelType {
        REGRESSION("regression"),
        GENERALLINEAR("generalLinear"),
        MULTINOMIALLOGISTIC("multinomialLogistic"),
        ORDINALMULTINOMIAL("ordinalMultinomial"),
        GENERALIZEDLINEAR("generalizedLinear");

        private final String m_stringVal;

        private ModelType(String string2) {
            this.m_stringVal = string2;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }
}

