/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.ClassDiscovery;
import weka.core.Javadoc;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class OptionHandlerJavadoc
extends Javadoc {
    public static final String OPTIONS_STARTTAG = "<!-- options-start -->";
    public static final String OPTIONS_ENDTAG = "<!-- options-end -->";
    protected boolean m_Prolog = true;

    public OptionHandlerJavadoc() {
        this.m_StartTag = new String[1];
        this.m_EndTag = new String[1];
        this.m_StartTag[0] = OPTIONS_STARTTAG;
        this.m_EndTag[0] = OPTIONS_ENDTAG;
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tSuppresses the 'Valid options are...' prolog in the Javadoc.", "noprolog", 0, "-noprolog"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        this.setProlog(!Utils.getFlag("noprolog", stringArray));
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        if (!this.getProlog()) {
            vector.add("-noprolog");
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void setProlog(boolean bl) {
        this.m_Prolog = bl;
    }

    public boolean getProlog() {
        return this.m_Prolog;
    }

    protected String generateJavadoc(int n) throws Exception {
        String string = "";
        if (n == 0) {
            if (!this.canInstantiateClass()) {
                return string;
            }
            if (!ClassDiscovery.hasInterface(OptionHandler.class, this.getInstance().getClass())) {
                throw new Exception("Class '" + this.getClassname() + "' is not an OptionHandler!");
            }
            OptionHandler optionHandler = (OptionHandler)this.getInstance();
            Enumeration enumeration = optionHandler.listOptions();
            if (!enumeration.hasMoreElements()) {
                return string;
            }
            if (this.getProlog()) {
                string = "Valid options are: <p/>\n\n";
            }
            enumeration = optionHandler.listOptions();
            while (enumeration.hasMoreElements()) {
                Option option = (Option)enumeration.nextElement();
                String string2 = this.toHTML(option.synopsis()) + "\n" + this.toHTML(option.description().replaceAll("\\t", " "));
                string = string + "<pre> " + string2.replaceAll("<br/>", "") + "</pre>\n\n";
            }
            if (this.getUseStars()) {
                string = this.indent(string, 1, "* ");
            }
        }
        return string;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.8 $");
    }

    public static void main(String[] stringArray) {
        OptionHandlerJavadoc.runJavadoc(new OptionHandlerJavadoc(), stringArray);
    }
}

