/*
 * Decompiled with CFR 0.152.
 */
package weka.core.parser.JFlex;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import weka.core.parser.JFlex.Action;
import weka.core.parser.JFlex.EOFActions;
import weka.core.parser.JFlex.ErrorMessages;
import weka.core.parser.JFlex.GeneratorException;
import weka.core.parser.JFlex.LexParse;
import weka.core.parser.JFlex.LexScan;
import weka.core.parser.JFlex.Options;
import weka.core.parser.JFlex.Out;
import weka.core.parser.JFlex.StatePairList;

public final class DFA {
    private static final int STATES = 500;
    public static final int NO_TARGET = -1;
    int[][] table;
    boolean[] isFinal;
    boolean[] isPushback;
    boolean[] isLookEnd;
    Action[] action;
    int[] lexState;
    int numStates;
    int numInput;
    Hashtable usedActions = new Hashtable();

    public DFA(int n, int n2) {
        this.numInput = n2;
        int n3 = Math.max(n, 500);
        this.table = new int[n3][this.numInput];
        this.action = new Action[n3];
        this.isFinal = new boolean[n3];
        this.isPushback = new boolean[n3];
        this.isLookEnd = new boolean[n3];
        this.lexState = new int[n];
        this.numStates = 0;
        for (int i = 0; i < n3; ++i) {
            for (int n4 = 0; n4 < this.numInput; n4 = (int)((char)(n4 + 1))) {
                this.table[i][n4] = -1;
            }
        }
    }

    public void setLexState(int n, int n2) {
        this.lexState[n] = n2;
    }

    private void ensureStateCapacity(int n) {
        int n2;
        int n3 = this.isFinal.length;
        if (n < n3) {
            return;
        }
        for (n2 = n3 * 2; n2 <= n; n2 *= 2) {
        }
        boolean[] blArray = new boolean[n2];
        boolean[] blArray2 = new boolean[n2];
        boolean[] blArray3 = new boolean[n2];
        Action[] actionArray = new Action[n2];
        int[][] nArray = new int[n2][this.numInput];
        System.arraycopy(this.isFinal, 0, blArray, 0, this.numStates);
        System.arraycopy(this.isPushback, 0, blArray2, 0, this.numStates);
        System.arraycopy(this.isLookEnd, 0, blArray3, 0, this.numStates);
        System.arraycopy(this.action, 0, actionArray, 0, this.numStates);
        System.arraycopy(this.table, 0, nArray, 0, n3);
        for (int i = n3; i < n2; ++i) {
            for (int j = 0; j < this.numInput; ++j) {
                nArray[i][j] = -1;
            }
        }
        this.isFinal = blArray;
        this.isPushback = blArray2;
        this.isLookEnd = blArray3;
        this.action = actionArray;
        this.table = nArray;
    }

    public void setAction(int n, Action action) {
        this.action[n] = action;
        if (action != null) {
            this.isLookEnd[n] = action.isLookAction();
            this.usedActions.put(action, action);
        }
    }

    public void setFinal(int n, boolean bl) {
        this.isFinal[n] = bl;
    }

    public void setPushback(int n, boolean bl) {
        this.isPushback[n] = bl;
    }

    public void addTransition(int n, char c, int n2) {
        int n3 = Math.max(n, n2) + 1;
        this.ensureStateCapacity(n3);
        if (n3 > this.numStates) {
            this.numStates = n3;
        }
        this.table[n][c] = n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.numStates; ++i) {
            stringBuffer.append("State ");
            if (this.isFinal[i]) {
                stringBuffer.append("[FINAL] ");
            }
            if (this.isPushback[i]) {
                stringBuffer.append("[PUSH] ");
            }
            stringBuffer.append(i + ":" + Out.NL);
            for (int n = 0; n < this.numInput; n = (int)((char)(n + 1))) {
                if (this.table[i][n] < 0) continue;
                stringBuffer.append("  with " + n + " in " + this.table[i][n] + Out.NL);
            }
        }
        return stringBuffer.toString();
    }

    public void writeDot(File file) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            printWriter.println(this.dotFormat());
            printWriter.close();
        }
        catch (IOException iOException) {
            Out.error(ErrorMessages.FILE_WRITE, file);
            throw new GeneratorException();
        }
    }

    public String dotFormat() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("digraph DFA {" + Out.NL);
        stringBuffer.append("rankdir = LR" + Out.NL);
        for (n = 0; n < this.numStates; ++n) {
            if (this.isFinal[n] || this.isPushback[n]) {
                stringBuffer.append(n);
            }
            if (this.isFinal[n]) {
                stringBuffer.append(" [shape = doublecircle]");
            }
            if (this.isPushback[n]) {
                stringBuffer.append(" [shape = box]");
            }
            if (!this.isFinal[n] && !this.isPushback[n]) continue;
            stringBuffer.append(Out.NL);
        }
        for (n = 0; n < this.numStates; ++n) {
            for (int i = 0; i < this.numInput; ++i) {
                if (this.table[n][i] < 0) continue;
                stringBuffer.append(n + " -> " + this.table[n][i]);
                stringBuffer.append(" [label=\"[" + i + "]\"]" + Out.NL);
            }
        }
        stringBuffer.append("}" + Out.NL);
        return stringBuffer.toString();
    }

    public void checkActions(LexScan lexScan, LexParse lexParse) {
        EOFActions eOFActions = lexParse.getEOFActions();
        Enumeration enumeration = lexScan.actions.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e.equals(this.usedActions.get(e)) || eOFActions.isEOFAction(e)) continue;
            Out.warning(lexScan.file, ErrorMessages.NEVER_MATCH, ((Action)e).priority - 1, -1);
        }
    }

    public void minimize() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        Out.print(this.numStates + " states before minimization, ");
        if (this.numStates == 0) {
            Out.error(ErrorMessages.ZERO_STATES);
            throw new GeneratorException();
        }
        if (Options.no_minimize) {
            Out.println("minimization skipped.");
            return;
        }
        int n10 = this.numStates + 1;
        int[] nArray = new int[2 * n10];
        int[] nArray2 = new int[2 * n10];
        int[] nArray3 = new int[2 * n10];
        int n11 = n10;
        int n12 = n10;
        int[] nArray4 = new int[n10 * this.numInput + 1];
        int[] nArray5 = new int[n10 * this.numInput + 1];
        int n13 = n10 * this.numInput;
        int[][] nArray6 = new int[n10][this.numInput];
        int[] nArray7 = new int[2 * n10 * this.numInput];
        int[] nArray8 = new int[2 * n10];
        int[] nArray9 = new int[2 * n10];
        int[] nArray10 = new int[n10];
        int n14 = 0;
        int[] nArray11 = new int[n10];
        int[] nArray12 = new int[n10];
        for (n9 = 0; n9 < this.numInput; ++n9) {
            for (n8 = 0; n8 < n10; ++n8) {
                nArray12[n8] = -1;
                nArray6[n8][n9] = -1;
            }
            nArray6[0][n9] = 0;
            nArray12[0] = 0;
            for (n8 = 1; n8 < n10; ++n8) {
                n7 = this.table[n8 - 1][n9] + 1;
                if (nArray12[n7] == -1) {
                    nArray6[n7][n9] = n8;
                    nArray12[n7] = n8;
                    continue;
                }
                nArray11[nArray12[n7]] = n8;
                nArray12[n7] = n8;
            }
            for (n8 = 0; n8 < n10; ++n8) {
                n7 = nArray6[n8][n9];
                nArray6[n8][n9] = n14;
                n6 = nArray12[n8];
                int n15 = n5 = n7 != -1 ? 1 : 0;
                while (n5 != 0) {
                    n5 = n7 != n6 ? 1 : 0;
                    nArray7[n14++] = n7;
                    n7 = nArray11[n7];
                }
                nArray7[n14++] = -1;
            }
        }
        nArray2[n12] = 0;
        nArray3[n12] = 0;
        nArray2[0] = n12;
        nArray3[0] = n12;
        nArray[0] = n12;
        nArray[n12] = 1;
        for (n9 = 1; n9 < n10; ++n9) {
            n7 = 0;
            for (n8 = n12 + 1; n7 == 0 && n8 <= n11; ++n8) {
                n6 = nArray2[n8];
                int n16 = n7 = this.isPushback[n9 - 1] == this.isPushback[n6 - 1] && this.isLookEnd[n9 - 1] == this.isLookEnd[n6 - 1] ? 1 : 0;
                if (n7 == 0) continue;
                if (this.isFinal[n9 - 1]) {
                    n7 = this.isFinal[n6 - 1] && this.action[n9 - 1].isEquiv(this.action[n6 - 1]) ? 1 : 0;
                } else {
                    int n17 = n7 = !this.isFinal[n6 - 1] ? 1 : 0;
                }
                if (n7 == 0) continue;
                nArray[n9] = n8;
                int n18 = n8;
                nArray[n18] = nArray[n18] + 1;
                n5 = nArray3[n8];
                nArray2[n5] = n9;
                nArray2[n9] = n8;
                nArray3[n8] = n9;
                nArray3[n9] = n5;
            }
            if (n7 != 0) continue;
            nArray[n9] = n8;
            int n19 = n8;
            nArray[n19] = nArray[n19] + 1;
            nArray2[n8] = n9;
            nArray2[n9] = n8;
            nArray3[n8] = n9;
            nArray3[n9] = n8;
            ++n11;
        }
        n9 = n12;
        for (n8 = n12 + 1; n8 <= n11; ++n8) {
            if (nArray[n9] >= nArray[n8]) continue;
            n9 = n8;
        }
        nArray4[n13] = n13;
        nArray5[n13] = n13;
        n8 = n9 == n12 ? n12 + 1 : n12;
        n7 = (n8 - n12) * this.numInput;
        while (n7 < (n8 + 1 - n12) * this.numInput) {
            n6 = nArray5[n13];
            nArray4[n6] = n7;
            nArray4[n7] = n13;
            nArray5[n7] = n6;
            nArray5[n13] = n7++;
        }
        while (n8 <= n11) {
            if (n8 != n9) {
                n7 = (n8 - n12) * this.numInput;
                while (n7 < (n8 + 1 - n12) * this.numInput) {
                    n6 = nArray5[n13];
                    nArray4[n6] = n7;
                    nArray4[n7] = n13;
                    nArray5[n7] = n6;
                    nArray5[n13] = n7++;
                }
            }
            ++n8;
        }
        while (nArray4[n13] != n13) {
            n6 = nArray4[n13];
            nArray4[n13] = nArray4[n6];
            nArray5[nArray4[n13]] = n13;
            nArray4[n6] = 0;
            n5 = n12 + n6 / this.numInput;
            int n20 = n6 % this.numInput;
            int n21 = 0;
            n4 = nArray2[n5];
            while (n4 != n5) {
                n3 = nArray6[n4][n20];
                while (nArray7[n3] != -1) {
                    nArray10[n21++] = nArray7[n3++];
                }
                n4 = nArray2[n4];
            }
            int n22 = 0;
            for (n3 = 0; n3 < n21; ++n3) {
                n4 = nArray10[n3];
                n8 = nArray[n4];
                nArray9[n8] = -1;
                nArray8[n8] = 0;
            }
            for (n3 = 0; n3 < n21; ++n3) {
                n4 = nArray10[n3];
                n8 = nArray[n4];
                if (nArray9[n8] >= 0) continue;
                nArray9[n8] = 0;
                n2 = nArray2[n8];
                while (!(n2 == n8 || n2 == 0 && nArray[0] != n5 || n2 != 0 && nArray[this.table[n2 - 1][n20] + 1] != n5)) {
                    int n23 = n8;
                    nArray9[n23] = nArray9[n23] + 1;
                    n2 = nArray2[n2];
                }
            }
            for (n3 = 0; n3 < n21; ++n3) {
                n4 = nArray10[n3];
                n8 = nArray[n4];
                if (nArray9[n8] == nArray[n8]) continue;
                n2 = nArray8[n8];
                if (n2 == 0) {
                    nArray2[n2] = n2 = ++n11;
                    nArray3[n2] = n2;
                    nArray8[n8] = n2;
                    nArray8[n22++] = n8;
                }
                nArray2[nArray3[n4]] = nArray2[n4];
                nArray3[nArray2[n4]] = nArray3[n4];
                n = nArray3[n2];
                nArray2[n] = n4;
                nArray2[n4] = n2;
                nArray3[n4] = n;
                nArray3[n2] = n4;
                nArray[n4] = n2;
                int n24 = n2;
                nArray[n24] = nArray[n24] + 1;
                int n25 = n8;
                nArray[n25] = nArray[n25] - 1;
                int n26 = n8;
                nArray9[n26] = nArray9[n26] - 1;
            }
            for (n3 = 0; n3 < n22; ++n3) {
                n8 = nArray8[n3];
                n2 = nArray8[n8];
                for (n = 0; n < this.numInput; ++n) {
                    int n27;
                    int n28 = (n8 - n12) * this.numInput + n;
                    int n29 = (n2 - n12) * this.numInput + n;
                    if (nArray4[n28] > 0) {
                        n27 = nArray5[n13];
                        nArray5[n13] = n29;
                        nArray4[n27] = n29;
                        nArray5[n29] = n27;
                        nArray4[n29] = n13;
                        continue;
                    }
                    if (nArray[n8] <= nArray[n2]) {
                        n27 = nArray5[n13];
                        nArray5[n13] = n28;
                        nArray4[n27] = n28;
                        nArray5[n28] = n27;
                        nArray4[n28] = n13;
                        continue;
                    }
                    n27 = nArray5[n13];
                    nArray5[n13] = n29;
                    nArray4[n27] = n29;
                    nArray5[n29] = n27;
                    nArray4[n29] = n13;
                }
            }
        }
        int[] nArray13 = new int[this.numStates];
        boolean[] blArray = new boolean[this.numStates];
        int[] nArray14 = new int[this.numStates];
        for (n4 = n12 + 1; n4 <= n11; ++n4) {
            n2 = n3 = nArray2[n4];
            while (n3 != n4) {
                if (n2 > n3) {
                    n2 = n3;
                }
                n3 = nArray2[n3];
            }
            --n2;
            n3 = nArray2[n4] - 1;
            while (n3 != n4 - 1) {
                nArray13[n3] = n2;
                blArray[n3] = n3 != n2;
                n3 = nArray2[n3 + 1] - 1;
            }
        }
        n4 = 0;
        for (n3 = 0; n3 < this.numStates; ++n3) {
            if (blArray[n3]) {
                ++n4;
                continue;
            }
            nArray14[n3] = n4;
        }
        n2 = 0;
        for (n3 = 0; n3 < this.numStates; ++n3) {
            if (blArray[n3]) continue;
            for (n = 0; n < this.numInput; ++n) {
                if (this.table[n3][n] >= 0) {
                    this.table[n2][n] = nArray13[this.table[n3][n]];
                    int[] nArray15 = this.table[n2];
                    int n30 = n;
                    nArray15[n30] = nArray15[n30] - nArray14[this.table[n2][n]];
                    continue;
                }
                this.table[n2][n] = this.table[n3][n];
            }
            this.isFinal[n2] = this.isFinal[n3];
            this.isPushback[n2] = this.isPushback[n3];
            this.isLookEnd[n2] = this.isLookEnd[n3];
            this.action[n2] = this.action[n3];
            ++n2;
        }
        this.numStates = n2;
        for (n3 = 0; n3 < this.lexState.length; ++n3) {
            this.lexState[n3] = nArray13[this.lexState[n3]];
            int n31 = n3;
            this.lexState[n31] = this.lexState[n31] - nArray14[this.lexState[n3]];
        }
        Out.println(this.numStates + " states in minimized DFA");
    }

    public String toString(int[] nArray) {
        int n;
        String string = "{";
        for (n = 0; n < nArray.length - 1; ++n) {
            string = string + nArray[n] + ",";
        }
        return string + nArray[n] + "}";
    }

    public void printBlocks(int[] nArray, int[] nArray2, int[] nArray3, int n) {
        int n2;
        Out.dump("block     : " + this.toString(nArray));
        Out.dump("b_forward : " + this.toString(nArray2));
        Out.dump("b_backward: " + this.toString(nArray3));
        Out.dump("lastBlock : " + n);
        for (int i = n2 = this.numStates + 1; i <= n; ++i) {
            Out.dump("Block " + (i - n2) + " (size " + nArray[i] + "):");
            String string = "{";
            int n3 = nArray2[i];
            while (n3 != i) {
                string = string + (n3 - 1);
                int n4 = n3;
                if ((n3 = nArray2[n3]) != i) {
                    string = string + ",";
                    if (nArray[n3] != i) {
                        Out.dump("consistency error for state " + (n3 - 1) + " (block " + nArray[n3] + ")");
                    }
                }
                if (nArray3[n3] == n4) continue;
                Out.dump("consistency error for b_back in state " + (n3 - 1) + " (back = " + nArray3[n3] + ", should be = " + n4 + ")");
            }
            Out.dump(string + "}");
        }
    }

    public void printL(int[] nArray, int[] nArray2, int n) {
        String string = "L = {";
        int n2 = nArray[n];
        while (n2 != n) {
            int n3 = n2 / this.numInput;
            int n4 = n2 % this.numInput;
            string = string + "(" + n3 + "," + n4 + ")";
            int n5 = n2;
            if ((n2 = nArray[n2]) != n) {
                string = string + ",";
            }
            if (nArray2[n2] == n5) continue;
            Out.dump("consistency error for (" + n3 + "," + n4 + ")");
        }
        Out.dump(string + "}");
    }

    public boolean[][] old_minimize() {
        int n;
        int n2;
        Out.print(this.numStates + " states before minimization, ");
        if (this.numStates == 0) {
            Out.error(ErrorMessages.ZERO_STATES);
            throw new GeneratorException();
        }
        if (Options.no_minimize) {
            Out.println("minimization skipped.");
            return null;
        }
        boolean[][] blArrayArray = new boolean[this.numStates][];
        StatePairList[][] statePairListArray = new StatePairList[this.numStates][];
        for (n2 = 1; n2 < this.numStates; ++n2) {
            statePairListArray[n2] = new StatePairList[n2];
            blArrayArray[n2] = new boolean[n2];
            for (n = 0; n < n2; ++n) {
                blArrayArray[n2][n] = this.isFinal[n2] && this.isFinal[n] && this.isPushback[n2] == this.isPushback[n] && this.isLookEnd[n2] == this.isLookEnd[n] ? this.action[n2].isEquiv(this.action[n]) : !this.isFinal[n] && !this.isFinal[n2] && this.isPushback[n2] == this.isPushback[n] && this.isLookEnd[n2] == this.isLookEnd[n];
            }
        }
        for (n2 = 1; n2 < this.numStates; ++n2) {
            Out.debug("Testing state " + n2);
            for (n = 0; n < n2; ++n) {
                int n3;
                int n4;
                int n5;
                int n6;
                if (!blArrayArray[n2][n]) continue;
                for (n6 = 0; n6 < this.numInput; n6 = (int)((char)(n6 + 1))) {
                    if (!blArrayArray[n2][n]) continue;
                    n5 = this.table[n2][n6];
                    n4 = this.table[n][n6];
                    if (n5 < n4) {
                        n3 = n5;
                        n5 = n4;
                        n4 = n3;
                    }
                    if (n5 < 0 && n4 < 0 || n5 == n4 || n5 != -1 && n4 != -1 && blArrayArray[n5][n4]) continue;
                    blArrayArray[n2][n] = false;
                    if (statePairListArray[n2][n] == null) continue;
                    statePairListArray[n2][n].markAll(statePairListArray, blArrayArray);
                }
                if (!blArrayArray[n2][n]) continue;
                for (n6 = 0; n6 < this.numInput; n6 = (int)((char)(n6 + 1))) {
                    n5 = this.table[n2][n6];
                    n4 = this.table[n][n6];
                    if (n5 < n4) {
                        n3 = n5;
                        n5 = n4;
                        n4 = n3;
                    }
                    if (n5 == n4 || n5 < 0 || n4 < 0) continue;
                    if (statePairListArray[n5][n4] == null) {
                        statePairListArray[n5][n4] = new StatePairList();
                    }
                    statePairListArray[n5][n4].addPair(n2, n);
                }
            }
        }
        return blArrayArray;
    }

    public void printInvDelta(int[][] nArray, int[] nArray2) {
        Out.dump("Inverse of transition table: ");
        for (int i = 0; i < this.numStates + 1; ++i) {
            Out.dump("State [" + (i - 1) + "]");
            for (int j = 0; j < this.numInput; ++j) {
                String string = "With <" + j + "> in {";
                int n = nArray[i][j];
                while (nArray2[n] != -1) {
                    string = string + (nArray2[n++] - 1);
                    if (nArray2[n] == -1) continue;
                    string = string + ",";
                }
                if (nArray2[nArray[i][j]] == -1) continue;
                Out.dump(string + "}");
            }
        }
    }

    public void printTable(boolean[][] blArray) {
        Out.dump("Equivalence table is : ");
        for (int i = 1; i < this.numStates; ++i) {
            String string = i + " :";
            for (int j = 0; j < i; ++j) {
                string = blArray[i][j] ? string + " E" : string + " x";
            }
            Out.dump(string);
        }
    }
}

