/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.util.StringTokenizer;
import weka.core.Utils;

public class Stats
implements Serializable {
    public double count = 0.0;
    public double sum = 0.0;
    public double sumSq = 0.0;
    public double stdDev = Double.NaN;
    public double mean = Double.NaN;
    public double min = Double.NaN;
    public double max = Double.NaN;

    public void add(double d) {
        this.add(d, 1.0);
    }

    public void add(double d, double d2) {
        this.sum += d * d2;
        this.sumSq += d * d * d2;
        this.count += d2;
        if (Double.isNaN(this.min)) {
            this.min = this.max = d;
        } else if (d < this.min) {
            this.min = d;
        } else if (d > this.max) {
            this.max = d;
        }
    }

    public void subtract(double d) {
        this.subtract(d, 1.0);
    }

    public void subtract(double d, double d2) {
        this.sum -= d * d2;
        this.sumSq -= d * d * d2;
        this.count -= d2;
    }

    public void calculateDerived() {
        this.mean = Double.NaN;
        this.stdDev = Double.NaN;
        if (this.count > 0.0) {
            this.mean = this.sum / this.count;
            this.stdDev = Double.POSITIVE_INFINITY;
            if (this.count > 1.0) {
                this.stdDev = this.sumSq - this.sum * this.sum / this.count;
                this.stdDev /= this.count - 1.0;
                if (this.stdDev < 0.0) {
                    this.stdDev = 0.0;
                }
                this.stdDev = Math.sqrt(this.stdDev);
            }
        }
    }

    public String toString() {
        this.calculateDerived();
        return "Count   " + Utils.doubleToString(this.count, 8) + '\n' + "Min     " + Utils.doubleToString(this.min, 8) + '\n' + "Max     " + Utils.doubleToString(this.max, 8) + '\n' + "Sum     " + Utils.doubleToString(this.sum, 8) + '\n' + "SumSq   " + Utils.doubleToString(this.sumSq, 8) + '\n' + "Mean    " + Utils.doubleToString(this.mean, 8) + '\n' + "StdDev  " + Utils.doubleToString(this.stdDev, 8) + '\n';
    }

    public static void main(String[] stringArray) {
        try {
            String string;
            Stats stats = new Stats();
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(System.in));
            while ((string = lineNumberReader.readLine()) != null) {
                if ((string = string.trim()).equals("") || string.startsWith("@") || string.startsWith("%")) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ,\t\n\r\f");
                int n = 0;
                double d = 0.0;
                while (stringTokenizer.hasMoreTokens()) {
                    double d2 = new Double(stringTokenizer.nextToken());
                    if (n != 0) {
                        System.err.println("MSG: Too many values in line \"" + string + "\", skipped.");
                        break;
                    }
                    d = d2;
                    ++n;
                }
                if (n != true) continue;
                stats.add(d);
            }
            stats.calculateDerived();
            System.err.println(stats);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

