/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.RandomizableMultipleClassifiersCombiner;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;

public class MultiScheme
extends RandomizableMultipleClassifiersCombiner {
    static final long serialVersionUID = 5710744346128957520L;
    protected Classifier m_Classifier;
    protected int m_ClassifierIndex;
    protected int m_NumXValFolds;

    public String globalInfo() {
        return "Class for selecting a classifier from among several using cross validation on the training data or the performance on the training data. Performance is measured based on percent correct (classification) or mean-squared error (regression).";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(1);
        vector.addElement(new Option("\tUse cross validation for model selection using the\n\tgiven number of folds. (default 0, is to\n\tuse training error)", "X", 1, "-X <number of folds>"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('X', stringArray);
        if (string.length() != 0) {
            this.setNumFolds(Integer.parseInt(string));
        } else {
            this.setNumFolds(0);
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        String[] stringArray2 = new String[stringArray.length + 2];
        int n = 0;
        stringArray2[n++] = "-X";
        stringArray2[n++] = "" + this.getNumFolds();
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        return stringArray2;
    }

    public String classifiersTipText() {
        return "The classifiers to be chosen from.";
    }

    public void setClassifiers(Classifier[] classifierArray) {
        this.m_Classifiers = classifierArray;
    }

    public Classifier[] getClassifiers() {
        return this.m_Classifiers;
    }

    public Classifier getClassifier(int n) {
        return this.m_Classifiers[n];
    }

    protected String getClassifierSpec(int n) {
        if (this.m_Classifiers.length < n) {
            return "";
        }
        Classifier classifier = this.getClassifier(n);
        if (classifier instanceof OptionHandler) {
            return classifier.getClass().getName() + " " + Utils.joinOptions(classifier.getOptions());
        }
        return classifier.getClass().getName();
    }

    public String seedTipText() {
        return "The seed used for randomizing the data for cross-validation.";
    }

    public void setSeed(int n) {
        this.m_Seed = n;
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public String numFoldsTipText() {
        return "The number of folds used for cross-validation (if 0, performance on training data will be used).";
    }

    public int getNumFolds() {
        return this.m_NumXValFolds;
    }

    public void setNumFolds(int n) {
        this.m_NumXValFolds = n;
    }

    public String debugTipText() {
        return "Whether debug information is output to console.";
    }

    public void setDebug(boolean bl) {
        this.m_Debug = bl;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public void buildClassifier(Instances instances) throws Exception {
        if (this.m_Classifiers.length == 0) {
            throw new Exception("No base classifiers have been set!");
        }
        this.getCapabilities().testWithFail(instances);
        Instances instances2 = new Instances(instances);
        instances2.deleteWithMissingClass();
        Random random = new Random(this.m_Seed);
        instances2.randomize(random);
        if (instances2.classAttribute().isNominal() && this.m_NumXValFolds > 1) {
            instances2.stratify(this.m_NumXValFolds);
        }
        Instances instances3 = instances2;
        Instances instances4 = instances2;
        Classifier classifier = null;
        int n = -1;
        double d = Double.NaN;
        int n2 = this.m_Classifiers.length;
        for (int i = 0; i < n2; ++i) {
            Evaluation evaluation;
            Classifier classifier2 = this.getClassifier(i);
            if (this.m_NumXValFolds > 1) {
                evaluation = new Evaluation(instances2);
                for (int j = 0; j < this.m_NumXValFolds; ++j) {
                    instances3 = instances2.trainCV(this.m_NumXValFolds, j, new Random(1L));
                    instances4 = instances2.testCV(this.m_NumXValFolds, j);
                    classifier2.buildClassifier(instances3);
                    evaluation.setPriors(instances3);
                    evaluation.evaluateModel(classifier2, instances4);
                }
            } else {
                classifier2.buildClassifier(instances3);
                evaluation = new Evaluation(instances3);
                evaluation.evaluateModel(classifier2, instances4);
            }
            double d2 = evaluation.errorRate();
            if (this.m_Debug) {
                System.err.println("Error rate: " + Utils.doubleToString(d2, 6, 4) + " for classifier " + classifier2.getClass().getName());
            }
            if (i != 0 && !(d2 < d)) continue;
            classifier = classifier2;
            d = d2;
            n = i;
        }
        this.m_ClassifierIndex = n;
        if (this.m_NumXValFolds > 1) {
            classifier.buildClassifier(instances2);
        }
        this.m_Classifier = classifier;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        return this.m_Classifier.distributionForInstance(instance);
    }

    public String toString() {
        if (this.m_Classifier == null) {
            return "MultiScheme: No model built yet.";
        }
        String string = "MultiScheme selection using";
        string = this.m_NumXValFolds > 1 ? string + " cross validation error" : string + " error on training data";
        string = string + " from the following:\n";
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            string = string + '\t' + this.getClassifierSpec(i) + '\n';
        }
        string = string + "Selected scheme: " + this.getClassifierSpec(this.m_ClassifierIndex) + "\n\n" + this.m_Classifier.toString();
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new MultiScheme(), stringArray));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

