/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Utils;

public abstract class ResultMatrix
implements Serializable {
    public static final int SIGNIFICANCE_TIE = 0;
    public static final int SIGNIFICANCE_WIN = 1;
    public static final int SIGNIFICANCE_LOSS = 2;
    public String TIE_STRING = " ";
    public String WIN_STRING = "v";
    public String LOSS_STRING = "*";
    public String LEFT_PARENTHESES = "(";
    public String RIGHT_PARENTHESES = ")";
    protected String[] m_ColNames = null;
    protected String[] m_RowNames = null;
    protected boolean[] m_ColHidden = null;
    protected boolean[] m_RowHidden = null;
    protected int[][] m_Significance = null;
    protected double[][] m_Mean = null;
    protected double[][] m_StdDev = null;
    protected double[] m_Counts = null;
    protected int m_MeanPrec;
    protected int m_StdDevPrec;
    protected boolean m_ShowStdDev;
    protected boolean m_ShowAverage;
    protected boolean m_PrintColNames;
    protected boolean m_PrintRowNames;
    protected boolean m_EnumerateColNames;
    protected boolean m_EnumerateRowNames;
    protected int m_ColNameWidth;
    protected int m_RowNameWidth;
    protected int m_MeanWidth;
    protected int m_StdDevWidth;
    protected int m_SignificanceWidth;
    protected int m_CountWidth;
    protected Vector m_HeaderKeys = null;
    protected Vector m_HeaderValues = null;
    protected int[][] m_NonSigWins = null;
    protected int[][] m_Wins = null;
    protected int[] m_RankingWins = null;
    protected int[] m_RankingLosses = null;
    protected int[] m_RankingDiff = null;
    protected int[] m_RowOrder = null;
    protected int[] m_ColOrder = null;
    protected boolean m_RemoveFilterName = false;

    public ResultMatrix() {
        this(1, 1);
    }

    public ResultMatrix(int n, int n2) {
        this.setSize(n, n2);
        this.clear();
    }

    public ResultMatrix(ResultMatrix resultMatrix) {
        this.assign(resultMatrix);
    }

    public abstract String getDisplayName();

    public void assign(ResultMatrix resultMatrix) {
        int n;
        int n2;
        this.setSize(resultMatrix.getColCount(), resultMatrix.getRowCount());
        this.TIE_STRING = resultMatrix.TIE_STRING;
        this.WIN_STRING = resultMatrix.WIN_STRING;
        this.LOSS_STRING = resultMatrix.LOSS_STRING;
        this.LEFT_PARENTHESES = resultMatrix.LEFT_PARENTHESES;
        this.RIGHT_PARENTHESES = resultMatrix.RIGHT_PARENTHESES;
        this.m_MeanPrec = resultMatrix.m_MeanPrec;
        this.m_StdDevPrec = resultMatrix.m_StdDevPrec;
        this.m_ShowStdDev = resultMatrix.m_ShowStdDev;
        this.m_ShowAverage = resultMatrix.m_ShowAverage;
        this.m_PrintColNames = resultMatrix.m_PrintColNames;
        this.m_PrintRowNames = resultMatrix.m_PrintRowNames;
        this.m_EnumerateColNames = resultMatrix.m_EnumerateColNames;
        this.m_EnumerateRowNames = resultMatrix.m_EnumerateRowNames;
        this.m_RowNameWidth = resultMatrix.m_RowNameWidth;
        this.m_MeanWidth = resultMatrix.m_MeanWidth;
        this.m_StdDevWidth = resultMatrix.m_StdDevWidth;
        this.m_SignificanceWidth = resultMatrix.m_SignificanceWidth;
        this.m_CountWidth = resultMatrix.m_CountWidth;
        this.m_RemoveFilterName = resultMatrix.m_RemoveFilterName;
        this.m_HeaderKeys = (Vector)resultMatrix.m_HeaderKeys.clone();
        this.m_HeaderValues = (Vector)resultMatrix.m_HeaderValues.clone();
        for (n2 = 0; n2 < resultMatrix.m_Mean.length; ++n2) {
            for (n = 0; n < resultMatrix.m_Mean[n2].length; ++n) {
                this.m_Mean[n2][n] = resultMatrix.m_Mean[n2][n];
                this.m_StdDev[n2][n] = resultMatrix.m_StdDev[n2][n];
                this.m_Significance[n2][n] = resultMatrix.m_Significance[n2][n];
            }
        }
        for (n2 = 0; n2 < resultMatrix.m_ColNames.length; ++n2) {
            this.m_ColNames[n2] = resultMatrix.m_ColNames[n2];
            this.m_ColHidden[n2] = resultMatrix.m_ColHidden[n2];
        }
        for (n2 = 0; n2 < resultMatrix.m_RowNames.length; ++n2) {
            this.m_RowNames[n2] = resultMatrix.m_RowNames[n2];
            this.m_RowHidden[n2] = resultMatrix.m_RowHidden[n2];
        }
        for (n2 = 0; n2 < resultMatrix.m_Counts.length; ++n2) {
            this.m_Counts[n2] = resultMatrix.m_Counts[n2];
        }
        if (resultMatrix.m_NonSigWins != null) {
            this.m_NonSigWins = new int[resultMatrix.m_NonSigWins.length][];
            this.m_Wins = new int[resultMatrix.m_NonSigWins.length][];
            for (n2 = 0; n2 < resultMatrix.m_NonSigWins.length; ++n2) {
                this.m_NonSigWins[n2] = new int[resultMatrix.m_NonSigWins[n2].length];
                this.m_Wins[n2] = new int[resultMatrix.m_NonSigWins[n2].length];
                for (n = 0; n < resultMatrix.m_NonSigWins[n2].length; ++n) {
                    this.m_NonSigWins[n2][n] = resultMatrix.m_NonSigWins[n2][n];
                    this.m_Wins[n2][n] = resultMatrix.m_Wins[n2][n];
                }
            }
        }
        if (resultMatrix.m_RankingWins != null) {
            this.m_RankingWins = new int[resultMatrix.m_RankingWins.length];
            this.m_RankingLosses = new int[resultMatrix.m_RankingWins.length];
            this.m_RankingDiff = new int[resultMatrix.m_RankingWins.length];
            for (n2 = 0; n2 < resultMatrix.m_RankingWins.length; ++n2) {
                this.m_RankingWins[n2] = resultMatrix.m_RankingWins[n2];
                this.m_RankingLosses[n2] = resultMatrix.m_RankingLosses[n2];
                this.m_RankingDiff[n2] = resultMatrix.m_RankingDiff[n2];
            }
        }
    }

    public void clear() {
        this.m_MeanPrec = 2;
        this.m_StdDevPrec = 2;
        this.m_ShowStdDev = false;
        this.m_ShowAverage = false;
        this.m_PrintColNames = true;
        this.m_PrintRowNames = true;
        this.m_EnumerateColNames = true;
        this.m_EnumerateRowNames = false;
        this.m_RowNameWidth = 0;
        this.m_ColNameWidth = 0;
        this.m_MeanWidth = 0;
        this.m_StdDevWidth = 0;
        this.m_SignificanceWidth = 0;
        this.m_CountWidth = 0;
        this.setSize(this.getColCount(), this.getRowCount());
    }

    public void setSize(int n, int n2) {
        int n3;
        this.m_ColNames = new String[n];
        this.m_RowNames = new String[n2];
        this.m_Counts = new double[n2];
        this.m_ColHidden = new boolean[n];
        this.m_RowHidden = new boolean[n2];
        this.m_Mean = new double[n2][n];
        this.m_Significance = new int[n2][n];
        this.m_StdDev = new double[n2][n];
        this.m_ColOrder = null;
        this.m_RowOrder = null;
        for (n3 = 0; n3 < this.m_Mean.length; ++n3) {
            for (int i = 0; i < this.m_Mean[n3].length; ++i) {
                this.m_Mean[n3][i] = Double.NaN;
            }
        }
        for (n3 = 0; n3 < this.m_ColNames.length; ++n3) {
            this.m_ColNames[n3] = "col" + n3;
        }
        for (n3 = 0; n3 < this.m_RowNames.length; ++n3) {
            this.m_RowNames[n3] = "row" + n3;
        }
        this.clearHeader();
        this.clearSummary();
        this.clearRanking();
    }

    public void setMeanPrec(int n) {
        if (n >= 0) {
            this.m_MeanPrec = n;
        }
    }

    public int getMeanPrec() {
        return this.m_MeanPrec;
    }

    public void setStdDevPrec(int n) {
        if (n >= 0) {
            this.m_StdDevPrec = n;
        }
    }

    public int getStdDevPrec() {
        return this.m_StdDevPrec;
    }

    public void setColNameWidth(int n) {
        if (n >= 0) {
            this.m_ColNameWidth = n;
        }
    }

    public int getColNameWidth() {
        return this.m_ColNameWidth;
    }

    public void setRowNameWidth(int n) {
        if (n >= 0) {
            this.m_RowNameWidth = n;
        }
    }

    public int getRowNameWidth() {
        return this.m_RowNameWidth;
    }

    public void setMeanWidth(int n) {
        if (n >= 0) {
            this.m_MeanWidth = n;
        }
    }

    public int getMeanWidth() {
        return this.m_MeanWidth;
    }

    public void setStdDevWidth(int n) {
        if (n >= 0) {
            this.m_StdDevWidth = n;
        }
    }

    public int getStdDevWidth() {
        return this.m_StdDevWidth;
    }

    public void setSignificanceWidth(int n) {
        if (n >= 0) {
            this.m_SignificanceWidth = n;
        }
    }

    public int getSignificanceWidth() {
        return this.m_SignificanceWidth;
    }

    public void setCountWidth(int n) {
        if (n >= 0) {
            this.m_CountWidth = n;
        }
    }

    public int getCountWidth() {
        return this.m_CountWidth;
    }

    public void setShowStdDev(boolean bl) {
        this.m_ShowStdDev = bl;
    }

    public boolean getShowStdDev() {
        return this.m_ShowStdDev;
    }

    public void setShowAverage(boolean bl) {
        this.m_ShowAverage = bl;
    }

    public boolean getShowAverage() {
        return this.m_ShowAverage;
    }

    public void setRemoveFilterName(boolean bl) {
        this.m_RemoveFilterName = bl;
    }

    public boolean getRemoveFilterName() {
        return this.m_RemoveFilterName;
    }

    public void setPrintColNames(boolean bl) {
        this.m_PrintColNames = bl;
        if (!bl) {
            this.setEnumerateColNames(true);
        }
    }

    public boolean getPrintColNames() {
        return this.m_PrintColNames;
    }

    public void setPrintRowNames(boolean bl) {
        this.m_PrintRowNames = bl;
        if (!bl) {
            this.setEnumerateRowNames(true);
        }
    }

    public boolean getPrintRowNames() {
        return this.m_PrintRowNames;
    }

    public void setEnumerateColNames(boolean bl) {
        this.m_EnumerateColNames = bl;
    }

    public boolean getEnumerateColNames() {
        return this.m_EnumerateColNames;
    }

    public void setEnumerateRowNames(boolean bl) {
        this.m_EnumerateRowNames = bl;
    }

    public boolean getEnumerateRowNames() {
        return this.m_EnumerateRowNames;
    }

    public int getColCount() {
        return this.m_ColNames.length;
    }

    public int getVisibleColCount() {
        int n = 0;
        for (int i = 0; i < this.getColCount(); ++i) {
            if (this.getColHidden(i)) continue;
            ++n;
        }
        return n;
    }

    public int getRowCount() {
        return this.m_RowNames.length;
    }

    public int getVisibleRowCount() {
        int n = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getRowHidden(i)) continue;
            ++n;
        }
        return n;
    }

    public void setColName(int n, String string) {
        if (n >= 0 && n < this.getColCount()) {
            this.m_ColNames[n] = string;
        }
    }

    public String getColName(int n) {
        String string = null;
        if (n >= 0 && n < this.getColCount()) {
            string = this.getPrintColNames() ? this.m_ColNames[n] : "";
            if (this.getEnumerateColNames()) {
                string = this.LEFT_PARENTHESES + Integer.toString(n + 1) + this.RIGHT_PARENTHESES + " " + string;
                string = string.trim();
            }
        }
        return string;
    }

    public void setRowName(int n, String string) {
        if (n >= 0 && n < this.getRowCount()) {
            this.m_RowNames[n] = string;
        }
    }

    public String getRowName(int n) {
        String string = null;
        if (n >= 0 && n < this.getRowCount()) {
            string = this.getPrintRowNames() ? this.m_RowNames[n] : "";
            if (this.getEnumerateRowNames()) {
                string = this.LEFT_PARENTHESES + Integer.toString(n + 1) + this.RIGHT_PARENTHESES + " " + string;
                string = string.trim();
            }
        }
        return string;
    }

    public void setColHidden(int n, boolean bl) {
        if (n >= 0 && n < this.getColCount()) {
            this.m_ColHidden[n] = bl;
        }
    }

    public boolean getColHidden(int n) {
        if (n >= 0 && n < this.getColCount()) {
            return this.m_ColHidden[n];
        }
        return false;
    }

    public void setRowHidden(int n, boolean bl) {
        if (n >= 0 && n < this.getRowCount()) {
            this.m_RowHidden[n] = bl;
        }
    }

    public boolean getRowHidden(int n) {
        if (n >= 0 && n < this.getRowCount()) {
            return this.m_RowHidden[n];
        }
        return false;
    }

    public void setCount(int n, double d) {
        if (n >= 0 && n < this.getRowCount()) {
            this.m_Counts[n] = d;
        }
    }

    public double getCount(int n) {
        if (n >= 0 && n < this.getRowCount()) {
            return this.m_Counts[n];
        }
        return 0.0;
    }

    public void setMean(int n, int n2, double d) {
        if (n >= 0 && n < this.getColCount() && n2 >= 0 && n2 < this.getRowCount()) {
            this.m_Mean[n2][n] = d;
        }
    }

    public double getMean(int n, int n2) {
        if (n >= 0 && n < this.getColCount() && n2 >= 0 && n2 < this.getRowCount()) {
            return this.m_Mean[n2][n];
        }
        return 0.0;
    }

    public double getAverage(int n) {
        if (n >= 0 && n < this.getColCount()) {
            double d = 0.0;
            int n2 = 0;
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (Double.isNaN(this.getMean(n, i))) continue;
                d += this.getMean(n, i);
                ++n2;
            }
            return d / (double)n2;
        }
        return 0.0;
    }

    public void setStdDev(int n, int n2, double d) {
        if (n >= 0 && n < this.getColCount() && n2 >= 0 && n2 < this.getRowCount()) {
            this.m_StdDev[n2][n] = d;
        }
    }

    public double getStdDev(int n, int n2) {
        if (n >= 0 && n < this.getColCount() && n2 >= 0 && n2 < this.getRowCount()) {
            return this.m_StdDev[n2][n];
        }
        return 0.0;
    }

    public void setSignificance(int n, int n2, int n3) {
        if (n >= 0 && n < this.getColCount() && n2 >= 0 && n2 < this.getRowCount()) {
            this.m_Significance[n2][n] = n3;
        }
    }

    public int getSignificance(int n, int n2) {
        if (n >= 0 && n < this.getColCount() && n2 >= 0 && n2 < this.getRowCount()) {
            return this.m_Significance[n2][n];
        }
        return 0;
    }

    public int getSignificanceCount(int n, int n2) {
        int n3 = 0;
        if (n >= 0 && n < this.getColCount()) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getRowHidden(i) || Double.isNaN(this.getMean(n, i)) || this.getSignificance(n, i) != n2) continue;
                ++n3;
            }
        }
        return n3;
    }

    public void setRowOrder(int[] nArray) {
        if (nArray == null) {
            this.m_RowOrder = null;
        } else if (nArray.length == this.getRowCount()) {
            this.m_RowOrder = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                this.m_RowOrder[i] = nArray[i];
            }
        } else {
            System.err.println("setRowOrder: length does not match (" + nArray.length + " <> " + this.getRowCount() + ") - ignored!");
        }
    }

    public int[] getRowOrder() {
        return this.m_RowOrder;
    }

    public int getDisplayRow(int n) {
        if (n >= 0 && n < this.getRowCount()) {
            if (this.getRowOrder() == null) {
                return n;
            }
            return this.getRowOrder()[n];
        }
        return -1;
    }

    public void setColOrder(int[] nArray) {
        if (nArray == null) {
            this.m_ColOrder = null;
        } else if (nArray.length == this.getColCount()) {
            this.m_ColOrder = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                this.m_ColOrder[i] = nArray[i];
            }
        } else {
            System.err.println("setColOrder: length does not match (" + nArray.length + " <> " + this.getColCount() + ") - ignored!");
        }
    }

    public int[] getColOrder() {
        return this.m_ColOrder;
    }

    public int getDisplayCol(int n) {
        if (n >= 0 && n < this.getColCount()) {
            if (this.getColOrder() == null) {
                return n;
            }
            return this.getColOrder()[n];
        }
        return -1;
    }

    protected String doubleToString(double d, int n) {
        int n2;
        String string = Utils.doubleToString(d, n);
        if (string.indexOf(".") == -1) {
            string = string + ".";
        }
        for (int i = n2 = string.length() - string.indexOf(".") - 1; i < n; ++i) {
            string = string + "0";
        }
        return string;
    }

    protected String trimString(String string, int n) {
        if (n > 0 && string.length() > n) {
            return string.substring(0, n);
        }
        return string;
    }

    protected String padString(String string, int n) {
        return this.padString(string, n, false);
    }

    protected String padString(String string, int n, boolean bl) {
        String string2 = string;
        for (int i = string.length(); i < n; ++i) {
            string2 = bl ? " " + string2 : string2 + " ";
        }
        if (n > 0 && string2.length() > n) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    protected int getColSize(String[][] stringArray, int n) {
        return this.getColSize(stringArray, n, false, false);
    }

    protected int getColSize(String[][] stringArray, int n, boolean bl, boolean bl2) {
        int n2 = 0;
        if (n >= 0 && n < stringArray[0].length) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (i == 0 && bl || i == stringArray.length - 1 && bl2 || stringArray[i][n].length() <= n2) continue;
                n2 = stringArray[i][n].length();
            }
        }
        return n2;
    }

    protected String removeFilterName(String string) {
        if (this.getRemoveFilterName()) {
            return string.replaceAll("-weka\\.filters\\..*", "").replaceAll("-unsupervised\\..*", "").replaceAll("-supervised\\..*", "");
        }
        return string;
    }

    protected String[][] toArray() {
        int n;
        int n2;
        int n3;
        int n4 = this.getVisibleRowCount();
        if (this.getShowAverage()) {
            ++n4;
        }
        int n5 = this.getVisibleColCount();
        n5 = this.getShowStdDev() ? (n5 *= 3) : (n5 *= 2);
        String[][] stringArray = new String[n4 + 2][n5 + 1];
        stringArray[0][0] = this.trimString("Dataset", this.getRowNameWidth());
        int n6 = 1;
        for (n3 = 0; n3 < this.getColCount(); ++n3) {
            n2 = this.getDisplayCol(n3);
            if (this.getColHidden(n2)) continue;
            stringArray[0][n6] = this.trimString(this.removeFilterName(this.getColName(n2)), this.getColNameWidth());
            ++n6;
            if (this.getShowStdDev()) {
                stringArray[0][n6] = "";
                ++n6;
            }
            stringArray[0][n6] = "";
            ++n6;
        }
        int n7 = 1;
        for (n3 = 0; n3 < this.getRowCount(); ++n3) {
            n2 = this.getDisplayRow(n3);
            if (this.getRowHidden(n2)) continue;
            stringArray[n7][0] = this.trimString(this.removeFilterName(this.getRowName(n2)), this.getRowNameWidth());
            ++n7;
        }
        n7 = 1;
        for (n3 = 0; n3 < this.getRowCount(); ++n3) {
            n2 = this.getDisplayRow(n3);
            if (this.getRowHidden(n2)) continue;
            n6 = 1;
            for (int i = 0; i < this.getColCount(); ++i) {
                n = this.getDisplayCol(i);
                if (this.getColHidden(n)) continue;
                boolean bl = !Double.isNaN(this.getMean(n, n2));
                stringArray[n7][n6] = !bl ? "" : this.doubleToString(this.getMean(n, n2), this.getMeanPrec());
                ++n6;
                if (this.getShowStdDev()) {
                    stringArray[n7][n6] = !bl ? "" : (Double.isInfinite(this.getStdDev(n, n2)) ? "Inf" : this.doubleToString(this.getStdDev(n, n2), this.getStdDevPrec()));
                    ++n6;
                }
                if (!bl) {
                    stringArray[n7][n6] = "";
                } else {
                    switch (this.getSignificance(n, n2)) {
                        case 0: {
                            stringArray[n7][n6] = this.TIE_STRING;
                            break;
                        }
                        case 1: {
                            stringArray[n7][n6] = this.WIN_STRING;
                            break;
                        }
                        case 2: {
                            stringArray[n7][n6] = this.LOSS_STRING;
                        }
                    }
                }
                ++n6;
            }
            ++n7;
        }
        if (this.getShowAverage()) {
            n7 = stringArray.length - 2;
            n6 = 0;
            stringArray[n7][0] = "Average";
            ++n6;
            for (n3 = 0; n3 < this.getColCount(); ++n3) {
                n2 = this.getDisplayCol(n3);
                if (this.getColHidden(n2)) continue;
                stringArray[n7][n6] = this.doubleToString(this.getAverage(n2), this.getMeanPrec());
                ++n6;
                if (this.getShowStdDev()) {
                    stringArray[n7][n6] = "";
                    ++n6;
                }
                stringArray[n7][n6] = "";
                ++n6;
            }
        }
        n7 = stringArray.length - 1;
        n6 = 0;
        stringArray[n7][0] = this.LEFT_PARENTHESES + this.WIN_STRING + "/" + this.TIE_STRING + "/" + this.LOSS_STRING + this.RIGHT_PARENTHESES;
        ++n6;
        for (n3 = 0; n3 < this.getColCount(); ++n3) {
            n2 = this.getDisplayCol(n3);
            if (this.getColHidden(n2)) continue;
            stringArray[n7][n6] = "";
            ++n6;
            if (this.getShowStdDev()) {
                stringArray[n7][n6] = "";
                ++n6;
            }
            stringArray[n7][n6] = this.LEFT_PARENTHESES + this.getSignificanceCount(n2, 1) + "/" + this.getSignificanceCount(n2, 0) + "/" + this.getSignificanceCount(n2, 2) + this.RIGHT_PARENTHESES;
            ++n6;
        }
        String[][] stringArray2 = new String[stringArray.length][stringArray[0].length - 1];
        n6 = 0;
        for (n2 = 0; n2 < stringArray[0].length; ++n2) {
            if (n2 == 3 && this.getShowStdDev() || n2 == 2 && !this.getShowStdDev()) continue;
            for (n = 0; n < stringArray.length; ++n) {
                stringArray2[n][n6] = stringArray[n][n2];
            }
            ++n6;
        }
        stringArray = stringArray2;
        return stringArray;
    }

    protected boolean isRowName(int n) {
        return n == 0;
    }

    protected boolean isMean(int n) {
        if (--n == 0) {
            return true;
        }
        if (--n < 0) {
            return false;
        }
        if (this.getShowStdDev()) {
            return n % 3 == 1;
        }
        return n % 2 == 0;
    }

    protected boolean isAverage(int n) {
        if (this.getShowAverage()) {
            return this.getVisibleRowCount() + 1 == n;
        }
        return false;
    }

    protected boolean isStdDev(int n) {
        --n;
        --n;
        if (this.getShowStdDev()) {
            if (n == 0) {
                return true;
            }
            if (--n < 0) {
                return false;
            }
            return n % 3 == 1;
        }
        return false;
    }

    protected boolean isSignificance(int n) {
        --n;
        --n;
        if (this.getShowStdDev()) {
            if (--n < 0) {
                return false;
            }
            return n % 3 == 2;
        }
        if (n < 0) {
            return false;
        }
        return n % 2 == 1;
    }

    public abstract String toStringMatrix();

    public String toString() {
        return this.toStringMatrix();
    }

    public void clearHeader() {
        this.m_HeaderKeys = new Vector();
        this.m_HeaderValues = new Vector();
    }

    public void addHeader(String string, String string2) {
        int n = this.m_HeaderKeys.indexOf(string);
        if (n > -1) {
            this.m_HeaderValues.set(n, string2);
        } else {
            this.m_HeaderKeys.add(string);
            this.m_HeaderValues.add(string2);
        }
    }

    public String getHeader(String string) {
        int n = this.m_HeaderKeys.indexOf(string);
        if (n == 0) {
            return null;
        }
        return (String)this.m_HeaderKeys.get(n);
    }

    public Enumeration headerKeys() {
        return this.m_HeaderKeys.elements();
    }

    public abstract String toStringHeader();

    public abstract String toStringKey();

    public void clearSummary() {
        this.m_NonSigWins = null;
        this.m_Wins = null;
    }

    public void setSummary(int[][] nArray, int[][] nArray2) {
        this.m_NonSigWins = new int[nArray.length][nArray[0].length];
        this.m_Wins = new int[nArray2.length][nArray2[0].length];
        for (int i = 0; i < this.m_NonSigWins.length; ++i) {
            for (int j = 0; j < this.m_NonSigWins[i].length; ++j) {
                this.m_NonSigWins[i][j] = nArray[i][j];
                this.m_Wins[i][j] = nArray2[i][j];
            }
        }
    }

    protected String getSummaryTitle(int n) {
        return "" + (char)(97 + n % 26);
    }

    public abstract String toStringSummary();

    public void clearRanking() {
        this.m_RankingWins = null;
        this.m_RankingLosses = null;
        this.m_RankingDiff = null;
    }

    public void setRanking(int[][] nArray) {
        this.m_RankingWins = new int[nArray.length];
        this.m_RankingLosses = new int[nArray.length];
        this.m_RankingDiff = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                int n = j;
                this.m_RankingWins[n] = this.m_RankingWins[n] + nArray[i][j];
                int n2 = j;
                this.m_RankingDiff[n2] = this.m_RankingDiff[n2] + nArray[i][j];
                int n3 = i;
                this.m_RankingLosses[n3] = this.m_RankingLosses[n3] + nArray[i][j];
                int n4 = i;
                this.m_RankingDiff[n4] = this.m_RankingDiff[n4] - nArray[i][j];
            }
        }
    }

    public abstract String toStringRanking();
}

