/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.Naming;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import weka.core.FastVector;
import weka.core.Option;
import weka.core.Queue;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.core.xml.KOML;
import weka.core.xml.XMLOptions;
import weka.core.xml.XMLSerialization;
import weka.experiment.Compute;
import weka.experiment.Experiment;
import weka.experiment.PropertyNode;
import weka.experiment.RemoteExperimentEvent;
import weka.experiment.RemoteExperimentListener;
import weka.experiment.RemoteExperimentSubTask;
import weka.experiment.ResultListener;
import weka.experiment.ResultProducer;
import weka.experiment.TaskStatusInfo;
import weka.experiment.xml.XMLExperiment;

public class RemoteExperiment
extends Experiment {
    private FastVector m_listeners = new FastVector();
    protected DefaultListModel m_remoteHosts = new DefaultListModel();
    private Queue m_remoteHostsQueue = new Queue();
    private int[] m_remoteHostsStatus;
    private int[] m_remoteHostFailureCounts;
    protected static final int AVAILABLE = 0;
    protected static final int IN_USE = 1;
    protected static final int CONNECTION_FAILED = 2;
    protected static final int SOME_OTHER_FAILURE = 3;
    protected static final int MAX_FAILURES = 3;
    private boolean m_experimentAborted = false;
    private int m_removedHosts;
    private int m_failedCount;
    private int m_finishedCount;
    private Experiment m_baseExperiment = null;
    protected Experiment[] m_subExperiments;
    private Queue m_subExpQueue = new Queue();
    protected int[] m_subExpComplete;
    protected boolean m_splitByDataSet = true;

    public boolean getSplitByDataSet() {
        return this.m_splitByDataSet;
    }

    public void setSplitByDataSet(boolean bl) {
        this.m_splitByDataSet = bl;
    }

    public RemoteExperiment() throws Exception {
        this(new Experiment());
    }

    public RemoteExperiment(Experiment experiment) throws Exception {
        this.setBaseExperiment(experiment);
    }

    public void addRemoteExperimentListener(RemoteExperimentListener remoteExperimentListener) {
        this.m_listeners.addElement(remoteExperimentListener);
    }

    public Experiment getBaseExperiment() {
        return this.m_baseExperiment;
    }

    public void setBaseExperiment(Experiment experiment) throws Exception {
        if (experiment == null) {
            throw new Exception("Base experiment is null!");
        }
        this.m_baseExperiment = experiment;
        this.setRunLower(this.m_baseExperiment.getRunLower());
        this.setRunUpper(this.m_baseExperiment.getRunUpper());
        this.setResultListener(this.m_baseExperiment.getResultListener());
        this.setResultProducer(this.m_baseExperiment.getResultProducer());
        this.setDatasets(this.m_baseExperiment.getDatasets());
        this.setUsePropertyIterator(this.m_baseExperiment.getUsePropertyIterator());
        this.setPropertyPath(this.m_baseExperiment.getPropertyPath());
        this.setPropertyArray(this.m_baseExperiment.getPropertyArray());
        this.setNotes(this.m_baseExperiment.getNotes());
        this.m_ClassFirst = this.m_baseExperiment.m_ClassFirst;
        this.m_AdvanceDataSetFirst = this.m_baseExperiment.m_AdvanceDataSetFirst;
    }

    public void setNotes(String string) {
        super.setNotes(string);
        this.m_baseExperiment.setNotes(string);
    }

    public void setRunLower(int n) {
        super.setRunLower(n);
        this.m_baseExperiment.setRunLower(n);
    }

    public void setRunUpper(int n) {
        super.setRunUpper(n);
        this.m_baseExperiment.setRunUpper(n);
    }

    public void setResultListener(ResultListener resultListener) {
        super.setResultListener(resultListener);
        this.m_baseExperiment.setResultListener(resultListener);
    }

    public void setResultProducer(ResultProducer resultProducer) {
        super.setResultProducer(resultProducer);
        this.m_baseExperiment.setResultProducer(resultProducer);
    }

    public void setDatasets(DefaultListModel defaultListModel) {
        super.setDatasets(defaultListModel);
        this.m_baseExperiment.setDatasets(defaultListModel);
    }

    public void setUsePropertyIterator(boolean bl) {
        super.setUsePropertyIterator(bl);
        this.m_baseExperiment.setUsePropertyIterator(bl);
    }

    public void setPropertyPath(PropertyNode[] propertyNodeArray) {
        super.setPropertyPath(propertyNodeArray);
        this.m_baseExperiment.setPropertyPath(propertyNodeArray);
    }

    public void setPropertyArray(Object object) {
        super.setPropertyArray(object);
        this.m_baseExperiment.setPropertyArray(object);
    }

    public void initialize() throws Exception {
        int n;
        if (this.m_baseExperiment == null) {
            throw new Exception("No base experiment specified!");
        }
        this.m_experimentAborted = false;
        this.m_finishedCount = 0;
        this.m_failedCount = 0;
        this.m_RunNumber = this.getRunLower();
        this.m_DatasetNumber = 0;
        this.m_PropertyNumber = 0;
        this.m_CurrentProperty = -1;
        this.m_CurrentInstances = null;
        this.m_Finished = false;
        if (this.m_remoteHosts.size() == 0) {
            throw new Exception("No hosts specified!");
        }
        this.m_remoteHostsStatus = new int[this.m_remoteHosts.size()];
        this.m_remoteHostFailureCounts = new int[this.m_remoteHosts.size()];
        this.m_remoteHostsQueue = new Queue();
        for (n = 0; n < this.m_remoteHosts.size(); ++n) {
            this.m_remoteHostsQueue.push(new Integer(n));
        }
        this.m_subExpQueue = new Queue();
        n = this.getSplitByDataSet() ? this.m_baseExperiment.getDatasets().size() : this.getRunUpper() - this.getRunLower() + 1;
        this.m_subExperiments = new Experiment[n];
        this.m_subExpComplete = new int[n];
        SerializedObject serializedObject = new SerializedObject(this.m_baseExperiment);
        if (this.getSplitByDataSet()) {
            for (int i = 0; i < this.m_baseExperiment.getDatasets().size(); ++i) {
                this.m_subExperiments[i] = (Experiment)serializedObject.getObject();
                DefaultListModel defaultListModel = new DefaultListModel();
                defaultListModel.addElement(this.m_baseExperiment.getDatasets().elementAt(i));
                this.m_subExperiments[i].setDatasets(defaultListModel);
                this.m_subExpQueue.push(new Integer(i));
            }
        } else {
            for (int i = this.getRunLower(); i <= this.getRunUpper(); ++i) {
                this.m_subExperiments[i - this.getRunLower()] = (Experiment)serializedObject.getObject();
                this.m_subExperiments[i - this.getRunLower()].setRunLower(i);
                this.m_subExperiments[i - this.getRunLower()].setRunUpper(i);
                this.m_subExpQueue.push(new Integer(i - this.getRunLower()));
            }
        }
    }

    private synchronized void notifyListeners(boolean bl, boolean bl2, boolean bl3, String string) {
        if (this.m_listeners.size() > 0) {
            for (int i = 0; i < this.m_listeners.size(); ++i) {
                RemoteExperimentListener remoteExperimentListener = (RemoteExperimentListener)this.m_listeners.elementAt(i);
                remoteExperimentListener.remoteExperimentStatus(new RemoteExperimentEvent(bl, bl2, bl3, string));
            }
        } else {
            System.err.println(string);
        }
    }

    public void abortExperiment() {
        this.m_experimentAborted = true;
    }

    protected synchronized void incrementFinished() {
        ++this.m_finishedCount;
    }

    protected synchronized void incrementFailed(int n) {
        ++this.m_failedCount;
        int n2 = n;
        this.m_remoteHostFailureCounts[n2] = this.m_remoteHostFailureCounts[n2] + 1;
    }

    protected synchronized void waitingExperiment(int n) {
        this.m_subExpQueue.push(new Integer(n));
    }

    private boolean checkForAllFailedHosts() {
        boolean bl = true;
        for (int i = 0; i < this.m_remoteHostsStatus.length; ++i) {
            if (this.m_remoteHostsStatus[i] == 2) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.abortExperiment();
            this.notifyListeners(false, true, true, "Experiment aborted! All connections to remote hosts failed.");
        }
        return bl;
    }

    private String postExperimentInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.m_finishedCount + (this.m_splitByDataSet ? " data sets" : " runs") + " completed successfully. " + this.m_failedCount + " failures during running.\n");
        System.err.print(stringBuffer.toString());
        return stringBuffer.toString();
    }

    protected synchronized void availableHost(int n) {
        if (n >= 0) {
            if (this.m_remoteHostFailureCounts[n] < 3) {
                this.m_remoteHostsQueue.push(new Integer(n));
            } else {
                this.notifyListeners(false, true, false, "Max failures exceeded for host " + (String)this.m_remoteHosts.elementAt(n) + ". Removed from host list.");
                ++this.m_removedHosts;
            }
        }
        if (this.m_failedCount == 3 * this.m_remoteHosts.size()) {
            this.abortExperiment();
            this.notifyListeners(false, true, true, "Experiment aborted! Max failures exceeded on all remote hosts.");
            return;
        }
        if (this.getSplitByDataSet() && this.m_baseExperiment.getDatasets().size() == this.m_finishedCount || !this.getSplitByDataSet() && this.getRunUpper() - this.getRunLower() + 1 == this.m_finishedCount) {
            this.notifyListeners(false, true, false, "Experiment completed successfully.");
            this.notifyListeners(false, true, true, this.postExperimentInfo());
            return;
        }
        if (this.checkForAllFailedHosts()) {
            return;
        }
        if (this.m_experimentAborted && this.m_remoteHostsQueue.size() + this.m_removedHosts == this.m_remoteHosts.size()) {
            this.notifyListeners(false, true, true, "Experiment aborted. All remote tasks finished.");
        }
        if (!(this.m_subExpQueue.empty() || this.m_experimentAborted || this.m_remoteHostsQueue.empty())) {
            try {
                int n2 = (Integer)this.m_remoteHostsQueue.pop();
                int n3 = (Integer)this.m_subExpQueue.pop();
                this.launchNext(n3, n2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void launchNext(final int n, final int n2) {
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ((RemoteExperiment)RemoteExperiment.this).m_remoteHostsStatus[n2] = 1;
                RemoteExperiment.this.m_subExpComplete[n] = 1;
                RemoteExperimentSubTask remoteExperimentSubTask = new RemoteExperimentSubTask();
                remoteExperimentSubTask.setExperiment(RemoteExperiment.this.m_subExperiments[n]);
                String string = RemoteExperiment.this.getSplitByDataSet() ? "dataset :" + ((File)RemoteExperiment.this.m_subExperiments[n].getDatasets().elementAt(0)).getName() : "run :" + RemoteExperiment.this.m_subExperiments[n].getRunLower();
                try {
                    String string2 = "//" + (String)RemoteExperiment.this.m_remoteHosts.elementAt(n2) + "/RemoteEngine";
                    Compute compute = (Compute)Naming.lookup(string2);
                    RemoteExperiment.this.notifyListeners(false, true, false, "Starting " + string + " on host " + (String)RemoteExperiment.this.m_remoteHosts.elementAt(n2));
                    Object object = compute.executeTask(remoteExperimentSubTask);
                    boolean bl = false;
                    TaskStatusInfo taskStatusInfo = null;
                    while (!bl) {
                        try {
                            Thread.sleep(2000L);
                            TaskStatusInfo taskStatusInfo2 = (TaskStatusInfo)compute.checkStatus(object);
                            if (taskStatusInfo2.getExecutionStatus() == 3) {
                                RemoteExperiment.this.notifyListeners(false, true, false, taskStatusInfo2.getStatusMessage());
                                ((RemoteExperiment)RemoteExperiment.this).m_remoteHostsStatus[n2] = 0;
                                RemoteExperiment.this.incrementFinished();
                                RemoteExperiment.this.availableHost(n2);
                                bl = true;
                                continue;
                            }
                            if (taskStatusInfo2.getExecutionStatus() == 2) {
                                RemoteExperiment.this.notifyListeners(false, true, false, taskStatusInfo2.getStatusMessage());
                                ((RemoteExperiment)RemoteExperiment.this).m_remoteHostsStatus[n2] = 3;
                                RemoteExperiment.this.m_subExpComplete[n] = 2;
                                RemoteExperiment.this.notifyListeners(false, true, false, string + " " + taskStatusInfo2.getStatusMessage() + ". Scheduling for execution on another host.");
                                RemoteExperiment.this.incrementFailed(n2);
                                RemoteExperiment.this.waitingExperiment(n);
                                RemoteExperiment.this.availableHost(n2);
                                bl = true;
                                continue;
                            }
                            if (taskStatusInfo == null) {
                                taskStatusInfo = taskStatusInfo2;
                                RemoteExperiment.this.notifyListeners(false, true, false, taskStatusInfo2.getStatusMessage());
                                continue;
                            }
                            if (taskStatusInfo2.getStatusMessage().compareTo(taskStatusInfo.getStatusMessage()) != 0) {
                                RemoteExperiment.this.notifyListeners(false, true, false, taskStatusInfo2.getStatusMessage());
                            }
                            taskStatusInfo = taskStatusInfo2;
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                catch (Exception exception) {
                    ((RemoteExperiment)RemoteExperiment.this).m_remoteHostsStatus[n2] = 2;
                    RemoteExperiment.this.m_subExpComplete[n] = 0;
                    System.err.println(exception);
                    exception.printStackTrace();
                    RemoteExperiment.this.notifyListeners(false, true, false, "Connection to " + (String)RemoteExperiment.this.m_remoteHosts.elementAt(n2) + " failed. Scheduling " + string + " for execution on another host.");
                    RemoteExperiment.this.checkForAllFailedHosts();
                    RemoteExperiment.this.waitingExperiment(n);
                }
                finally {
                    if (this.isInterrupted()) {
                        System.err.println("Sub exp Interupted!");
                    }
                }
            }
        };
        thread.setPriority(1);
        thread.start();
    }

    public void nextIteration() throws Exception {
    }

    public void advanceCounters() {
    }

    public void postProcess() {
    }

    public void addRemoteHost(String string) {
        this.m_remoteHosts.addElement(string);
    }

    public DefaultListModel getRemoteHosts() {
        return this.m_remoteHosts;
    }

    public void setRemoteHosts(DefaultListModel defaultListModel) {
        this.m_remoteHosts = defaultListModel;
    }

    public String toString() {
        String string = this.m_baseExperiment.toString();
        string = string + "\nRemote Hosts:\n";
        for (int i = 0; i < this.m_remoteHosts.size(); ++i) {
            string = string + (String)this.m_remoteHosts.elementAt(i) + '\n';
        }
        return string;
    }

    public void runExperiment() {
        int n = this.m_remoteHostsQueue.size();
        for (int i = 0; i < n; ++i) {
            this.availableHost(-1);
        }
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            RemoteExperiment remoteExperiment = null;
            String string = Utils.getOption("xml", stringArray);
            if (!string.equals("")) {
                stringArray = new XMLOptions(string).toArray();
            }
            Experiment experiment = null;
            String string2 = Utils.getOption('l', stringArray);
            String string3 = Utils.getOption('s', stringArray);
            boolean bl = Utils.getFlag('r', stringArray);
            FastVector fastVector = new FastVector();
            String string4 = " ";
            while (string4.length() != 0) {
                string4 = Utils.getOption('h', stringArray);
                if (string4.length() == 0) continue;
                fastVector.addElement(string4);
            }
            if (string2.length() == 0) {
                experiment = new Experiment();
                try {
                    experiment.setOptions(stringArray);
                    Utils.checkForRemainingOptions(stringArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String string5 = "Usage:\n\n-l <exp file>\n\tLoad experiment from file (default use cli options)\n-s <exp file>\n\tSave experiment to file after setting other options\n\t(default don't save)\n-h <remote host name>\n\tHost to run experiment on (may be specified more than once\n\tfor multiple remote hosts)\n-r \n\tRun experiment on (default don't run)\n-xml <filename | xml-string>\n\tget options from XML-Data instead from parameters\n\n";
                    Enumeration enumeration = experiment.listOptions();
                    while (enumeration.hasMoreElements()) {
                        Option option = (Option)enumeration.nextElement();
                        string5 = string5 + option.synopsis() + "\n";
                        string5 = string5 + option.description() + "\n";
                    }
                    throw new Exception(string5 + "\n" + exception.getMessage());
                }
            } else {
                Object object2;
                if (KOML.isPresent() && string2.toLowerCase().endsWith(".koml")) {
                    object2 = KOML.read(string2);
                } else if (string2.toLowerCase().endsWith(".xml")) {
                    object = new XMLExperiment();
                    object2 = ((XMLSerialization)object).read(string2);
                } else {
                    object = new FileInputStream(string2);
                    ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream((InputStream)object));
                    object2 = objectInputStream.readObject();
                    objectInputStream.close();
                }
                if (object2 instanceof RemoteExperiment) {
                    remoteExperiment = (RemoteExperiment)object2;
                } else {
                    experiment = (Experiment)object2;
                }
            }
            if (experiment != null) {
                remoteExperiment = new RemoteExperiment(experiment);
            }
            for (int i = 0; i < fastVector.size(); ++i) {
                remoteExperiment.addRemoteHost((String)fastVector.elementAt(i));
            }
            System.err.println("Experiment:\n" + remoteExperiment.toString());
            if (string3.length() != 0) {
                if (KOML.isPresent() && string3.toLowerCase().endsWith(".koml")) {
                    KOML.write(string3, (Object)remoteExperiment);
                } else if (string3.toLowerCase().endsWith(".xml")) {
                    XMLExperiment xMLExperiment = new XMLExperiment();
                    xMLExperiment.write(string3, (Object)remoteExperiment);
                } else {
                    FileOutputStream fileOutputStream = new FileOutputStream(string3);
                    object = new ObjectOutputStream(new BufferedOutputStream(fileOutputStream));
                    ((ObjectOutputStream)object).writeObject(remoteExperiment);
                    ((ObjectOutputStream)object).close();
                }
            }
            if (bl) {
                System.err.println("Initializing...");
                remoteExperiment.initialize();
                System.err.println("Iterating...");
                remoteExperiment.runExperiment();
                System.err.println("Postprocessing...");
                remoteExperiment.postProcess();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

