/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.ContingencyTables;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.SparseInstance;
import weka.core.SpecialFunctions;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.UnassignedClassException;
import weka.core.UnsupportedClassTypeException;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.SupervisedFilter;

public class Discretize
extends Filter
implements SupervisedFilter,
OptionHandler,
WeightedInstancesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -3141006402280129097L;
    protected Range m_DiscretizeCols = new Range();
    protected double[][] m_CutPoints = null;
    protected boolean m_MakeBinary = false;
    protected boolean m_UseBetterEncoding = false;
    protected boolean m_UseKononenko = false;

    public Discretize() {
        this.setAttributeIndices("first-last");
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(7);
        vector.addElement(new Option("\tSpecifies list of columns to Discretize. First and last are valid indexes.\n\t(default none)", "R", 1, "-R <col1,col2-col4,...>"));
        vector.addElement(new Option("\tInvert matching sense of column indexes.", "V", 0, "-V"));
        vector.addElement(new Option("\tOutput binary attributes for discretized attributes.", "D", 0, "-D"));
        vector.addElement(new Option("\tUse better encoding of split point for MDL.", "E", 0, "-E"));
        vector.addElement(new Option("\tUse Kononenko's MDL criterion.", "K", 0, "-K"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setMakeBinary(Utils.getFlag('D', stringArray));
        this.setUseBetterEncoding(Utils.getFlag('E', stringArray));
        this.setUseKononenko(Utils.getFlag('K', stringArray));
        this.setInvertSelection(Utils.getFlag('V', stringArray));
        String string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setAttributeIndices(string);
        } else {
            this.setAttributeIndices("first-last");
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[12];
        int n = 0;
        if (this.getMakeBinary()) {
            stringArray[n++] = "-D";
        }
        if (this.getUseBetterEncoding()) {
            stringArray[n++] = "-E";
        }
        if (this.getUseKononenko()) {
            stringArray[n++] = "-K";
        }
        if (this.getInvertSelection()) {
            stringArray[n++] = "-V";
        }
        if (!this.getAttributeIndices().equals("")) {
            stringArray[n++] = "-R";
            stringArray[n++] = this.getAttributeIndices();
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.m_DiscretizeCols.setUpper(instances.numAttributes() - 1);
        this.m_CutPoints = null;
        if (instances.classIndex() < 0) {
            throw new UnassignedClassException("Cannot use class-based discretization: no class assigned to the dataset");
        }
        if (!instances.classAttribute().isNominal()) {
            throw new UnsupportedClassTypeException("Supervised discretization not possible: class is not nominal!");
        }
        return false;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_CutPoints != null) {
            this.convertInstance(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_CutPoints == null) {
            this.calculateCutPoints();
            this.setOutputFormat();
            for (int i = 0; i < this.getInputFormat().numInstances(); ++i) {
                this.convertInstance(this.getInputFormat().instance(i));
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    public String globalInfo() {
        return "An instance filter that discretizes a range of numeric attributes in the dataset into nominal attributes. Discretization is by Fayyad & Irani's MDL method (the default).\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Usama M. Fayyad and Keki B. Irani");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Multi-interval discretization of continuousvalued attributes for classification learning");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "Thirteenth International Joint Conference on Articial Intelligence");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1993");
        technicalInformation.setValue(TechnicalInformation.Field.VOLUME, "2");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "1022-1027");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann Publishers");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "Igor Kononenko");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "On Biases in Estimating Multi-Valued Attributes");
        technicalInformation2.setValue(TechnicalInformation.Field.BOOKTITLE, "14th International Joint Conference on Articial Intelligence");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "1995");
        technicalInformation2.setValue(TechnicalInformation.Field.PAGES, "1034-1040");
        technicalInformation2.setValue(TechnicalInformation.Field.PS, "http://ai.fri.uni-lj.si/papers/kononenko95-ijcai.ps.gz");
        return technicalInformation;
    }

    public String makeBinaryTipText() {
        return "Make resulting attributes binary.";
    }

    public boolean getMakeBinary() {
        return this.m_MakeBinary;
    }

    public void setMakeBinary(boolean bl) {
        this.m_MakeBinary = bl;
    }

    public String useKononenkoTipText() {
        return "Use Kononenko's MDL criterion. If set to false uses the Fayyad & Irani criterion.";
    }

    public boolean getUseKononenko() {
        return this.m_UseKononenko;
    }

    public void setUseKononenko(boolean bl) {
        this.m_UseKononenko = bl;
    }

    public String useBetterEncodingTipText() {
        return "Uses a more efficient split point encoding.";
    }

    public boolean getUseBetterEncoding() {
        return this.m_UseBetterEncoding;
    }

    public void setUseBetterEncoding(boolean bl) {
        this.m_UseBetterEncoding = bl;
    }

    public String invertSelectionTipText() {
        return "Set attribute selection mode. If false, only selected (numeric) attributes in the range will be discretized; if true, only non-selected attributes will be discretized.";
    }

    public boolean getInvertSelection() {
        return this.m_DiscretizeCols.getInvert();
    }

    public void setInvertSelection(boolean bl) {
        this.m_DiscretizeCols.setInvert(bl);
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on. This is a comma separated list of attribute indices, with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\".";
    }

    public String getAttributeIndices() {
        return this.m_DiscretizeCols.getRanges();
    }

    public void setAttributeIndices(String string) {
        this.m_DiscretizeCols.setRanges(string);
    }

    public void setAttributeIndicesArray(int[] nArray) {
        this.setAttributeIndices(Range.indicesToRangeList(nArray));
    }

    public double[] getCutPoints(int n) {
        if (this.m_CutPoints == null) {
            return null;
        }
        return this.m_CutPoints[n];
    }

    protected void calculateCutPoints() {
        Instances instances = null;
        this.m_CutPoints = new double[this.getInputFormat().numAttributes()][];
        for (int i = this.getInputFormat().numAttributes() - 1; i >= 0; --i) {
            if (!this.m_DiscretizeCols.isInRange(i) || !this.getInputFormat().attribute(i).isNumeric()) continue;
            if (instances == null) {
                instances = new Instances(this.getInputFormat());
            }
            this.calculateCutPointsByMDL(i, instances);
        }
    }

    protected void calculateCutPointsByMDL(int n, Instances instances) {
        instances.sort(instances.attribute(n));
        int n2 = instances.numInstances();
        for (int i = 0; i < instances.numInstances(); ++i) {
            if (!instances.instance(i).isMissing(n)) continue;
            n2 = i;
            break;
        }
        this.m_CutPoints[n] = this.cutPointsForSubset(instances, n, 0, n2);
    }

    private boolean KononenkosMDL(double[] dArray, double[][] dArray2, double d, int n) {
        int n2;
        double d2 = 0.0;
        double d3 = 0.0;
        int n3 = 0;
        for (n2 = 0; n2 < dArray.length; ++n2) {
            if (!(dArray[n2] > 0.0)) continue;
            ++n3;
        }
        double d4 = SpecialFunctions.log2Binomial(d + (double)n3 - 1.0, n3 - 1);
        double d5 = SpecialFunctions.log2Multinomial(d, dArray);
        double d6 = d5 + d4;
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            double d7 = Utils.sum(dArray2[n2]);
            d2 += SpecialFunctions.log2Binomial(d7 + (double)n3 - 1.0, n3 - 1);
            d3 += SpecialFunctions.log2Multinomial(d7, dArray2[n2]);
        }
        double d8 = Utils.log2(n) + d2 + d3;
        return d6 > d8;
    }

    private boolean FayyadAndIranisMDL(double[] dArray, double[][] dArray2, double d, int n) {
        int n2;
        double d2 = ContingencyTables.entropy(dArray);
        double d3 = ContingencyTables.entropyConditionedOnRows(dArray2);
        double d4 = d2 - d3;
        int n3 = 0;
        for (n2 = 0; n2 < dArray.length; ++n2) {
            if (!(dArray[n2] > 0.0)) continue;
            ++n3;
        }
        int n4 = 0;
        for (n2 = 0; n2 < dArray2[0].length; ++n2) {
            if (!(dArray2[0][n2] > 0.0)) continue;
            ++n4;
        }
        int n5 = 0;
        for (n2 = 0; n2 < dArray2[1].length; ++n2) {
            if (!(dArray2[1][n2] > 0.0)) continue;
            ++n5;
        }
        double d5 = ContingencyTables.entropy(dArray2[0]);
        double d6 = ContingencyTables.entropy(dArray2[1]);
        double d7 = Utils.log2(Math.pow(3.0, n3) - 2.0) - ((double)n3 * d2 - (double)n5 * d6 - (double)n4 * d5);
        return d4 > (Utils.log2(n) + d7) / d;
    }

    private double[] cutPointsForSubset(Instances instances, int n, int n2, int n3) {
        double d;
        double d2;
        int n4;
        double d3 = -1.7976931348623157E308;
        double d4 = -1.0;
        int n5 = -1;
        int n6 = 0;
        int n7 = 0;
        if (n3 - n2 < 2) {
            return null;
        }
        double[][] dArray = new double[2][instances.numClasses()];
        for (n4 = n2; n4 < n3; ++n4) {
            n6 = (int)((double)n6 + instances.instance(n4).weight());
            double[] dArray2 = dArray[1];
            int n8 = (int)instances.instance(n4).classValue();
            dArray2[n8] = dArray2[n8] + instances.instance(n4).weight();
        }
        double[] dArray3 = new double[instances.numClasses()];
        System.arraycopy(dArray[1], 0, dArray3, 0, instances.numClasses());
        double d5 = d2 = ContingencyTables.entropy(dArray3);
        double[][] dArray4 = new double[2][instances.numClasses()];
        for (n4 = n2; n4 < n3 - 1; ++n4) {
            double[] dArray5 = dArray[0];
            int n9 = (int)instances.instance(n4).classValue();
            dArray5[n9] = dArray5[n9] + instances.instance(n4).weight();
            double[] dArray6 = dArray[1];
            int n10 = (int)instances.instance(n4).classValue();
            dArray6[n10] = dArray6[n10] - instances.instance(n4).weight();
            if (!(instances.instance(n4).value(n) < instances.instance(n4 + 1).value(n))) continue;
            d3 = (instances.instance(n4).value(n) + instances.instance(n4 + 1).value(n)) / 2.0;
            double d6 = ContingencyTables.entropyConditionedOnRows(dArray);
            if (d6 < d5) {
                d4 = d3;
                d5 = d6;
                n5 = n4;
                System.arraycopy(dArray[0], 0, dArray4[0], 0, instances.numClasses());
                System.arraycopy(dArray[1], 0, dArray4[1], 0, instances.numClasses());
            }
            ++n7;
        }
        if (!this.m_UseBetterEncoding) {
            n7 = n3 - n2 - 1;
        }
        if ((d = d2 - d5) <= 0.0) {
            return null;
        }
        if (this.m_UseKononenko && this.KononenkosMDL(dArray3, dArray4, n6, n7) || !this.m_UseKononenko && this.FayyadAndIranisMDL(dArray3, dArray4, n6, n7)) {
            double[] dArray7;
            double[] dArray8 = this.cutPointsForSubset(instances, n, n2, n5 + 1);
            double[] dArray9 = this.cutPointsForSubset(instances, n, n5 + 1, n3);
            if (dArray8 == null && dArray9 == null) {
                dArray7 = new double[]{d4};
            } else if (dArray9 == null) {
                dArray7 = new double[dArray8.length + 1];
                System.arraycopy(dArray8, 0, dArray7, 0, dArray8.length);
                dArray7[dArray8.length] = d4;
            } else if (dArray8 == null) {
                dArray7 = new double[1 + dArray9.length];
                dArray7[0] = d4;
                System.arraycopy(dArray9, 0, dArray7, 1, dArray9.length);
            } else {
                dArray7 = new double[dArray8.length + dArray9.length + 1];
                System.arraycopy(dArray8, 0, dArray7, 0, dArray8.length);
                dArray7[dArray8.length] = d4;
                System.arraycopy(dArray9, 0, dArray7, dArray8.length + 1, dArray9.length);
            }
            return dArray7;
        }
        return null;
    }

    protected void setOutputFormat() {
        if (this.m_CutPoints == null) {
            this.setOutputFormat(null);
            return;
        }
        FastVector fastVector = new FastVector(this.getInputFormat().numAttributes());
        int n = this.getInputFormat().classIndex();
        for (int i = 0; i < this.getInputFormat().numAttributes(); ++i) {
            if (this.m_DiscretizeCols.isInRange(i) && this.getInputFormat().attribute(i).isNumeric()) {
                if (!this.m_MakeBinary) {
                    FastVector fastVector2 = new FastVector(1);
                    if (this.m_CutPoints[i] == null) {
                        fastVector2.addElement("'All'");
                    } else {
                        for (int j = 0; j <= this.m_CutPoints[i].length; ++j) {
                            if (j == 0) {
                                fastVector2.addElement("'(-inf-" + Utils.doubleToString(this.m_CutPoints[i][j], 6) + "]'");
                                continue;
                            }
                            if (j == this.m_CutPoints[i].length) {
                                fastVector2.addElement("'(" + Utils.doubleToString(this.m_CutPoints[i][j - 1], 6) + "-inf)'");
                                continue;
                            }
                            fastVector2.addElement("'(" + Utils.doubleToString(this.m_CutPoints[i][j - 1], 6) + "-" + Utils.doubleToString(this.m_CutPoints[i][j], 6) + "]'");
                        }
                    }
                    fastVector.addElement(new Attribute(this.getInputFormat().attribute(i).name(), fastVector2));
                    continue;
                }
                if (this.m_CutPoints[i] == null) {
                    FastVector fastVector3 = new FastVector(1);
                    fastVector3.addElement("'All'");
                    fastVector.addElement(new Attribute(this.getInputFormat().attribute(i).name(), fastVector3));
                    continue;
                }
                if (i < this.getInputFormat().classIndex()) {
                    n += this.m_CutPoints[i].length - 1;
                }
                for (int j = 0; j < this.m_CutPoints[i].length; ++j) {
                    FastVector fastVector4 = new FastVector(2);
                    fastVector4.addElement("'(-inf-" + Utils.doubleToString(this.m_CutPoints[i][j], 6) + "]'");
                    fastVector4.addElement("'(" + Utils.doubleToString(this.m_CutPoints[i][j], 6) + "-inf)'");
                    fastVector.addElement(new Attribute(this.getInputFormat().attribute(i).name(), fastVector4));
                }
                continue;
            }
            fastVector.addElement(this.getInputFormat().attribute(i).copy());
        }
        Instances instances = new Instances(this.getInputFormat().relationName(), fastVector, 0);
        instances.setClassIndex(n);
        this.setOutputFormat(instances);
    }

    protected void convertInstance(Instance instance) {
        int n = 0;
        double[] dArray = new double[this.outputFormatPeek().numAttributes()];
        for (int i = 0; i < this.getInputFormat().numAttributes(); ++i) {
            if (this.m_DiscretizeCols.isInRange(i) && this.getInputFormat().attribute(i).isNumeric()) {
                int n2;
                double d = instance.value(i);
                if (this.m_CutPoints[i] == null) {
                    dArray[n] = instance.isMissing(i) ? Instance.missingValue() : 0.0;
                    ++n;
                    continue;
                }
                if (!this.m_MakeBinary) {
                    if (instance.isMissing(i)) {
                        dArray[n] = Instance.missingValue();
                    } else {
                        for (n2 = 0; n2 < this.m_CutPoints[i].length && !(d <= this.m_CutPoints[i][n2]); ++n2) {
                        }
                        dArray[n] = n2;
                    }
                    ++n;
                    continue;
                }
                for (n2 = 0; n2 < this.m_CutPoints[i].length; ++n2) {
                    dArray[n] = instance.isMissing(i) ? Instance.missingValue() : (d <= this.m_CutPoints[i][n2] ? 0.0 : 1.0);
                    ++n;
                }
                continue;
            }
            dArray[n] = instance.value(i);
            ++n;
        }
        Instance instance2 = null;
        instance2 = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), dArray) : new Instance(instance.weight(), dArray);
        instance2.setDataset(this.getOutputFormat());
        this.copyValues(instance2, false, instance.dataset(), this.getOutputFormat());
        instance2.setDataset(this.getOutputFormat());
        this.push(instance2);
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new Discretize(), stringArray);
            } else {
                Filter.filterFile(new Discretize(), stringArray);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

