/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.evaluation.ThresholdCurve;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.gui.beans.AbstractEvaluator;
import weka.gui.beans.BatchClassifierEvent;
import weka.gui.beans.BatchClassifierListener;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.TextEvent;
import weka.gui.beans.TextListener;
import weka.gui.beans.ThresholdDataEvent;
import weka.gui.beans.ThresholdDataListener;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.VisualizableErrorEvent;
import weka.gui.beans.VisualizableErrorListener;
import weka.gui.explorer.ClassifierPanel;
import weka.gui.visualize.PlotData2D;

public class ClassifierPerformanceEvaluator
extends AbstractEvaluator
implements BatchClassifierListener,
Serializable,
UserRequestAcceptor,
EventConstraints {
    private transient Evaluation m_eval;
    private transient Classifier m_classifier;
    private transient Thread m_evaluateThread = null;
    private Vector m_textListeners = new Vector();
    private Vector m_thresholdListeners = new Vector();
    private Vector m_visualizableErrorListeners = new Vector();
    private boolean m_rocListenersConnected = false;
    private Instances m_predInstances = null;
    private FastVector m_preds = null;
    private FastVector m_plotShape = null;
    private FastVector m_plotSize = null;

    public ClassifierPerformanceEvaluator() {
        this.m_visual.loadIcons("weka/gui/beans/icons/ClassifierPerformanceEvaluator.gif", "weka/gui/beans/icons/ClassifierPerformanceEvaluator_animated.gif");
        this.m_visual.setText("ClassifierPerformanceEvaluator");
    }

    public String globalInfo() {
        return "Evaluate the performance of batch trained classifiers.";
    }

    public void acceptClassifier(final BatchClassifierEvent batchClassifierEvent) {
        if (batchClassifierEvent.getTestSet().isStructureOnly()) {
            return;
        }
        try {
            if (this.m_evaluateThread == null) {
                this.m_evaluateThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        String string = ClassifierPerformanceEvaluator.this.m_visual.getText();
                        try {
                            block15: {
                                try {
                                    Serializable serializable;
                                    Object object;
                                    Object object2;
                                    if (batchClassifierEvent.getSetNumber() == 1 || batchClassifierEvent.getClassifier() != ClassifierPerformanceEvaluator.this.m_classifier) {
                                        ClassifierPerformanceEvaluator.this.m_eval = new Evaluation(batchClassifierEvent.getTestSet().getDataSet());
                                        ClassifierPerformanceEvaluator.this.m_classifier = batchClassifierEvent.getClassifier();
                                        ClassifierPerformanceEvaluator.this.m_predInstances = ClassifierPanel.setUpVisualizableInstances(new Instances(batchClassifierEvent.getTestSet().getDataSet()));
                                        ClassifierPerformanceEvaluator.this.m_preds = new FastVector();
                                        ClassifierPerformanceEvaluator.this.m_plotShape = new FastVector();
                                        ClassifierPerformanceEvaluator.this.m_plotSize = new FastVector();
                                    }
                                    if (batchClassifierEvent.getSetNumber() <= batchClassifierEvent.getMaxSetNumber()) {
                                        ClassifierPerformanceEvaluator.this.m_visual.setText("Evaluating (" + batchClassifierEvent.getSetNumber() + ")...");
                                        if (ClassifierPerformanceEvaluator.this.m_logger != null) {
                                            ClassifierPerformanceEvaluator.this.m_logger.statusMessage("ClassifierPerformaceEvaluator : evaluating (" + batchClassifierEvent.getSetNumber() + ")...");
                                        }
                                        ClassifierPerformanceEvaluator.this.m_visual.setAnimated();
                                        for (int i = 0; i < batchClassifierEvent.getTestSet().getDataSet().numInstances(); ++i) {
                                            object2 = batchClassifierEvent.getTestSet().getDataSet().instance(i);
                                            ClassifierPanel.processClassifierPrediction((Instance)object2, batchClassifierEvent.getClassifier(), ClassifierPerformanceEvaluator.this.m_eval, ClassifierPerformanceEvaluator.this.m_preds, ClassifierPerformanceEvaluator.this.m_predInstances, ClassifierPerformanceEvaluator.this.m_plotShape, ClassifierPerformanceEvaluator.this.m_plotSize);
                                        }
                                    }
                                    if (batchClassifierEvent.getSetNumber() != batchClassifierEvent.getMaxSetNumber()) break block15;
                                    System.err.println(ClassifierPerformanceEvaluator.this.m_eval.toSummaryString());
                                    String string2 = ClassifierPerformanceEvaluator.this.m_classifier.getClass().getName();
                                    string2 = string2.substring(string2.lastIndexOf(46) + 1, string2.length());
                                    object2 = "=== Evaluation result ===\n\nScheme: " + string2 + "\n" + "Relation: " + batchClassifierEvent.getTestSet().getDataSet().relationName() + "\n\n" + ClassifierPerformanceEvaluator.this.m_eval.toSummaryString();
                                    if (batchClassifierEvent.getTestSet().getDataSet().classAttribute().isNominal()) {
                                        object2 = (String)object2 + "\n" + ClassifierPerformanceEvaluator.this.m_eval.toClassDetailsString() + "\n" + ClassifierPerformanceEvaluator.this.m_eval.toMatrixString();
                                    }
                                    TextEvent textEvent = new TextEvent(ClassifierPerformanceEvaluator.this, (String)object2, string2);
                                    ClassifierPerformanceEvaluator.this.notifyTextListeners(textEvent);
                                    if (ClassifierPerformanceEvaluator.this.m_visualizableErrorListeners.size() > 0) {
                                        object = new PlotData2D(ClassifierPerformanceEvaluator.this.m_predInstances);
                                        ((PlotData2D)object).setShapeSize(ClassifierPerformanceEvaluator.this.m_plotSize);
                                        ((PlotData2D)object).setShapeType(ClassifierPerformanceEvaluator.this.m_plotShape);
                                        ((PlotData2D)object).setPlotName(string2 + " (" + batchClassifierEvent.getTestSet().getDataSet().relationName() + ")");
                                        ((PlotData2D)object).addInstanceNumberAttribute();
                                        serializable = new VisualizableErrorEvent(ClassifierPerformanceEvaluator.this, (PlotData2D)object);
                                        ClassifierPerformanceEvaluator.this.notifyVisualizableErrorListeners((VisualizableErrorEvent)serializable);
                                    }
                                    if (batchClassifierEvent.getTestSet().getDataSet().classAttribute().isNominal()) {
                                        object = new ThresholdCurve();
                                        serializable = ((ThresholdCurve)object).getCurve(ClassifierPerformanceEvaluator.this.m_preds, 0);
                                        ((Instances)serializable).setRelationName(batchClassifierEvent.getTestSet().getDataSet().relationName());
                                        PlotData2D plotData2D = new PlotData2D((Instances)serializable);
                                        plotData2D.setPlotName(string2 + " (" + batchClassifierEvent.getTestSet().getDataSet().classAttribute().value(0) + ")");
                                        boolean[] blArray = new boolean[((Instances)serializable).numInstances()];
                                        for (int i = 1; i < blArray.length; ++i) {
                                            blArray[i] = true;
                                        }
                                        plotData2D.setConnectPoints(blArray);
                                        ThresholdDataEvent thresholdDataEvent = new ThresholdDataEvent(ClassifierPerformanceEvaluator.this, plotData2D);
                                        ClassifierPerformanceEvaluator.this.notifyThresholdListeners(thresholdDataEvent);
                                    }
                                    if (ClassifierPerformanceEvaluator.this.m_logger == null) break block15;
                                    ClassifierPerformanceEvaluator.this.m_logger.statusMessage("Done.");
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    Object var11_14 = null;
                                    ClassifierPerformanceEvaluator.this.m_visual.setText(string);
                                    ClassifierPerformanceEvaluator.this.m_visual.setStatic();
                                    ClassifierPerformanceEvaluator.this.m_evaluateThread = null;
                                    if (this.isInterrupted() && ClassifierPerformanceEvaluator.this.m_logger != null) {
                                        ClassifierPerformanceEvaluator.this.m_logger.logMessage("Evaluation interrupted!");
                                        ClassifierPerformanceEvaluator.this.m_logger.statusMessage("OK");
                                    }
                                    ClassifierPerformanceEvaluator.this.block(false);
                                    return;
                                }
                            }
                            Object var11_13 = null;
                            ClassifierPerformanceEvaluator.this.m_visual.setText(string);
                            ClassifierPerformanceEvaluator.this.m_visual.setStatic();
                            ClassifierPerformanceEvaluator.this.m_evaluateThread = null;
                            if (this.isInterrupted() && ClassifierPerformanceEvaluator.this.m_logger != null) {
                                ClassifierPerformanceEvaluator.this.m_logger.logMessage("Evaluation interrupted!");
                                ClassifierPerformanceEvaluator.this.m_logger.statusMessage("OK");
                            }
                            ClassifierPerformanceEvaluator.this.block(false);
                            return;
                        }
                        catch (Throwable throwable) {
                            Object var11_15 = null;
                            ClassifierPerformanceEvaluator.this.m_visual.setText(string);
                            ClassifierPerformanceEvaluator.this.m_visual.setStatic();
                            ClassifierPerformanceEvaluator.this.m_evaluateThread = null;
                            if (this.isInterrupted() && ClassifierPerformanceEvaluator.this.m_logger != null) {
                                ClassifierPerformanceEvaluator.this.m_logger.logMessage("Evaluation interrupted!");
                                ClassifierPerformanceEvaluator.this.m_logger.statusMessage("OK");
                            }
                            ClassifierPerformanceEvaluator.this.block(false);
                            throw throwable;
                        }
                    }
                };
                this.m_evaluateThread.setPriority(1);
                this.m_evaluateThread.start();
                this.block(true);
                this.m_evaluateThread = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void stop() {
        if (this.m_listenee instanceof BeanCommon) {
            System.err.println("Listener is BeanCommon");
            ((BeanCommon)this.m_listenee).stop();
        }
        if (this.m_evaluateThread != null) {
            this.m_evaluateThread.interrupt();
            this.m_evaluateThread.stop();
        }
    }

    private synchronized void block(boolean bl) {
        if (bl) {
            try {
                if (this.m_evaluateThread != null && this.m_evaluateThread.isAlive()) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    public Enumeration enumerateRequests() {
        Vector<String> vector = new Vector<String>(0);
        if (this.m_evaluateThread != null) {
            vector.addElement("Stop");
        }
        return vector.elements();
    }

    public void performRequest(String string) {
        if (string.compareTo("Stop") != 0) {
            throw new IllegalArgumentException(string + " not supported (ClassifierPerformanceEvaluator)");
        }
        this.stop();
    }

    public synchronized void addTextListener(TextListener textListener) {
        this.m_textListeners.addElement(textListener);
    }

    public synchronized void removeTextListener(TextListener textListener) {
        this.m_textListeners.remove(textListener);
    }

    public synchronized void addThresholdDataListener(ThresholdDataListener thresholdDataListener) {
        this.m_thresholdListeners.addElement(thresholdDataListener);
    }

    public synchronized void removeThresholdDataListener(ThresholdDataListener thresholdDataListener) {
        this.m_thresholdListeners.remove(thresholdDataListener);
    }

    public synchronized void addVisualizableErrorListener(VisualizableErrorListener visualizableErrorListener) {
        this.m_visualizableErrorListeners.add(visualizableErrorListener);
    }

    public synchronized void removeVisualizableErrorListener(VisualizableErrorListener visualizableErrorListener) {
        this.m_visualizableErrorListeners.remove(visualizableErrorListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTextListeners(TextEvent textEvent) {
        Vector vector;
        ClassifierPerformanceEvaluator classifierPerformanceEvaluator = this;
        synchronized (classifierPerformanceEvaluator) {
            vector = (Vector)this.m_textListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ((TextListener)vector.elementAt(i)).acceptText(textEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyThresholdListeners(ThresholdDataEvent thresholdDataEvent) {
        Vector vector;
        ClassifierPerformanceEvaluator classifierPerformanceEvaluator = this;
        synchronized (classifierPerformanceEvaluator) {
            vector = (Vector)this.m_thresholdListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ((ThresholdDataListener)vector.elementAt(i)).acceptDataSet(thresholdDataEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyVisualizableErrorListeners(VisualizableErrorEvent visualizableErrorEvent) {
        Vector vector;
        ClassifierPerformanceEvaluator classifierPerformanceEvaluator = this;
        synchronized (classifierPerformanceEvaluator) {
            vector = (Vector)this.m_visualizableErrorListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ((VisualizableErrorListener)vector.elementAt(i)).acceptDataSet(visualizableErrorEvent);
            }
        }
    }

    public boolean eventGeneratable(String string) {
        if (this.m_listenee == null) {
            return false;
        }
        return !(this.m_listenee instanceof EventConstraints) || ((EventConstraints)this.m_listenee).eventGeneratable("batchClassifier");
    }
}

