% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sse.combined}
\alias{sse.combined}
\title{System sensitivity by combining multiple surveillance components}
\usage{
sse.combined(C = NA, pstar.c, rr, ppr, sep)
}
\arguments{
\item{C}{population sizes (number of clusters) for each risk group,
NA or vector of same length as rr}

\item{pstar.c}{cluster level design prevalence (scalar)}

\item{rr}{cluster level relative risks (vector, length
equal to the number of risk strata)}

\item{ppr}{cluster level population proportions (optional),
not required if C is specified (NA or vector of same length as rr)}

\item{sep}{sep values for clusters in each component and
corresponding risk group. A list with multiple elements, each element
is a dataframe of sep values from a separate component,
first column= clusterid, 2nd =cluster-level risk group index, 3rd col = sep}
}
\value{
list of 2 elements, a matrix (or vector if C not specified)
  of population-level (surveillance system)
  sensitivities (binomial and hypergeometric and adjusted vs unadjusted) and
  a matrix of adjusted and unadjusted component sensitivities for each component
}
\description{
Calculates overall system sensitivity for
  multiple components, accounting for lack of independence
  (overlap) between components
}
\examples{
# example for sse.combined (checked in excel combined components.xlsx)
C<- c(300, 1200)
pstar<- 0.01
rr<- c(3,1)
ppr<- c(0.2, 0.8)
comp1<- data.frame(id=1:100, rg=c(rep(1,50), rep(2,50)), cse=rep(0.5,100))
comp2<- data.frame(id=seq(2, 120, by=2), rg=c(rep(1,25), rep(2,35)), cse=runif(60, 0.5, 0.8))
comp3<- data.frame(id=seq(5, 120, by=5), rg=c(rep(1,10), rep(2,14)), cse=runif(24, 0.7, 1))
sep<- list(comp1, comp2, comp3)
sse.combined(C, pstar, rr, sep = sep)
sse.combined(C=NA, pstar, rr, ppr, sep = sep)
}
\keyword{methods}

