% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_api_prj.R
\name{prj_install_deps}
\alias{prj_install_deps}
\title{Installs project dependencies and needed supportive packages.}
\usage{
prj_install_deps(prj = NULL, clean = FALSE, vanilla_sups = FALSE,
  relock = FALSE)
}
\arguments{
\item{prj}{project to collect dependencies for if not passed will build
project for working directory. (type: rsuite_project, default: NULL)}

\item{clean}{if TRUE clear environment before installing package dependencies.
(type: logical, default: FALSE)}

\item{vanilla_sups}{if TRUE install only base supportive packages (like devtools & roxygen2).
(type: logical, default: FALSE)}

\item{relock}{if TRUE allows updating the env.lock file
(type: logical, default: FALSE)}
}
\value{
TRUE if all build successfully.
}
\description{
Installs project dependencies and needed supportive packages.
}
\details{
Logs all messages from the building process onto the rsuite logger. Use
\code{logging::setLevel} to control logs verbosity. DEBUG level turns
on building and downloading messages.
}
\examples{
\donttest{
  # create exemplary project base folder
  prj_base <- tempfile("example_")
  dir.create(prj_base, recursive = TRUE, showWarnings = FALSE)

  # start project
  prj <- prj_start("my_project", skip_rc = TRUE, path = prj_base)

  # reinstall logging package into project environment
  prj_install_deps(prj = prj, clean = TRUE)
}

}
\seealso{
Other in project management: \code{\link{prj_build}},
  \code{\link{prj_clean_deps}}, \code{\link{prj_init}},
  \code{\link{prj_load}}, \code{\link{prj_lock_env}},
  \code{\link{prj_pack}}, \code{\link{prj_start_package}},
  \code{\link{prj_start}}, \code{\link{prj_unload}},
  \code{\link{prj_zip}}
}
