% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSLI.R
\name{readSLI}
\alias{readSLI}
\title{Read ENVI spectral libraries}
\usage{
readSLI(path)
}
\arguments{
\item{path}{Path to spectral library file with ending .sli.}
}
\value{
The spectral libraries are read into a data.frame. The first column contains the wavelengths and the remaining columns contain the spectra.
}
\description{
read/write support for ENVI spectral libraries
}
\details{
ENVI spectral libraries consist of a binary data file (.sli) and a corresponding header (.hdr, or .sli.hdr) file.
}
\examples{
## Create fake spectra
data <- data.frame(wavelength=350:2500, spectrumA=cumsum(abs(rnorm(2151))), 
						spectrumB=cumsum(abs(rnorm(2151))))
pathToFile <- paste0(tempdir(),"/specLib.sli")

## Write to binary spectral library
writeSLI(x = data, path = pathToFile)

## Read from binary spectral library
dataRe <- readSLI(path = pathToFile)

## Check whether they are the same
all.equal(data, dataRe)
}
\seealso{
\code{\link{writeSLI}}
}

