/*
 * Decompiled with CFR 0.152.
 */
package org.act.sim;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.act.cat.CatFunctions;
import org.act.cat.ExposureItemUsage;
import org.act.cat.ItemScores;
import org.act.cat.ThetaRange;
import org.act.util.ContentTable;
import org.apache.commons.math3.distribution.BinomialDistribution;
import org.apache.commons.math3.linear.RealMatrix;

public final class SimulationFunctions {
    private SimulationFunctions() {
    }

    public static ItemScores simItemScores(RealMatrix itemPar, double thetaTrue) {
        int nItems = itemPar.getRowDimension();
        int[] itemScoreInt = new int[nItems];
        double[] respProb = new double[nItems];
        for (int i = 0; i < nItems; ++i) {
            int sampleBinomial;
            double a = itemPar.getEntry(i, 0);
            double b = itemPar.getEntry(i, 1);
            double c = itemPar.getEntry(i, 2);
            double D = itemPar.getEntry(i, 3);
            double p = CatFunctions.getProb3PL(a, b, c, D, thetaTrue);
            BinomialDistribution distBinomial = new BinomialDistribution(1, p);
            itemScoreInt[i] = sampleBinomial = distBinomial.sample();
            respProb[i] = p;
        }
        ItemScores itemScores = new ItemScores(itemScoreInt, respProb);
        return itemScores;
    }

    public static Map<String, Integer> getItemIdToPassageIndexMap(ContentTable itemPool, ContentTable passagePool) {
        HashMap<String, Integer> passageIdToIndexMap = new HashMap<String, Integer>();
        if (passagePool != null) {
            for (int i = 0; i < passagePool.rows().size(); ++i) {
                passageIdToIndexMap.put(passagePool.rows().get(i).get(0), i);
            }
        }
        HashMap<String, Integer> itemIdToPassageIndexMap = new HashMap<String, Integer>();
        if (itemPool != null) {
            for (int i = 0; i < itemPool.rows().size(); ++i) {
                Integer index;
                String passageId = itemPool.rows().get(i).get(1);
                if ("NONE".equalsIgnoreCase(passageId) || (index = (Integer)passageIdToIndexMap.get(passageId)) == null) continue;
                String itemId = itemPool.rows().get(i).get(0);
                itemIdToPassageIndexMap.put(itemId, index);
            }
        }
        return itemIdToPassageIndexMap;
    }

    public static List<Integer> getPassageIndexOrderForAdministeredItems(Map<String, Integer> itemIdToPassageIndexMap, List<String> administeredItems) {
        ArrayList<Integer> passageIndexOrder = new ArrayList<Integer>();
        for (String item : administeredItems) {
            Integer index = itemIdToPassageIndexMap.get(item);
            if (index == null) continue;
            if (passageIndexOrder.size() == 0) {
                passageIndexOrder.add(index);
                continue;
            }
            if (((Integer)passageIndexOrder.get(passageIndexOrder.size() - 1)).equals(index)) continue;
            passageIndexOrder.add(index);
        }
        return passageIndexOrder;
    }

    public static Map<ThetaRange, Map<String, Double>> calItemExposureRates(Map<ThetaRange, Map<String, ExposureItemUsage>> exposureItemUsageRangeMap, int numExaminee) {
        HashMap<ThetaRange, Map<String, Double>> exposreRates = new HashMap<ThetaRange, Map<String, Double>>();
        Iterator<ThetaRange> thetaRangeIt = exposureItemUsageRangeMap.keySet().iterator();
        for (ThetaRange thetaRange : exposureItemUsageRangeMap.keySet()) {
            if (!exposreRates.keySet().contains(thetaRange)) {
                exposreRates.put(thetaRange, new HashMap());
            }
            Map<String, ExposureItemUsage> exposureItemUsage = exposureItemUsageRangeMap.get(thetaRange);
            for (Map.Entry<String, ExposureItemUsage> entry : exposureItemUsage.entrySet()) {
                ((Map)exposreRates.get(thetaRange)).put(entry.getKey(), entry.getValue().getAlpha() / (double)numExaminee);
            }
        }
        return exposreRates;
    }
}

